/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public abstract class DefaultScreen
extends class_437 {
    protected int BG_WIDTH;
    protected int BG_HEIGHT;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected static final int DEFAULT_TEXT_COLOR = TextColors.DEFAULT;
    protected int startX;
    protected int centerX;
    protected int endX;
    protected int backgroundWidth;
    protected int startY;
    protected int centerY;
    protected int endY;
    protected int backgroundHeight;

    protected DefaultScreen(class_2561 name, int widthX, int widthY, int offsetX, int offsetY) {
        super(name);
        this.BG_WIDTH = widthX;
        this.BG_HEIGHT = widthY;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.calculateCoordinates();
    }

    protected DefaultScreen(class_2561 name, int widthX, int widthY) {
        super(name);
        this.BG_WIDTH = widthX;
        this.BG_HEIGHT = widthY;
        this.calculateCoordinates();
    }

    public DefaultScreen(class_2561 name) {
        super(name);
        this.BG_WIDTH = 320;
        this.BG_HEIGHT = 180;
        this.calculateCoordinates();
    }

    public void calculateCoordinates() {
        this.startX = (this.field_22789 - this.BG_WIDTH) / 2 + this.offsetX;
        this.endX = this.startX + this.BG_WIDTH;
        this.centerX = (this.startX + this.endX) / 2;
        this.backgroundWidth = this.endX - this.startX;
        this.startY = (this.field_22790 - this.BG_HEIGHT) / 2 + this.offsetY;
        this.endY = this.startY + this.BG_HEIGHT;
        this.centerY = (this.startY + this.endY) / 2;
        this.backgroundHeight = this.endY - this.startY;
    }

    public boolean allowCloseButton() {
        return true;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0 && this.allowCloseButton() && this.isInCloseRegion((int)click.comp_4798(), (int)click.comp_4799())) {
            this.closeButtonClicked();
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public void closeButtonClicked() {
        this.method_25419();
    }

    public boolean isInCloseRegion(int x, int y) {
        double width = this.field_22793.method_27525((class_5348)class_2561.method_30163((String)"\u2716"));
        double middleX = (double)(this.endX - 4) - width / 2.0;
        Objects.requireNonNull(this.field_22793);
        double height = 9.0;
        double middleY = (double)(this.startY + 4) + height / 2.0;
        return Math.abs((double)x - middleX) <= width / 2.0 && Math.abs((double)y - middleY) <= height / 2.0;
    }

    protected void method_25426() {
        this.calculateCoordinates();
        super.method_25426();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void renderBackground(class_332 context, int mouseX, int mouseY) {
        context.method_25294(this.startX - 2, this.startY - 2, this.endX, this.endY, TextColors.PURE_WHITE);
        context.method_25294(this.startX, this.startY, this.endX + 2, this.endY + 2, TextColors.GUI_GRAY);
        context.method_25294(this.startX, this.startY, this.endX, this.endY, TextColors.GUI_BACKGROUND);
        context.method_25294(this.startX - 1, this.startY - 3, this.endX, this.startY - 2, TextColors.BLACK);
        context.method_25294(this.startX - 3, this.startY - 1, this.startX - 2, this.endY, TextColors.BLACK);
        context.method_25294(this.startX, this.endY + 3, this.endX + 1, this.endY + 2, TextColors.BLACK);
        context.method_25294(this.endX + 3, this.startY, this.endX + 2, this.endY + 1, TextColors.BLACK);
        context.method_25294(this.startX - 2, this.startY - 2, this.startX - 1, this.startY - 1, TextColors.BLACK);
        context.method_25294(this.startX, this.startY, this.startX + 1, this.startY + 1, TextColors.PURE_WHITE);
        context.method_25294(this.endX, this.startY, this.endX + 1, this.startY - 1, TextColors.GUI_BACKGROUND);
        context.method_25294(this.endX, this.startY - 1, this.endX + 1, this.startY - 2, TextColors.BLACK);
        context.method_25294(this.endX + 1, this.startY, this.endX + 2, this.startY - 1, TextColors.BLACK);
        context.method_25294(this.startX, this.endY, this.startX - 1, this.endY + 1, TextColors.GUI_BACKGROUND);
        context.method_25294(this.startX - 1, this.endY, this.startX - 2, this.endY + 1, TextColors.BLACK);
        context.method_25294(this.startX, this.endY + 1, this.startX - 1, this.endY + 2, TextColors.BLACK);
        context.method_25294(this.endX + 1, this.endY + 1, this.endX + 2, this.endY + 2, TextColors.BLACK);
        context.method_25294(this.endX - 1, this.endY - 1, this.endX, this.endY, TextColors.GUI_GRAY);
    }

    public void renderClose(class_332 context, int mouseX, int mouseY) {
        if (this.isInCloseRegion(mouseX, mouseY)) {
            RenderUtils.drawTextRight(context, this.field_22793, class_2561.method_30163((String)"\u00a7l\u2716"), this.endX - 1, this.startY + 1);
        } else {
            RenderUtils.drawTextRight(context, this.field_22793, class_2561.method_30163((String)"\u2716"), this.endX - 1, this.startY + 1);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY);
        this.render(context, mouseX, mouseY);
        if (this.allowCloseButton()) {
            this.renderClose(context, mouseX, mouseY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public abstract void render(class_332 var1, int var2, int var3);
}

