/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.seasons;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.DefaultScreen;
import net.mat0u5.lifeseries.gui.seasons.ChooseExtraSeasonScreen;
import net.mat0u5.lifeseries.gui.seasons.ConfirmSeasonAnswerScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ChooseSeasonScreen
extends DefaultScreen {
    private static final int ROWS = 2;
    private static final int LOGO_TEXTURE_SIZE = 256;
    private static final float LOGO_SCALE = 0.25f;
    private static final int LOGO_SIZE = 64;
    public static final int PADDING = 8;
    public static boolean hasSelectedBefore = false;
    private List<SeasonRegion> seasonRegions = new ArrayList<SeasonRegion>();

    public ChooseSeasonScreen(boolean hasSelectedBefore) {
        super((class_2561)class_2561.method_43470((String)"Choose Season Screen"), 1.0f, 1.03f);
        ChooseSeasonScreen.hasSelectedBefore = hasSelectedBefore;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.addSeasonRegions();
    }

    public void addSeasonRegions() {
        this.seasonRegions.clear();
        List<Seasons> seasons = Seasons.getSeasons();
        seasons.removeAll(Seasons.getAprilFoolsSeasons());
        List<List<Seasons>> rows = ChooseSeasonScreen.splitIntoRows(seasons, 2);
        int currentRegionIndex = 1;
        int currentY = this.startY + 32;
        for (List<Seasons> row : rows) {
            int columns = row.size();
            int currentX = this.startX + (this.BG_WIDTH - (64 * columns + 8 * (columns - 1))) / 2;
            for (Seasons season : row) {
                this.seasonRegions.add(ChooseSeasonScreen.getSeasonRegion(currentRegionIndex, season, currentX, currentY, 64, 64));
                ++currentRegionIndex;
                currentX += 72;
            }
            currentY += 64;
        }
    }

    public static List<List<Seasons>> splitIntoRows(List<Seasons> seasons, int rows) {
        ArrayList<List<Seasons>> result = new ArrayList<List<Seasons>>();
        int seasonsAdded = 0;
        for (int i = 0; i < rows; ++i) {
            ArrayList<Seasons> row = new ArrayList<Seasons>();
            int columns = seasons.size() / rows;
            if (i < seasons.size() % rows) {
                ++columns;
            }
            for (int j = 0; j < columns; ++j) {
                row.add(seasons.get(j + seasonsAdded));
            }
            seasonsAdded += columns;
            result.add(row);
        }
        return result;
    }

    public static SeasonRegion getSeasonRegion(int regionIndex, Seasons season, int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        return new SeasonRegion(regionIndex, rect, season);
    }

    public int getRegion(int x, int y) {
        for (SeasonRegion region : this.seasonRegions) {
            if (x < region.bounds().x || x > region.bounds().x + region.bounds().width || y < region.bounds().y || y > region.bounds().y + region.bounds().height) continue;
            return region.id();
        }
        class_2561 aprilFools = class_2561.method_30163((String)"April Fools Seasons");
        int textWidth = this.field_22793.method_27525((class_5348)aprilFools);
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        Rectangle rect = new Rectangle(this.endX - 9 - textWidth, this.endY - 9 - textHeight, textWidth + 1, textHeight + 1);
        if (x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int region = this.getRegion((int)mouseX, (int)mouseY);
            if (region == -1 && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ChooseExtraSeasonScreen(hasSelectedBefore));
                return true;
            }
            if (region != 0) {
                this.handleSeasonRegionClick(region);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void handleSeasonRegionClick(int region) {
        for (SeasonRegion seasonRegion : this.seasonRegions) {
            if (seasonRegion.id() != region) continue;
            if (hasSelectedBefore && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfirmSeasonAnswerScreen(this, seasonRegion.season()));
                continue;
            }
            NetworkHandlerClient.sendStringPacket(PacketNames.SET_SEASON, seasonRegion.season().getName());
            this.method_25419();
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        int currentRegion = this.getRegion(mouseX, mouseY);
        for (SeasonRegion seasonRegion : this.seasonRegions) {
            ChooseSeasonScreen.renderSeasonRegion(context, seasonRegion, currentRegion, 256, 0.25f);
        }
        String prompt = "Select the season you want to play.";
        RenderUtils.drawTextCenter(context, this.field_22793, class_2561.method_30163((String)prompt), this.centerX, this.startY + 20);
        class_2561 aprilFools = class_2561.method_30163((String)"April Fools Seasons");
        int textWidth = this.field_22793.method_27525((class_5348)aprilFools);
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        Rectangle rect = new Rectangle(this.endX - 9 - textWidth, this.endY - 9 - textHeight, textWidth + 1, textHeight + 1);
        context.method_25294(rect.x - 1, rect.y - 1, rect.x + rect.width + 1, rect.y, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x - 1, rect.y + rect.height, rect.x + rect.width + 2, rect.y + rect.height + 2, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x - 1, rect.y, rect.x, rect.y + rect.height, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x + rect.width, rect.y - 1, rect.x + rect.width + 2, rect.y + rect.height, DEFAULT_TEXT_COLOR);
        if (currentRegion == -1) {
            RenderUtils.drawTextLeft(context, this.field_22793, TextColors.PURE_WHITE, aprilFools, rect.x + 1, rect.y + 1);
        } else {
            RenderUtils.drawTextLeft(context, this.field_22793, DEFAULT_TEXT_COLOR, aprilFools, rect.x + 1, rect.y + 1);
        }
    }

    public static void renderSeasonRegion(class_332 context, SeasonRegion seasonRegion, int currentRegion, int textureSize, float scale) {
        Rectangle rect = seasonRegion.bounds;
        if (seasonRegion.id == currentRegion) {
            context.method_25294(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, TextColors.LIGHT_GRAY);
        }
        RenderUtils.drawTextureScaled(context, seasonRegion.season.getLogo(), rect.x, rect.y, 0, 0, textureSize, textureSize, scale, scale);
    }

    @Environment(value=EnvType.CLIENT)
    public record SeasonRegion(int id, Rectangle bounds, Seasons season) {
    }
}

