/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BoogeymanCommand {
    public static boolean isAllowed() {
        return BoogeymanCommand.getBM().BOOGEYMAN_ENABLED;
    }

    public static boolean checkBanned(class_2168 source) {
        if (BoogeymanCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when the boogeyman has been enabled in the Life Series config."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"boogeyman").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null || !Main.currentSeason.isAlive(source.method_44023()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> BoogeymanCommand.boogeyClear((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null || !Main.currentSeason.isAlive(source.method_44023()))).executes(context -> BoogeymanCommand.boogeyList((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> BoogeymanCommand.addBoogey((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> BoogeymanCommand.removeBoogey((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cure").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> BoogeymanCommand.cureBoogey((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fail").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> BoogeymanCommand.failBoogey((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chooseRandom").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> BoogeymanCommand.boogeyChooseRandom((class_2168)context.getSource()))));
    }

    public static BoogeymanManager getBM() {
        return Main.currentSeason.boogeymanManagerNew;
    }

    public static int failBoogey(class_2168 source, class_3222 target) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        if (!bm.isBoogeyman(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        if (!bm.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing Boogeyman for {}\u00a77...", target));
        }
        bm.playerFailBoogeyman(target);
        return 1;
    }

    public static int cureBoogey(class_2168 source, class_3222 target) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        if (!bm.isBoogeyman(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        bm.cure(target);
        if (!bm.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Curing {}\u00a77...", target));
        }
        return 1;
    }

    public static int addBoogey(class_2168 source, class_3222 target) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        if (bm.isBoogeyman(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is already a Boogeyman"));
            return -1;
        }
        bm.addBoogeymanManually(target);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is now a Boogeyman", target));
        return 1;
    }

    public static int removeBoogey(class_2168 source, class_3222 target) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        if (!bm.isBoogeyman(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        bm.removeBoogeymanManually(target);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is no longer a Boogeyman", target));
        return 1;
    }

    public static int boogeyList(class_2168 source) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        ArrayList<String> allBoogeymen = new ArrayList<String>();
        ArrayList<String> curedBoogeymen = new ArrayList<String>();
        ArrayList<String> failedBoogeymen = new ArrayList<String>();
        for (Boogeyman boogeyman : bm.boogeymen) {
            if (boogeyman.cured) {
                curedBoogeymen.add(boogeyman.name);
                continue;
            }
            if (boogeyman.failed) {
                failedBoogeymen.add(boogeyman.name);
                continue;
            }
            allBoogeymen.add(boogeyman.name);
        }
        if (allBoogeymen.isEmpty()) {
            allBoogeymen.add("\u00a77None");
        }
        if (curedBoogeymen.isEmpty()) {
            curedBoogeymen.add("\u00a77None");
        }
        if (failedBoogeymen.isEmpty()) {
            failedBoogeymen.add("\u00a77None");
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Remaining Boogeymen: {}", allBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Cured Boogeymen: {}", curedBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Failed Boogeymen: {}", failedBoogeymen));
        return 1;
    }

    public static int boogeyClear(class_2168 source) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        bm.resetBoogeymen();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"All Boogeymen have been cleared"));
        return 1;
    }

    public static int boogeyChooseRandom(class_2168 source) {
        if (BoogeymanCommand.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = BoogeymanCommand.getBM();
        if (bm == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Choosing random Boogeymen..."));
        bm.resetBoogeymen();
        bm.prepareToChooseBoogeymen();
        return 1;
    }
}

