/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class GivelifeCommand {
    public static boolean isAllowed() {
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            return false;
        }
        return (Boolean)Main.seasonConfig.GIVELIFE_COMMAND_ENABLED.get(Main.seasonConfig);
    }

    public static boolean checkBanned(class_2168 source) {
        if (GivelifeCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is not available."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"givelife").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> GivelifeCommand.giftLife((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
    }

    public static int giftLife(class_2168 source, class_3222 target) {
        if (GivelifeCommand.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!Main.currentSeason.isAlive(self)) {
            source.method_9213(class_2561.method_30163((String)"You do not have any lives to give"));
            return -1;
        }
        if (!Main.currentSeason.isAlive(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not alive"));
            return -1;
        }
        if (target == self) {
            source.method_9213(class_2561.method_30163((String)"You cannot give a life to yourself"));
            return -1;
        }
        Integer currentLives = Main.currentSeason.getPlayerLives(self);
        if (currentLives == null || currentLives <= 1) {
            source.method_9213(class_2561.method_30163((String)"You cannot give away your last life"));
            return -1;
        }
        Integer targetLives = Main.currentSeason.getPlayerLives(target);
        if (targetLives == null || targetLives >= Main.currentSeason.GIVELIFE_MAX_LIVES) {
            source.method_9213(class_2561.method_30163((String)"That player cannot receive any more lives"));
            return -1;
        }
        class_2561 currentPlayerName = self.method_55423();
        Main.currentSeason.removePlayerLife(self);
        Main.currentSeason.addToLifeNoUpdate(target);
        AnimationUtils.playTotemAnimation(self);
        TaskScheduler.scheduleTask(40, () -> Main.currentSeason.receiveLifeFromOtherPlayer(currentPlayerName, target));
        return 1;
    }
}

