/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.goal;

import net.mat0u5.lifeseries.entity.snail.Snail;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public final class SnailGlideGoal
extends class_1352 {
    @NotNull
    private final Snail mob;
    private final int ticksToWait;
    private int ticksWaited;

    public SnailGlideGoal(@NotNull Snail mob) {
        this.mob = mob;
        this.ticksToWait = 2;
    }

    public boolean method_6264() {
        if (this.mob.gliding) {
            return true;
        }
        if (this.mob.landing) {
            return false;
        }
        if (this.mob.method_18798().field_1351 >= 0.0 || this.mob.method_24828() || this.mob.flying) {
            return false;
        }
        if (this.mob.getDistanceToGroundBlock() <= 1.5) {
            return false;
        }
        if (this.ticksWaited < this.ticksToWait) {
            ++this.ticksWaited;
            return false;
        }
        return true;
    }

    public void method_6269() {
        this.ticksWaited = 0;
        this.mob.gliding = true;
    }

    public boolean method_6266() {
        boolean canWalk = this.mob.canPathToPlayer(false);
        if (!canWalk) {
            this.mob.flying = true;
            return false;
        }
        return this.mob.getBoundPlayer() != null && this.mob.getDistanceToGroundBlock() >= 1.0;
    }

    public void method_6268() {
        this.glideToPlayer();
    }

    public void method_6270() {
        this.mob.gliding = false;
        this.mob.updateNavigation();
        this.mob.updateMoveControl();
        this.mob.playStopFlyAnimation();
    }

    private void glideToPlayer() {
        class_3222 boundPlayer = this.mob.getBoundPlayer();
        if (boundPlayer == null) {
            return;
        }
        class_243 directionToTarget = boundPlayer.method_19538().method_1020(this.mob.method_19538()).method_1029();
        float speedMultiplier = this.mob.method_6029() / 2.0f;
        this.mob.method_18800(directionToTarget.field_1352 * (double)speedMultiplier, -0.1, directionToTarget.field_1350 * (double)speedMultiplier);
    }
}

