/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.doublelife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.config.StringListConfig;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLifeConfig;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class DoubleLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /soulmate";
    public static final String COMMANDS_TEXT = "/claimkill, /lives";
    public static final class_5321<class_8110> SOULMATE_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)class_2960.method_60655((String)"lifeseries", (String)"soulmate"));
    StringListConfig soulmateConfig;
    public boolean ANNOUNCE_SOULMATES = false;
    public SessionAction actionChooseSoulmates = new SessionAction(OtherUtils.minutesToTicks(1), "\u00a77Assign soulmates if necessary \u00a7f[00:01:00]", "Assign Soulmates if necessary"){

        @Override
        public void trigger() {
            DoubleLife.this.rollSoulmates();
        }
    };
    public SessionAction actionRandomTP = new SessionAction(5, "\u00a77Random teleport distribution \u00a7f[00:00:01]", "Random teleport distribution"){

        @Override
        public void trigger() {
            DoubleLife.this.distributePlayers();
        }
    };
    public Map<UUID, UUID> soulmates = new TreeMap<UUID, UUID>();
    public Map<UUID, UUID> soulmatesOrdered = new TreeMap<UUID, UUID>();

    @Override
    public void initialize() {
        super.initialize();
        this.soulmateConfig = new StringListConfig("./config/lifeseries/main", "DO_NOT_MODIFY_doublelife_soulmates.properties");
    }

    @Override
    public Seasons getSeason() {
        return Seasons.DOUBLE_LIFE;
    }

    @Override
    public ConfigManager getConfig() {
        return new DoubleLifeConfig();
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        super.onPlayerJoin(player);
        if (!this.hasAssignedLives(player)) {
            int lives = (Integer)Main.seasonConfig.DEFAULT_LIVES.get(Main.seasonConfig);
            this.setPlayerLives(player, lives);
        }
        if (player == null) {
            return;
        }
        if (!this.hasSoulmate(player)) {
            return;
        }
        if (!this.isSoulmateOnline(player)) {
            return;
        }
        this.syncPlayer(player);
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        if (PermissionManager.isAdmin(player)) {
            player.method_64398(class_2561.method_30163((String)"\u00a77Double Life commands: \u00a7r/lifeseries, /session, /claimkill, /lives, /soulmate"));
        } else {
            player.method_64398(class_2561.method_30163((String)"\u00a77Double Life non-admin commands: \u00a7r/claimkill, /lives"));
        }
        super.onPlayerFinishJoining(player);
    }

    @Override
    public boolean sessionStart() {
        if (super.sessionStart()) {
            this.activeActions.addAll(List.of(this.actionChooseSoulmates, this.actionRandomTP));
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim) {
        class_3222 soulmate = this.getSoulmate(victim);
        if (soulmate != null && soulmate == attacker) {
            return true;
        }
        return super.isAllowedToAttack(attacker, victim);
    }

    @Override
    public void onPlayerRespawn(class_3222 player) {
        super.onPlayerRespawn(player);
        this.syncPlayer(player);
    }

    @Override
    public void reload() {
        super.reload();
        this.ANNOUNCE_SOULMATES = DoubleLifeConfig.ANNOUNCE_SOULMATES.get(Main.seasonConfig);
    }

    public void loadSoulmates() {
        this.soulmates = this.getAllSoulmates();
        this.updateOrderedSoulmates();
    }

    public void updateOrderedSoulmates() {
        this.soulmatesOrdered = new HashMap<UUID, UUID>();
        for (Map.Entry<UUID, UUID> entry : this.soulmates.entrySet()) {
            if (this.soulmatesOrdered.containsKey(entry.getKey()) || this.soulmatesOrdered.containsValue(entry.getKey()) || this.soulmatesOrdered.containsKey(entry.getValue()) || this.soulmatesOrdered.containsValue(entry.getValue())) continue;
            this.soulmatesOrdered.put(entry.getKey(), entry.getValue());
        }
        this.removeSoulmateTags();
        int index = 1;
        for (Map.Entry<UUID, UUID> entry : this.soulmatesOrdered.entrySet()) {
            class_3222 key = PlayerUtils.getPlayer(entry.getKey());
            class_3222 value = PlayerUtils.getPlayer(entry.getValue());
            if (key != null) {
                key.method_5780("soulmate_" + index);
            }
            if (value != null) {
                value.method_5780("soulmate_" + index);
            }
            ++index;
        }
    }

    public void removeSoulmateTags() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            ArrayList tagsCopy = new ArrayList(player.method_5752());
            for (String tag : tagsCopy) {
                if (!tag.startsWith("soulmate_")) continue;
                player.method_5738(tag);
            }
        }
    }

    public void saveSoulmates() {
        this.updateOrderedSoulmates();
        this.setAllSoulmates(this.soulmatesOrdered);
    }

    public boolean isMainSoulmate(class_3222 player) {
        return this.soulmatesOrdered.containsKey(player.method_5667());
    }

    public boolean hasSoulmate(class_3222 player) {
        if (player == null) {
            return false;
        }
        UUID playerUUID = player.method_5667();
        return this.soulmates.containsKey(playerUUID);
    }

    public boolean isSoulmateOnline(class_3222 player) {
        if (Main.server == null) {
            return false;
        }
        if (!this.hasSoulmate(player)) {
            return false;
        }
        UUID soulmateUUID = this.soulmates.get(player.method_5667());
        return PlayerUtils.getPlayer(soulmateUUID) != null;
    }

    @Nullable
    public class_3222 getSoulmate(class_3222 player) {
        if (Main.server == null) {
            return null;
        }
        if (!this.isSoulmateOnline(player)) {
            return null;
        }
        UUID soulmateUUID = this.soulmates.get(player.method_5667());
        return PlayerUtils.getPlayer(soulmateUUID);
    }

    public void setSoulmate(class_3222 player1, class_3222 player2) {
        this.soulmates.put(player1.method_5667(), player2.method_5667());
        this.soulmates.put(player2.method_5667(), player1.method_5667());
        SessionTranscript.soulmate(player1, player2);
        this.syncPlayers(player1, player2);
        this.updateOrderedSoulmates();
    }

    public void resetSoulmate(class_3222 player) {
        UUID playerUUID = player.method_5667();
        HashMap<UUID, UUID> newSoulmates = new HashMap<UUID, UUID>();
        for (Map.Entry<UUID, UUID> entry : this.soulmates.entrySet()) {
            if (entry.getKey().equals(playerUUID) || entry.getValue().equals(playerUUID)) continue;
            newSoulmates.put(entry.getKey(), entry.getValue());
        }
        this.soulmates = newSoulmates;
        this.updateOrderedSoulmates();
    }

    public void resetAllSoulmates() {
        this.soulmates = new HashMap<UUID, UUID>();
        this.soulmatesOrdered = new HashMap<UUID, UUID>();
        this.soulmateConfig.resetProperties("-- DO NOT MODIFY --");
    }

    public void rollSoulmates() {
        List<class_3222> playersToRoll = this.getNonAssignedPlayers();
        PlayerUtils.playSoundToPlayers(playersToRoll, (class_3414)class_3417.field_15015.comp_349());
        PlayerUtils.sendTitleToPlayers(playersToRoll, (class_2561)class_2561.method_43470((String)"3").method_27692(class_124.field_1060), 5, 20, 5);
        TaskScheduler.scheduleTask(25, () -> {
            PlayerUtils.playSoundToPlayers(playersToRoll, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitleToPlayers(playersToRoll, (class_2561)class_2561.method_43470((String)"2").method_27692(class_124.field_1060), 5, 20, 5);
        });
        TaskScheduler.scheduleTask(50, () -> {
            PlayerUtils.playSoundToPlayers(playersToRoll, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitleToPlayers(playersToRoll, (class_2561)class_2561.method_43470((String)"1").method_27692(class_124.field_1060), 5, 20, 5);
        });
        TaskScheduler.scheduleTask(75, () -> {
            PlayerUtils.sendTitleToPlayers(playersToRoll, (class_2561)class_2561.method_43470((String)"Your soulmate is...").method_27692(class_124.field_1060), 10, 50, 20);
            PlayerUtils.playSoundToPlayers(playersToRoll, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"doublelife_soulmate_wait")));
        });
        TaskScheduler.scheduleTask(165, () -> {
            this.chooseRandomSoulmates();
            for (class_3222 player : playersToRoll) {
                class_3222 soulmate;
                class_5250 text = class_2561.method_43470((String)"????").method_27692(class_124.field_1060);
                if (this.hasSoulmate(player) && this.ANNOUNCE_SOULMATES && (soulmate = this.getSoulmate(player)) != null) {
                    text = TextUtils.format("{}", soulmate);
                }
                PlayerUtils.sendTitle(player, (class_2561)text, 20, 60, 20);
                PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"doublelife_soulmate_chosen")));
            }
        });
    }

    public List<class_3222> getNonAssignedPlayers() {
        ArrayList<class_3222> playersToRoll = new ArrayList<class_3222>();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            if (!this.isAlive(player) || this.hasSoulmate(player)) continue;
            playersToRoll.add(player);
        }
        return playersToRoll;
    }

    public void distributePlayers() {
        if (Main.server == null) {
            return;
        }
        List<class_3222> players = this.getNonAssignedPlayers();
        if (players.isEmpty()) {
            return;
        }
        if (players.size() == 1) {
            return;
        }
        PlayerUtils.playSoundToPlayers(players, class_3417.field_14879);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_5738("randomTeleport");
        }
        for (class_3222 player : players) {
            player.method_5780("randomTeleport");
            player.method_64398(class_2561.method_30163((String)"\u00a76Woosh!"));
        }
        class_2784 border = Main.server.method_30002().method_8621();
        OtherUtils.executeCommand("spreadplayers " + border.method_11964() + " " + border.method_11980() + " 0 " + border.method_11965() / 2.0 + " false @a[tag=randomTeleport]");
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"Randomly distributed players."));
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_5738("randomTeleport");
        }
    }

    public void chooseRandomSoulmates() {
        List<class_3222> playersToRoll = this.getNonAssignedPlayers();
        Collections.shuffle(playersToRoll);
        if (playersToRoll.size() % 2 != 0) {
            class_3222 remove = playersToRoll.getFirst();
            playersToRoll.remove(remove);
            PlayerUtils.broadcastMessageToAdmins((class_2561)class_2561.method_43470((String)" [DoubleLife] ").method_10852(remove.method_55423()).method_27693(" was not paired with anyone, as there is an odd number of non-assigned players online."));
        }
        while (!playersToRoll.isEmpty()) {
            class_3222 player1 = playersToRoll.get(0);
            class_3222 player2 = playersToRoll.get(1);
            this.setSoulmate(player1, player2);
            playersToRoll.removeFirst();
            playersToRoll.removeFirst();
        }
        this.saveSoulmates();
    }

    @Override
    public void onPlayerHeal(class_3222 player, float amount) {
        if (player == null) {
            return;
        }
        if (!this.hasSoulmate(player)) {
            return;
        }
        if (!this.isSoulmateOnline(player)) {
            return;
        }
        class_3222 soulmate = this.getSoulmate(player);
        if (soulmate == null) {
            return;
        }
        if (soulmate.method_29504()) {
            return;
        }
        float newHealth = Math.min(soulmate.method_6032() + amount, soulmate.method_6063());
        soulmate.method_6033(newHealth);
        TaskScheduler.scheduleTask(1, () -> this.syncPlayers(player, soulmate));
    }

    @Override
    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
        float newHealth;
        if (source.method_48792().comp_1242().equalsIgnoreCase("soulmate")) {
            return;
        }
        if (amount == 0.0f) {
            return;
        }
        if (player == null) {
            return;
        }
        if (!this.hasSoulmate(player)) {
            return;
        }
        if (!this.isSoulmateOnline(player)) {
            return;
        }
        class_3222 soulmate = this.getSoulmate(player);
        if (soulmate == null) {
            return;
        }
        if (soulmate.method_29504()) {
            return;
        }
        if (soulmate.field_6235 == 0) {
            class_1282 damageSource = new class_1282((class_6880)soulmate.method_37908().method_30349().method_30530(class_7924.field_42534).method_46747(SOULMATE_DAMAGE));
            soulmate.method_64397(PlayerUtils.getServerWorld(soulmate), damageSource, 1.0E-7f);
        }
        if ((newHealth = player.method_6032()) <= 0.0f) {
            newHealth = 0.01f;
        }
        soulmate.method_6033(newHealth);
        TaskScheduler.scheduleTask(1, () -> this.syncPlayers(player, soulmate));
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        super.onPlayerDeath(player, source);
        if (player == null) {
            return;
        }
        if (!this.hasSoulmate(player)) {
            return;
        }
        if (!this.isSoulmateOnline(player)) {
            return;
        }
        class_3222 soulmate = this.getSoulmate(player);
        if (soulmate == null) {
            return;
        }
        if (soulmate.method_29504()) {
            return;
        }
        class_1282 damageSource = new class_1282((class_6880)soulmate.method_37908().method_30349().method_30530(class_7924.field_42534).method_46747(SOULMATE_DAMAGE));
        soulmate.method_6015((class_1309)player);
        soulmate.method_29505((class_1657)player);
        soulmate.method_64397(PlayerUtils.getServerWorld(soulmate), damageSource, 1000.0f);
    }

    public void syncPlayer(class_3222 player) {
        class_3222 soulmate = this.getSoulmate(player);
        this.syncPlayers(player, soulmate);
    }

    public void syncPlayers(class_3222 player, class_3222 soulmate) {
        float sharedHealth;
        if (player == null || soulmate == null) {
            return;
        }
        if (player.method_29504() || soulmate.method_29504()) {
            return;
        }
        if (player.method_6032() != soulmate.method_6032() && (sharedHealth = Math.min(player.method_6032(), soulmate.method_6032())) != 0.0f) {
            player.method_6033(sharedHealth);
            soulmate.method_6033(sharedHealth);
        }
        Integer soulmateLives = this.getPlayerLives(soulmate);
        Integer playerLives = this.getPlayerLives(player);
        if (soulmateLives != null && playerLives != null && !Objects.equals(soulmateLives, playerLives)) {
            int minLives = Math.min(soulmateLives, playerLives);
            this.setPlayerLives(player, minLives);
            this.setPlayerLives(soulmate, minLives);
        }
    }

    public void syncSoulboundLives(class_3222 player) {
        if (player == null) {
            return;
        }
        Integer lives = this.getPlayerLives(player);
        class_3222 soulmate = this.getSoulmate(player);
        if (lives == null) {
            return;
        }
        if (soulmate == null) {
            return;
        }
        if (player.method_29504() || soulmate.method_29504()) {
            return;
        }
        this.setPlayerLives(soulmate, lives);
    }

    public void canFoodHeal(class_3222 player, CallbackInfoReturnable<Boolean> cir) {
        boolean canHealWithSaturationOther;
        boolean orig;
        boolean bl = orig = player.method_6032() > 0.0f && player.method_6032() < player.method_6063();
        if (!orig) {
            cir.setReturnValue((Object)false);
            return;
        }
        DoubleLife doubleLife = (DoubleLife)Main.currentSeason;
        if (!doubleLife.hasSoulmate(player)) {
            return;
        }
        if (!doubleLife.isSoulmateOnline(player)) {
            return;
        }
        if (doubleLife.isMainSoulmate(player)) {
            return;
        }
        class_3222 soulmate = doubleLife.getSoulmate(player);
        if (soulmate == null) {
            return;
        }
        if (soulmate.method_29504()) {
            return;
        }
        boolean bl2 = canHealWithSaturationOther = soulmate.method_7344().method_7589() > 2.0f && soulmate.method_7344().method_7586() >= 20;
        if (canHealWithSaturationOther) {
            cir.setReturnValue((Object)false);
        } else {
            cir.setReturnValue((Object)true);
        }
    }

    public void setAllSoulmates(Map<UUID, UUID> soulmates) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<UUID, UUID> entry : soulmates.entrySet()) {
            list.add(entry.getKey().toString() + "_" + entry.getValue().toString());
        }
        this.soulmateConfig.save(list);
    }

    public Map<UUID, UUID> getAllSoulmates() {
        HashMap<UUID, UUID> loadedSoulmates = new HashMap<UUID, UUID>();
        List<String> list = this.soulmateConfig.load();
        for (String str : list) {
            try {
                String[] split;
                if (!str.contains("_") || (split = str.split("_")).length != 2) continue;
                UUID key = UUID.fromString(split[0]);
                UUID value = UUID.fromString(split[1]);
                loadedSoulmates.put(key, value);
                loadedSoulmates.put(value, key);
            }
            catch (Exception exception) {}
        }
        return loadedSoulmates;
    }
}

