/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mat0u5.lifeseries.Main;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class TextUtils {
    private static HashMap<List<String>, List<String>> emotes = new HashMap();

    public static void setEmotes() {
        emotes.put(List.of("skull"), List.of("\u2620"));
        emotes.put(List.of("smile"), List.of("\u263a"));
        emotes.put(List.of("frown"), List.of("\u2639"));
        emotes.put(List.of("heart"), List.of("\u2764"));
        emotes.put(List.of("copyright"), List.of("\u00a9"));
        emotes.put(List.of("trademark", "tm"), List.of("\u2122"));
    }

    public static String replaceEmotes(String input) {
        for (Map.Entry<List<String>, List<String>> entry : emotes.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            String emoteValue = entry.getValue().get(0);
            for (String emote : entry.getKey()) {
                String emoteCode = ":" + emote + ":";
                input = TextUtils.replaceCaseInsensitive(input, emoteCode, emoteValue);
            }
            if (input.contains(":")) continue;
            return input;
        }
        return input;
    }

    public static String replaceCaseInsensitive(String input, String replaceWhat, String replaceWith) {
        Pattern pattern = Pattern.compile(replaceWhat, 2);
        Matcher matcher = pattern.matcher(input);
        String result = matcher.replaceAll(replaceWith);
        return result;
    }

    public static String toRomanNumeral(int num) {
        String[] romanNumerals = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return num > 0 && num <= romanNumerals.length ? romanNumerals[num - 1] : String.valueOf(num);
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String textToLegacyString(class_2561 text) {
        StringBuilder formattedString = new StringBuilder();
        class_2583 style = text.method_10866();
        if (style.method_10973() != null) {
            formattedString.append(TextUtils.getColorCode(style.method_10973()));
        }
        if (style.method_10984()) {
            formattedString.append("\u00a7l");
        }
        if (style.method_10966()) {
            formattedString.append("\u00a7o");
        }
        if (style.method_10965()) {
            formattedString.append("\u00a7n");
        }
        if (style.method_10986()) {
            formattedString.append("\u00a7m");
        }
        if (style.method_10987()) {
            formattedString.append("\u00a7k");
        }
        formattedString.append(text.getString());
        return formattedString.toString();
    }

    public static String getColorCode(class_5251 color) {
        for (class_124 formatting : class_124.values()) {
            if (formatting.method_532().intValue() != color.method_27716()) continue;
            return "\u00a7" + formatting.method_36145();
        }
        return "";
    }

    public static String removeFormattingCodes(String input) {
        return input.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    public static class_2558 openURLClickEvent(String url) {
        return new class_2558(class_2558.class_2559.field_11749, url);
    }

    public static class_2558 runCommandClickEvent(String command) {
        return new class_2558(class_2558.class_2559.field_11750, command);
    }

    public static class_2558 copyClipboardClickEvent(String copy) {
        return new class_2558(class_2558.class_2559.field_21462, copy);
    }

    public static class_2568 showTextHoverEvent(class_2561 text) {
        return new class_2568(class_2568.class_5247.field_24342, (Object)text);
    }

    public static class_5250 formatPlain(String template, Object ... args) {
        return class_2561.method_43470((String)TextUtils.format(template, args).getString());
    }

    public static class_5250 format(String template, Object ... args) {
        class_5250 result = class_2561.method_43473();
        int argIndex = 0;
        int lastIndex = 0;
        int placeholderIndex = template.indexOf("{}");
        if (placeholderIndex == -1) {
            Main.LOGGER.error("String (" + template + ") formatting does not contain {}.");
        }
        if (args.length <= 0) {
            Main.LOGGER.error("String (" + template + ") formatting does have arguments.");
        }
        if (("_" + template + "_").split("\\{\\}").length - 1 != args.length) {
            Main.LOGGER.error("String (" + template + ") formatting has incorrect number of arguments.");
        }
        while (placeholderIndex != -1 && argIndex < args.length) {
            if (placeholderIndex > lastIndex) {
                String textBefore = template.substring(lastIndex, placeholderIndex);
                result.method_10852((class_2561)class_2561.method_43470((String)textBefore));
            }
            Object arg = args[argIndex];
            result.method_10852(TextUtils.getTextForArgument(arg));
            ++argIndex;
            lastIndex = placeholderIndex + 2;
            placeholderIndex = template.indexOf("{}", lastIndex);
        }
        if (lastIndex < template.length()) {
            String remainingText = template.substring(lastIndex);
            result.method_10852((class_2561)class_2561.method_43470((String)remainingText));
        }
        return result;
    }

    private static class_2561 getTextForArgument(Object arg) {
        if (arg == null) {
            return class_2561.method_43473();
        }
        if (arg instanceof class_2561) {
            class_2561 text = (class_2561)arg;
            return text;
        }
        if (arg instanceof class_3222) {
            class_3222 player = (class_3222)arg;
            return player.method_5476();
        }
        if (arg instanceof List) {
            List list = (List)arg;
            return class_2561.method_30163((String)list.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        return class_2561.method_30163((String)arg.toString());
    }

    public static String pluralize(String text, Integer amount) {
        return TextUtils.pluralize(text, text + "s", amount);
    }

    public static String pluralize(String textSingular, String textPlural, Integer amount) {
        if (amount == null || Math.abs(amount) == 1) {
            return textSingular;
        }
        return textPlural;
    }
}

