/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.pathfinder.PathFinder;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4140;
import net.minecraft.class_7260;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MobSwap
extends Wildcard {
    public static int activatedAt = -1;
    public static int lastDiv0 = 0;
    public static int lastDiv = 0;
    public static int mobsLeftDiv = 0;
    public static int swaps = -1;
    public static double BOSS_CHANCE_MULTIPLIER = 1.0;
    public static int MIN_DELAY = 2400;
    public static int MAX_DELAY = 7200;
    public static int SPAWN_MOBS = 250;
    public static int mobcapMonster = -1;
    public static int mobcapAnimal = -1;
    public static double bossChance = 0.0;
    public static boolean fastAnimalSpawn = false;
    public static final List<Integer> eggSounds = List.of(0, 20, 35, 48, 59, 70, 80, 89, 97, 104, 110, 115, 119, 122, 124, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140);
    private static final Random rnd = new Random();
    public static final Map<class_1299<?>, Integer> entityEntries = new HashMap();

    public static void initializeEntityEntries() {
        entityEntries.put(class_1299.field_38384, 1);
        entityEntries.put(class_1299.field_6108, 2);
        entityEntries.put(class_1299.field_16281, 3);
        entityEntries.put(class_1299.field_6132, 4);
        entityEntries.put(class_1299.field_6140, 5);
        entityEntries.put(class_1299.field_6114, 6);
        entityEntries.put(class_1299.field_6111, 7);
        entityEntries.put(class_1299.field_6113, 8);
        entityEntries.put(class_1299.field_6070, 9);
        entityEntries.put(class_1299.field_6085, 10);
        entityEntries.put(class_1299.field_6067, 11);
        entityEntries.put(class_1299.field_28402, 12);
        entityEntries.put(class_1299.field_6143, 13);
        entityEntries.put(class_1299.field_6057, 14);
        entityEntries.put(class_1299.field_6093, 15);
        entityEntries.put(class_1299.field_6115, 16);
        entityEntries.put(class_1299.field_42622, 17);
        entityEntries.put(class_1299.field_17713, 19);
        entityEntries.put(class_1299.field_37419, 20);
        entityEntries.put(class_1299.field_40116, 20);
        entityEntries.put(class_1299.field_6139, 22);
        entityEntries.put(class_1299.field_6081, 24);
        entityEntries.put(class_1299.field_6104, 26);
        entityEntries.put(class_1299.field_28315, 28);
        entityEntries.put(class_1299.field_17943, 30);
        entityEntries.put(class_1299.field_30052, 32);
        entityEntries.put(class_1299.field_6146, 34);
        entityEntries.put(class_1299.field_6074, 36);
        entityEntries.put(class_1299.field_6087, 38);
        entityEntries.put(class_1299.field_20346, 40);
        entityEntries.put(class_1299.field_6055, 42);
        entityEntries.put(class_1299.field_17714, 44);
        entityEntries.put(class_1299.field_6042, 45);
        entityEntries.put(class_1299.field_22281, 48);
        entityEntries.put(class_1299.field_6050, 50);
        entityEntries.put(class_1299.field_6125, 52);
        entityEntries.put(class_1299.field_6069, 54);
        entityEntries.put(class_1299.field_6079, 56);
        entityEntries.put(class_1299.field_6091, 58);
        entityEntries.put(class_1299.field_6078, 60);
        entityEntries.put(class_1299.field_6105, 62);
        entityEntries.put(class_1299.field_6084, 64);
        entityEntries.put(class_1299.field_6123, 66);
        entityEntries.put(class_1299.field_21973, 68);
        entityEntries.put(class_1299.field_6071, 70);
        entityEntries.put(class_1299.field_6137, 72);
        entityEntries.put(class_1299.field_6098, 74);
        entityEntries.put(class_1299.field_6051, 76);
        entityEntries.put(class_1299.field_6054, 78);
        entityEntries.put(class_1299.field_6046, 80);
        entityEntries.put(class_1299.field_6118, 82);
        entityEntries.put(class_1299.field_6145, 84);
        entityEntries.put(class_1299.field_6090, 86);
        entityEntries.put(class_1299.field_6099, 88);
        entityEntries.put(class_1299.field_6128, 90);
        entityEntries.put(class_1299.field_6107, 92);
        entityEntries.put(class_1299.field_6102, 94);
        entityEntries.put(class_1299.field_6059, 96);
        entityEntries.put(class_1299.field_6076, 98);
        entityEntries.put(class_1299.field_6065, 100);
        entityEntries.put(class_1299.field_25751, 102);
        entityEntries.put(class_1299.field_6109, 104);
        entityEntries.put(class_1299.field_6117, 106);
        entityEntries.put(class_1299.field_23696, 108);
        entityEntries.put(class_1299.field_6134, 110);
    }

    @Override
    public Wildcards getType() {
        return Wildcards.MOB_SWAP;
    }

    @Override
    public void tickSessionOn() {
        if (Main.server == null) {
            return;
        }
        int currentDiv0 = (int)((double)((float)Main.currentSession.passedTime - (float)activatedAt) / 40.0);
        if (lastDiv0 != currentDiv0) {
            int currentDiv = this.getDiv();
            if (lastDiv != currentDiv) {
                this.mobSwap();
                lastDiv = currentDiv;
            }
            lastDiv0 = currentDiv0;
        }
    }

    @Override
    public void activate() {
        activatedAt = (int)Main.currentSession.passedTime;
        lastDiv = 0;
        mobsLeftDiv = 0;
        bossChance = 0.0;
        swaps = -1;
        MobSwap.initializeEntityEntries();
        super.activate();
    }

    @Override
    public void deactivate() {
        MobSwap.killMobSwapMobs();
        super.deactivate();
    }

    public int getDiv() {
        ArrayList<Integer> triggerTimes = new ArrayList<Integer>();
        int lastTime = 0;
        if (MAX_DELAY > 2400) {
            lastTime = 2400;
            if (2400.0 > Main.currentSession.passedTime - (double)activatedAt) {
                triggerTimes.add(2400);
            }
        }
        while (lastTime < Main.currentSession.sessionLength) {
            float sessionProgress = (float)lastTime / (float)Main.currentSession.sessionLength.intValue();
            if (!((double)(lastTime += (int)((float)MAX_DELAY - (sessionProgress = Math.clamp(sessionProgress, 0.0f, 1.0f)) * (float)(MAX_DELAY - MIN_DELAY))) > Main.currentSession.passedTime - (double)activatedAt) || lastTime >= Main.currentSession.sessionLength - MIN_DELAY) continue;
            triggerTimes.add(lastTime);
        }
        return triggerTimes.size();
    }

    public void mobSwap() {
        int timeForSpawning;
        List<class_3222> players = PlayerUtils.getAllPlayers();
        if (++swaps < 1) {
            return;
        }
        SessionTranscript.mobSwap();
        int spawnMobs = Wildcard.isFinale() ? (int)((double)SPAWN_MOBS / 1.5) : SPAWN_MOBS;
        float progress = ((float)Main.currentSession.passedTime - (float)activatedAt) / (float)(Main.currentSession.sessionLength - activatedAt);
        if ((double)progress > 0.7) {
            if (mobsLeftDiv == 0) {
                mobsLeftDiv = lastDiv;
            }
            if (spawnMobs != 0) {
                int totalMobsLeft = mobsLeftDiv * spawnMobs;
                bossChance = 2.0 / (double)totalMobsLeft * BOSS_CHANCE_MULTIPLIER;
            }
        }
        if (swaps > 1) {
            PlayerUtils.playSoundToPlayers(players, class_3417.field_19344);
        }
        MobSwap.killNonNamedMobs();
        mobcapAnimal = 0;
        TaskScheduler.scheduleTask(120, () -> {
            mobcapAnimal = spawnMobs;
            fastAnimalSpawn = true;
        });
        for (int i = timeForSpawning = Math.max(120, (int)((double)spawnMobs / 2.5)); i > 120; i -= 20) {
            TaskScheduler.scheduleTask(i, () -> PlayerUtils.playSoundToPlayers(players, class_3417.field_15219));
        }
        for (int delay : eggSounds) {
            TaskScheduler.scheduleTask(timeForSpawning + delay, () -> PlayerUtils.playSoundToPlayers(players, class_3417.field_15219));
        }
        TaskScheduler.scheduleTask(timeForSpawning + 140, () -> {
            mobcapAnimal = -1;
            fastAnimalSpawn = false;
            WildcardManager.showDots();
        });
        TaskScheduler.scheduleTask(timeForSpawning + 240, () -> {
            PlayerUtils.playSoundToPlayers(players, class_3417.field_15203, 0.2f, 1.0f);
            PlayerUtils.playSoundToPlayers(players, class_3417.field_14905, 0.2f, 1.0f);
            MobSwap.transformNonNamedMobs(progress);
        });
    }

    private static void killNonNamedMobs() {
        if (Main.server == null) {
            return;
        }
        for (class_3218 world : Main.server.method_3738()) {
            ArrayList toKill = new ArrayList();
            world.method_27909().forEach(entity -> {
                if (!(entity instanceof class_1309)) {
                    return;
                }
                if (entity instanceof class_1657) {
                    return;
                }
                if (entity instanceof Snail) {
                    return;
                }
                if (entity instanceof TriviaBot) {
                    return;
                }
                if (entity instanceof PathFinder) {
                    return;
                }
                if (entity.method_16914()) {
                    return;
                }
                toKill.add(entity);
            });
            boolean mobLoot = world.method_64395().method_8355(class_1928.field_19391);
            if (mobLoot) {
                ((class_1928.class_4310)world.method_64395().method_20746(class_1928.field_19391)).method_20758(false, world.method_8503());
            }
            for (class_1297 entity2 : toKill) {
                entity2.method_5768((class_3218)WorldUtils.getEntityWorld(entity2));
            }
            if (!mobLoot) continue;
            ((class_1928.class_4310)world.method_64395().method_20746(class_1928.field_19391)).method_20758(true, world.method_8503());
        }
    }

    private static void transformNonNamedMobs(float progress) {
        int dangerThresholdMin = Math.min(50, (int)(progress * 70.0f));
        int dangerThresholdMax = Math.max(80, Math.min(115, (int)(progress * 50.0f) + 80));
        if (Main.server == null) {
            return;
        }
        for (class_3218 world : Main.server.method_3738()) {
            ArrayList toKill = new ArrayList();
            world.method_27909().forEach(entity -> {
                class_1297 newMob;
                if (!(entity instanceof class_1309)) {
                    return;
                }
                if (entity instanceof class_1657) {
                    return;
                }
                if (entity instanceof Snail) {
                    return;
                }
                if (entity instanceof TriviaBot) {
                    return;
                }
                if (entity instanceof PathFinder) {
                    return;
                }
                if (entity.method_16914()) {
                    return;
                }
                class_1299<?> randomMob = MobSwap.getRandomMob(progress, dangerThresholdMin, dangerThresholdMax);
                if (randomMob != null && (newMob = randomMob.method_47821(world, entity.method_24515(), class_3730.field_16462)) != null) {
                    newMob.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
                    newMob.method_5780("mobswap");
                    if (newMob instanceof class_1308) {
                        class_1308 mobEntity = (class_1308)newMob;
                        mobEntity.method_5971();
                    }
                    if (newMob instanceof class_7260) {
                        class_7260 wardenEntity = (class_7260)newMob;
                        wardenEntity.method_18868().method_24525(class_4140.field_38103, (Object)class_3902.field_17274, 12000000L);
                    }
                }
                toKill.add(entity);
            });
            toKill.forEach(class_1297::method_31472);
        }
    }

    private static class_1299<?> getRandomMob(float progress, int dangerThresholdMin, int dangerThresholdMax) {
        ArrayList possibleMobs = new ArrayList();
        for (Map.Entry<class_1299<?>, Integer> entry : entityEntries.entrySet()) {
            int dangerValue = entry.getValue();
            if (dangerValue < dangerThresholdMin || dangerValue > dangerThresholdMax) continue;
            possibleMobs.add(entry.getKey());
        }
        if ((double)progress > 0.7 && Math.random() < bossChance) {
            double random = Math.random();
            if (random < 0.33) {
                return class_1299.field_38095;
            }
            if (random < 0.66) {
                return class_1299.field_6119;
            }
            return class_1299.field_6086;
        }
        return (class_1299)possibleMobs.get(rnd.nextInt(possibleMobs.size()));
    }

    public static void killMobSwapMobs() {
        if (Main.server == null) {
            return;
        }
        for (class_3218 world : Main.server.method_3738()) {
            ArrayList toKill = new ArrayList();
            world.method_27909().forEach(entity -> {
                if (!(entity instanceof class_1309)) {
                    return;
                }
                if (entity instanceof class_1657) {
                    return;
                }
                if (entity instanceof Snail) {
                    return;
                }
                if (entity instanceof TriviaBot) {
                    return;
                }
                if (entity instanceof PathFinder) {
                    return;
                }
                if (entity.method_16914()) {
                    return;
                }
                if (!entity.method_5752().contains("mobswap")) {
                    return;
                }
                toKill.add(entity);
            });
            boolean mobLoot = world.method_64395().method_8355(class_1928.field_19391);
            if (mobLoot) {
                ((class_1928.class_4310)world.method_64395().method_20746(class_1928.field_19391)).method_20758(false, world.method_8503());
            }
            for (class_1297 entity2 : toKill) {
                entity2.method_5768((class_3218)WorldUtils.getEntityWorld(entity2));
            }
            if (!mobLoot) continue;
            ((class_1928.class_4310)world.method_64395().method_20746(class_1928.field_19391)).method_20758(true, world.method_8503());
        }
    }

    public static void getSpawnCapacity(class_1311 group, CallbackInfoReturnable<Integer> cir) {
        if (group.method_6133().equalsIgnoreCase("monster") && mobcapMonster >= 0) {
            cir.setReturnValue((Object)mobcapMonster);
        } else if (group.method_6133().equalsIgnoreCase("creature") && mobcapAnimal >= 0) {
            cir.setReturnValue((Object)mobcapAnimal);
        }
    }

    public static void isRare(class_1311 group, CallbackInfoReturnable<Boolean> cir) {
        if (group.method_6133().equalsIgnoreCase("creature") && fastAnimalSpawn) {
            cir.setReturnValue((Object)false);
        }
    }

    public static void isAcceptableSpawnPosition(class_3218 world, class_2791 chunk, class_2338.class_2339 pos, double squaredDistance, CallbackInfoReturnable<Boolean> cir) {
        class_1923 chunkPos;
        if (!fastAnimalSpawn) {
            return;
        }
        if (squaredDistance < 4.0) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)(Objects.equals(chunkPos = new class_1923((class_2338)pos), chunk.method_12004()) || world.method_67505(chunkPos) ? 1 : 0));
    }
}

