/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLifeConfig;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class Necromancy
extends Superpower {
    private static final List<UUID> ressurectedPlayers = new ArrayList<UUID>();
    private static final List<UUID> queuedRessurectedPlayers = new ArrayList<UUID>();
    public static final List<UUID> clearedPlayers = new ArrayList<UUID>();
    private List<UUID> perPlayerRessurections = new ArrayList<UUID>();

    public Necromancy(class_3222 player) {
        super(player);
    }

    @Override
    public Superpowers getSuperpower() {
        return Superpowers.NECROMANCY;
    }

    @Override
    public int getCooldownMillis() {
        return 300000;
    }

    @Override
    public void activate() {
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (Necromancy.getDeadSpectatorPlayers().isEmpty()) {
            PlayerUtils.displayMessageToPlayer(player, class_2561.method_30163((String)"There are no dead players."), 80);
            return;
        }
        class_3218 playerWorld = PlayerUtils.getServerWorld(player);
        playerWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_38067, class_3419.field_15250, 1.0f, 1.0f);
        List affectedPlayers = playerWorld.method_8390(class_3222.class, player.method_5829().method_1014(10.0), playerEntity -> playerEntity.method_5739((class_1297)player) <= 10.0f);
        class_1293 blindness = new class_1293(class_1294.field_5919, 115, 0);
        for (class_3222 affectedPlayer : affectedPlayers) {
            affectedPlayer.method_6092(blindness);
        }
        for (class_3222 deadPlayer : Necromancy.getDeadSpectatorPlayers()) {
            queuedRessurectedPlayers.add(deadPlayer.method_5667());
        }
        TaskScheduler.scheduleTask(100, () -> {
            class_3222 updatedPlayer = this.getPlayer();
            if (updatedPlayer != null) {
                class_3218 updatedPlayerWorld = PlayerUtils.getServerWorld(updatedPlayer);
                List<class_3222> deadPlayers = Necromancy.getDeadSpectatorPlayers();
                for (class_3222 deadPlayer : deadPlayers) {
                    WildLifeConfig config;
                    class_2338 tpTo = WorldUtils.getCloseBlockPos((class_1937)updatedPlayerWorld, updatedPlayer.method_24515(), 3.0, 2, true);
                    PlayerUtils.teleport(deadPlayer, updatedPlayerWorld, tpTo);
                    deadPlayer.method_7336(class_1934.field_9215);
                    ConfigManager patt0$temp = Main.seasonConfig;
                    if (patt0$temp instanceof WildLifeConfig && WildLifeConfig.WILDCARD_SUPERPOWERS_ZOMBIES_LOSE_ITEMS.get(config = (WildLifeConfig)patt0$temp).booleanValue() && !clearedPlayers.contains(deadPlayer.method_5667())) {
                        clearedPlayers.add(deadPlayer.method_5667());
                        deadPlayer.method_31548().method_5448();
                    }
                    AttributeUtils.setMaxPlayerHealth(deadPlayer, 8.0);
                    deadPlayer.method_6033(8.0f);
                    WorldUtils.summonHarmlessLightning(deadPlayer);
                    ressurectedPlayers.add(deadPlayer.method_5667());
                    this.perPlayerRessurections.add(deadPlayer.method_5667());
                    queuedRessurectedPlayers.remove(deadPlayer.method_5667());
                }
            }
        });
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        ArrayList<UUID> deadAgain = new ArrayList<UUID>();
        for (class_3222 player : Main.livesManager.getDeadPlayers()) {
            UUID uuid;
            if (player.method_7325() || !this.perPlayerRessurections.contains(uuid = player.method_5667()) || !ressurectedPlayers.contains(uuid)) continue;
            WorldUtils.summonHarmlessLightning(player);
            player.method_7336(class_1934.field_9219);
            deadAgain.add(uuid);
        }
        ressurectedPlayers.removeAll(deadAgain);
        this.perPlayerRessurections.removeAll(deadAgain);
        queuedRessurectedPlayers.removeAll(deadAgain);
    }

    @Override
    public void tick() {
        for (UUID uuid : new ArrayList<UUID>(this.perPlayerRessurections)) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null || !Main.livesManager.isAlive(player)) continue;
            this.perPlayerRessurections.remove(uuid);
            ressurectedPlayers.remove(uuid);
            queuedRessurectedPlayers.remove(uuid);
            AttributeUtils.resetAttributesOnPlayerJoin(player);
        }
    }

    public static List<class_3222> getDeadSpectatorPlayers() {
        ArrayList<class_3222> deadPlayers = new ArrayList<class_3222>();
        for (class_3222 player : Main.livesManager.getDeadPlayers()) {
            if (!player.method_7325()) continue;
            deadPlayers.add(player);
        }
        return deadPlayers;
    }

    public static boolean shouldBeIncluded() {
        return !Main.livesManager.getDeadPlayers().isEmpty();
    }

    public static boolean isRessurectedPlayer(class_3222 player) {
        return ressurectedPlayers.contains(player.method_5667());
    }

    public static boolean preIsRessurectedPlayer(class_3222 player) {
        return queuedRessurectedPlayers.contains(player.method_5667()) || ressurectedPlayers.contains(player.method_5667());
    }
}

