/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.subin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.interfaces.IPlayerManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2748;
import net.minecraft.class_3222;
import net.minecraft.class_3324;

public class SubInManager {
    public static List<SubIn> subIns = new ArrayList<SubIn>();

    private static UUID getId(GameProfile profile) {
        return OtherUtils.profileId(profile);
    }

    private static String getName(GameProfile profile) {
        return OtherUtils.profileName(profile);
    }

    public static void addSubIn(class_3222 player, GameProfile targetProfile) {
        Integer startingLives = Main.livesManager.getPlayerLives(player);
        UUID playerUUID = player.method_5667();
        GameProfile playerProfile = player.method_7334();
        UUID targetProfileId = SubInManager.getId(targetProfile);
        for (SubIn subIn : new ArrayList<SubIn>(subIns)) {
            UUID substituterId = SubInManager.getId(subIn.substituter());
            UUID substituteeId = SubInManager.getId(subIn.target());
            if (!substituterId.equals(targetProfileId) && !substituteeId.equals(targetProfileId) && !substituterId.equals(playerUUID) && !substituteeId.equals(playerUUID)) continue;
            SubInManager.removeSubIn(subIn);
        }
        SubInManager.savePlayer(player);
        subIns.add(new SubIn(playerProfile, targetProfile, startingLives));
        SubInManager.loadPlayer(player);
        PlayerUtils.updatePlayerInventory(player);
        player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        Integer subInLives = Main.livesManager.getScoreLives(SubInManager.getName(targetProfile));
        if (subInLives == null) {
            Main.livesManager.resetPlayerLife(player);
        } else {
            Main.livesManager.setPlayerLives(player, subInLives);
        }
    }

    public static void removeSubIn(class_3222 player) {
        UUID playerUUID = player.method_5667();
        for (SubIn subIn : new ArrayList<SubIn>(subIns)) {
            if (!SubInManager.getId(subIn.substituter()).equals(playerUUID) && !SubInManager.getId(subIn.target()).equals(playerUUID)) continue;
            SubInManager.removeSubIn(subIn);
        }
    }

    private static void removeSubIn(SubIn subIn) {
        class_3222 player1 = PlayerUtils.getPlayer(SubInManager.getId(subIn.substituter()));
        class_3222 player2 = PlayerUtils.getPlayer(SubInManager.getId(subIn.target()));
        if (player1 != null) {
            player1.method_64398((class_2561)TextUtils.formatLoosely("\u00a76You are no longer subbing in for {}", SubInManager.getName(subIn.target())));
        }
        if (player2 != null) {
            player2.method_64398((class_2561)TextUtils.formatLoosely("\u00a76{} is no longer subbing in for you", SubInManager.getName(subIn.substituter())));
        }
        SubInManager.savePlayer(player1);
        subIns.remove(subIn);
        SubInManager.loadPlayer(player1);
        SubInManager.loadPlayer(player2);
        if (player1 != null) {
            Integer startingLives = subIn.startingLives();
            Main.livesManager.setPlayerLives(player1, startingLives);
        }
    }

    public static void savePlayer(class_3222 player) {
        if (player == null || Main.server == null) {
            return;
        }
        class_3324 class_33242 = Main.server.method_3760();
        if (class_33242 instanceof IPlayerManager) {
            IPlayerManager iPlayerManager = (IPlayerManager)class_33242;
            iPlayerManager.ls$savePlayerData(player);
        }
    }

    public static void loadPlayer(class_3222 player) {
        if (player == null || Main.server == null) {
            return;
        }
        class_3324 class_33242 = Main.server.method_3760();
        if (class_33242 instanceof IPlayerManager) {
            IPlayerManager iPlayerManager = (IPlayerManager)class_33242;
            Optional data = iPlayerManager.ls$getSaveHandler().method_55789((class_1657)player);
            data.ifPresent(nbt -> {
                player.method_5651(nbt);
                PlayerUtils.teleport(player, WorldUtils.getEntityPos((class_1297)player));
            });
        }
    }

    public static boolean isSubbingIn(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        for (SubIn subIn : subIns) {
            if (!SubInManager.getId(subIn.substituter()).equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBeingSubstituted(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        for (SubIn subIn : subIns) {
            if (!SubInManager.getId(subIn.target()).equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static GameProfile getSubstitutedPlayer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (SubIn subIn : subIns) {
            if (!SubInManager.getId(subIn.substituter()).equals(uuid)) continue;
            return subIn.target();
        }
        return null;
    }

    public static GameProfile getSubstitutingPlayer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (SubIn subIn : subIns) {
            if (!SubInManager.getId(subIn.target()).equals(uuid)) continue;
            return subIn.substituter();
        }
        return null;
    }

    public static UUID getSubstitutedPlayerUUID(UUID uuid) {
        GameProfile profile = SubInManager.getSubstitutedPlayer(uuid);
        if (profile == null) {
            return null;
        }
        return SubInManager.getId(profile);
    }

    public static UUID getSubstitutingPlayerUUID(UUID uuid) {
        GameProfile profile = SubInManager.getSubstitutingPlayer(uuid);
        if (profile == null) {
            return null;
        }
        return SubInManager.getId(profile);
    }

    public record SubIn(GameProfile substituter, GameProfile target, Integer startingLives) {
    }
}

