/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.SnailSkinsServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class WildLifeCommands {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.WILD_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (WildLifeCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when playing Wild Life."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wildcard").requires(source -> WildLifeCommands.isAllowed() && (PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null))).then(class_2170.method_9247((String)"list").executes(context -> WildLifeCommands.listWildcards((class_2168)context.getSource())))).then(class_2170.method_9247((String)"listActive").executes(context -> WildLifeCommands.listActiveWildcards((class_2168)context.getSource())))).then(class_2170.method_9247((String)"activate").then(class_2170.method_9244((String)"wildcard", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WildLifeCommands.suggestionsActivateWildcard(), (SuggestionsBuilder)builder)).executes(context -> WildLifeCommands.activateWildcard((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"wildcard")))))).then(class_2170.method_9247((String)"deactivate").then(class_2170.method_9244((String)"wildcard", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WildLifeCommands.suggestionsDeactivateWildcard(), (SuggestionsBuilder)builder)).executes(context -> WildLifeCommands.deactivateWildcard((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"wildcard")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"choose").requires(source -> NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023()) || source.method_9228() == null)).executes(context -> WildLifeCommands.chooseWildcard((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"snail").requires(source -> WildLifeCommands.isAllowed())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"names").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WildLifeCommands.setSnailName((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"name"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> WildLifeCommands.resetSnailName((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> WildLifeCommands.getSnailName((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"request").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WildLifeCommands.requestSnailName((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"textures").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> WildLifeCommands.getSnailTexturesInfo((class_2168)context.getSource()))).then(class_2170.method_9247((String)"list").executes(context -> WildLifeCommands.getSnailTextures((class_2168)context.getSource())))).then(class_2170.method_9247((String)"info").executes(context -> WildLifeCommands.getSnailTexturesInfo((class_2168)context.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"superpower").requires(source -> WildLifeCommands.isAllowed() && (PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"superpower", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Superpowers.getImplementedStr(), (SuggestionsBuilder)builder)).executes(context -> WildLifeCommands.setSuperpower((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"superpower"))))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> WildLifeCommands.resetSuperpowers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"setRandom").executes(context -> WildLifeCommands.setRandomSuperpowers((class_2168)context.getSource())))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> WildLifeCommands.getSuperpower((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"skipCooldown").executes(context -> WildLifeCommands.skipSuperpowerCooldown((class_2168)context.getSource())))).then(class_2170.method_9247((String)"assignForRandomization").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"superpower", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Superpowers.getImplementedStr(), (SuggestionsBuilder)builder)).executes(context -> WildLifeCommands.assignSuperpower((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"superpower")))))));
    }

    public static int requestSnailName(class_2168 source, String name) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("{}\u00a77 requests their snail name to be \u00a7f{}\u00a77", player, name));
        class_5250 adminText = class_2561.method_43470((String)"\u00a77Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.runCommandClickEvent(TextUtils.formatString("/snail names set {} {}", player, name))).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to accept."));
        PlayerUtils.broadcastMessageToAdmins((class_2561)adminText);
        return 1;
    }

    public static int getSnailTexturesInfo(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        NetworkHandlerServer.sendStringPacket(player, PacketNames.SNAIL_TEXTURES_INFO, "");
        return 1;
    }

    public static int getSnailTextures(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        List<String> textures = SnailSkinsServer.getAllSkins();
        if (textures.isEmpty()) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77No snail skins have been added yet. Run '\u00a7f/snail textures info\u00a77' to learn how to add them."));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("\u00a77The following skins have been found: \u00a7f{}", textures));
        return 1;
    }

    public static int chooseWildcard(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (source.method_44023() == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023())) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7r to open the wildcard GUI"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the Wildcard selection GUI..."));
        NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SELECT_WILDCARDS, "true");
        return 1;
    }

    public static List<String> suggestionsDeactivateWildcard() {
        List<String> allWildcards = Wildcards.getActiveWildcardsStr();
        allWildcards.add("*");
        return allWildcards;
    }

    public static List<String> suggestionsActivateWildcard() {
        List<String> allWildcards = Wildcards.getInactiveWildcardsStr();
        allWildcards.add("*");
        return allWildcards;
    }

    public static int assignSuperpower(class_2168 source, Collection<class_3222> targets, String name) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (!Superpowers.getImplementedStr().contains(name)) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        Superpowers superpower = Superpowers.fromString(name);
        if (superpower == Superpowers.NONE) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.assignedSuperpowers.put(player.method_5667(), superpower);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Forced {}'s superpower to be {} when the next superpower randomization happens", targets.iterator().next(), name));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Forced the superpower of {} targets to be {} when the next superpower randomization happens", targets.size(), name));
        }
        return 1;
    }

    public static int skipSuperpowerCooldown(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        Superpower superpower = SuperpowersWildcard.getSuperpowerInstance(player);
        if (superpower == null) {
            source.method_9213(class_2561.method_30163((String)"You do not have an active superpower"));
            return -1;
        }
        superpower.cooldown = 0L;
        NetworkHandlerServer.sendLongPacket(player, PacketNames.SUPERPOWER_COOLDOWN, 0L);
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Your superpower cooldown has been skipped"));
        return 1;
    }

    public static int setRandomSuperpowers(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        SuperpowersWildcard.rollRandomSuperpowers();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Randomized everyone's superpowers"));
        return 1;
    }

    public static int resetSuperpowers(class_2168 source, Collection<class_3222> targets) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.resetSuperpower(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated {}'s superpower", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated the superpower of {} targets", targets.size()));
        }
        return 1;
    }

    public static int getSuperpower(class_2168 source, class_3222 player) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        Superpowers superpower = SuperpowersWildcard.getSuperpower(player);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s superpower is: {}", player, superpower.getString()));
        return 1;
    }

    public static int setSuperpower(class_2168 source, Collection<class_3222> targets, String name) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (!Superpowers.getImplementedStr().contains(name)) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        Superpowers superpower = Superpowers.fromString(name);
        if (superpower == Superpowers.NONE) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.setSuperpower(player, superpower);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s superpower to {}", targets.iterator().next(), name));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set the superpower to {} for {} targets", name, targets.size()));
        }
        return 1;
    }

    public static int setSnailName(class_2168 source, class_3222 player, String name) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        Snails.setSnailName(player, name);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s snail name to {}", player, name));
        return 1;
    }

    public static int resetSnailName(class_2168 source, Collection<class_3222> targets) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            Snails.resetSnailName(player);
        }
        if (targets.size() == 1) {
            class_3222 player = targets.iterator().next();
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s snail name to {}'s Snail", player, player.method_5820()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset the snail name for {} targets", targets.size()));
        }
        return 1;
    }

    public static int getSnailName(class_2168 source, class_3222 player) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s snail is called {}", player, Snails.getSnailName(player)));
        return 1;
    }

    public static int deactivateWildcard(class_2168 source, String wildcardName) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (wildcardName.equalsIgnoreCase("*")) {
            WildcardManager.onSessionEnd();
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Deactivated all wildcards"));
            return 1;
        }
        Wildcards wildcard = Wildcards.getFromString(wildcardName);
        if (wildcard == Wildcards.NULL) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard doesn't exist"));
            return -1;
        }
        if (!WildcardManager.isActiveWildcard(wildcard)) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard is not active"));
            return -1;
        }
        WildcardManager.fadedWildcard();
        Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)wildcard);
        wildcardInstance.deactivate();
        WildcardManager.activeWildcards.remove((Object)wildcard);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated {}", wildcardName));
        NetworkHandlerServer.sendUpdatePackets();
        return 1;
    }

    public static int activateWildcard(class_2168 source, String wildcardName) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (wildcardName.equalsIgnoreCase("*")) {
            List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
            for (Wildcards wildcard : inactiveWildcards) {
                Wildcard wildcardInstance;
                if (wildcard == Wildcards.CALLBACK || (wildcardInstance = wildcard.getInstance()) == null) continue;
                WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
            }
            WildcardManager.showDots();
            TaskScheduler.scheduleTask(90, () -> {
                for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
                    if (wildcard.active) continue;
                    wildcard.activate();
                }
                WildcardManager.showRainbowCryptTitle("All wildcards are active!");
            });
            NetworkHandlerServer.sendUpdatePackets();
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Activated all wildcards (Except Callback)"));
            return 1;
        }
        Wildcards wildcard = Wildcards.getFromString(wildcardName);
        if (wildcard == Wildcards.NULL) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard doesn't exist"));
            return -1;
        }
        if (WildcardManager.isActiveWildcard(wildcard)) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard is already active"));
            return -1;
        }
        Wildcard actualWildcard = wildcard.getInstance();
        if (actualWildcard == null) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard has not been implemented yet"));
            return -1;
        }
        TaskScheduler.scheduleTask(89, () -> WildcardManager.activeWildcards.put(wildcard, actualWildcard));
        WildcardManager.activateWildcards();
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Activated {}", wildcardName));
        return 1;
    }

    public static int listWildcards(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Available Wildcards: {}", Wildcards.getWildcardsStr()));
        return 1;
    }

    public static int listActiveWildcards(class_2168 source) {
        if (WildLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (Wildcards.getActiveWildcardsStr().isEmpty()) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77There are no active Wildcards right now. \nYou will be able to select a Wildcard when you start a session, or you can use '\u00a7f/wildcard activate <wildcard>\u00a77' to activate a specific Wildcard right now."));
            return 1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Activated Wildcards: {}", Wildcards.getActiveWildcardsStr()));
        return 1;
    }
}

