/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.ConfigScreen;
import net.mat0u5.lifeseries.gui.config.entries.GroupConfigEntry;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8001;

@Environment(value=EnvType.CLIENT)
public abstract class ConfigEntry {
    public static final int PREFFERED_HEIGHT = 20;
    protected static final int LABEL_OFFSET_X = 25;
    protected static final int LABEL_OFFSET_Y = 6;
    private static final float HIGHTLIGHT_FADE = 0.1f;
    private static final int RESET_BUTTON_OFFSET_X = -5;
    private static final int RESET_BUTTON_OFFSET_Y = 2;
    protected static final int RESET_BUTTON_WIDTH = 50;
    private static final int RESET_BUTTON_HEIGHT = 16;
    protected static final int ERROR_LABEL_OFFSET_X = -57;
    protected static final int ERROR_LABEL_OFFSET_Y = 8;
    public static final int MAX_DESCRIPTION_WIDTH = 250;
    protected class_327 textRenderer;
    protected ConfigScreen screen;
    protected final String fieldName;
    protected final String displayName;
    protected final String description;
    protected boolean hasError = false;
    protected String errorMessage = "";
    protected class_4185 resetButton;
    public float highlightAlpha = 0.0f;
    protected boolean isHovered = false;
    private boolean isFocused = false;
    protected GroupConfigEntry<?> parentGroup;
    protected List<GroupConfigEntry<?>> groupTopology = new ArrayList();
    private boolean isNew = false;

    public ConfigEntry(String fieldName, String displayName, String description) {
        this.fieldName = fieldName;
        this.displayName = displayName;
        this.description = description;
        this.textRenderer = class_310.method_1551().field_1772;
        this.initializeResetButton();
    }

    public void setNew() {
        this.isNew = true;
    }

    private void initializeResetButton() {
        if (!this.hasResetButton()) {
            return;
        }
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Reset"), this::onResetClicked).method_46434(0, 0, 50, 16).method_46431();
    }

    private void onResetClicked(class_4185 button) {
        this.resetToDefault();
        this.markChanged();
    }

    public void setScreen(ConfigScreen screen) {
        this.screen = screen;
    }

    public void render(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.isHovered = hovered;
        this.updateHighlightAnimation(tickDelta);
        if (this.highlightAlpha > 0.0f) {
            int highlightColor = TextColors.argb((int)(this.highlightAlpha * 128.0f), 128, 128, 128);
            context.method_25294(x, y, x + width, y + height, highlightColor);
        }
        int textColor = this.hasError() ? TextColors.PASTEL_RED : TextColors.WHITE;
        int labelX = x + 25;
        int labelY = y + 6;
        context.method_27535(this.textRenderer, (class_2561)this.getDisplayName(), labelX, labelY, textColor);
        int resetButtonX = x + width - 50 + -5;
        if (this.hasResetButton()) {
            this.resetButton.method_46421(resetButtonX);
            this.resetButton.method_46419(y + 2);
            this.resetButton.field_22763 = this.canReset();
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
        if (this.hasError()) {
            RenderUtils.drawTextRight(context, this.textRenderer, TextColors.PASTEL_RED, class_2561.method_30163((String)"\u26a0"), x + width + -57, y + 8);
            if (this.isHovered) {
                class_5250 errorText = TextUtils.format("\u00a7cERROR:\n{}", this.getErrorMessage());
                context.method_51436(this.textRenderer, this.textRenderer.method_1728((class_5348)errorText, 250), class_8001.field_41687, mouseX, mouseY, false);
            }
        } else if (this.description != null && !this.description.isEmpty() && mouseX >= labelX && mouseX <= labelX + this.textRenderer.method_27525((class_5348)this.getDisplayName()) && mouseY >= labelY) {
            Objects.requireNonNull(this.textRenderer);
            if (mouseY <= labelY + 9) {
                class_5250 descriptionText = this.getDisplayName().method_27692(class_124.field_1073).method_27693("\u00a7r\n" + this.description);
                context.method_51436(this.textRenderer, this.textRenderer.method_1728((class_5348)descriptionText, 250), class_8001.field_41687, mouseX, mouseY, false);
            }
        }
        if (this.isNew) {
            context.method_25303(this.textRenderer, "New", 2, labelY, TextColors.LIGHT_GRAY_A128);
        }
        this.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
    }

    protected void updateHighlightAnimation(float tickDelta) {
        this.highlightAlpha = this.isHovered ? 1.0f : Math.max(0.0f, this.highlightAlpha - tickDelta * 0.1f);
    }

    protected int getEntryContentWidth(int totalWidth) {
        return totalWidth - 50 - 15;
    }

    protected abstract boolean mouseClickedEntry(class_11909 var1, boolean var2);

    protected abstract boolean keyPressedEntry(class_11908 var1);

    protected abstract boolean charTypedEntry(class_11905 var1);

    public boolean mouseClicked(class_11909 click, boolean doubled) {
        if (this.hasResetButton() && this.resetButton.method_25402(click, doubled)) {
            return true;
        }
        return this.mouseClickedEntry(click, doubled);
    }

    public boolean keyPressed(class_11908 keyInput) {
        return this.keyPressedEntry(keyInput);
    }

    public boolean charTyped(class_11905 charInput) {
        return this.charTypedEntry(charInput);
    }

    public void setFocused(boolean focused) {
        this.setActualFocused(focused);
        if (focused && this.screen != null) {
            this.screen.setFocusedEntry(this);
        }
    }

    protected void setActualFocused(boolean focused) {
        this.isFocused = focused;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean isTopologyFocused() {
        if (this.groupTopology.size() >= 2) {
            return this.groupTopology.get(1).isFocused();
        }
        return this.isFocused();
    }

    public int getPreferredHeight() {
        return 20;
    }

    protected abstract void renderEntry(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

    public abstract void resetToDefault();

    public abstract Object getValue();

    public abstract String getValueAsString();

    public abstract Object getDefaultValue();

    public abstract String getDefaultValueAsString();

    public abstract Object getStartingValue();

    public abstract String getStartingValueAsString();

    public abstract ConfigTypes getValueType();

    public abstract void setValue(Object var1);

    public boolean modified() {
        return !Objects.equals(this.getValue(), this.getStartingValue());
    }

    public boolean canReset() {
        return !Objects.equals(this.getValue(), this.getDefaultValue());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public class_5250 getDisplayName() {
        return class_2561.method_43470((String)this.displayName);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setError(String errorMessage) {
        this.hasError = true;
        this.errorMessage = errorMessage;
    }

    protected void clearError() {
        this.hasError = false;
        this.errorMessage = "";
    }

    public void markChanged() {
        if (this.screen != null) {
            this.screen.onEntryValueChanged();
        }
    }

    public boolean hasResetButton() {
        return true;
    }
}

