/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.pastlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class PastLifeCommands
extends Command {
    public Random rnd = new Random();

    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.PAST_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when playing Past Life.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PastLifeCommands.literal("pastlife").requires(PermissionManager::isAdmin)).then(PastLifeCommands.literal("boogeyman").executes(context -> this.pickBoogeyman((class_2168)context.getSource())))).then(PastLifeCommands.literal("society").executes(context -> this.pickSociety((class_2168)context.getSource())))).then(PastLifeCommands.literal("pickRandom").executes(context -> this.pickRandom((class_2168)context.getSource()))));
    }

    public int pickRandom(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        boolean bannedSociety = !Main.currentSeason.secretSociety.SOCIETY_ENABLED || Main.currentSeason.secretSociety.societyStarted || Main.currentSeason.secretSociety.societyEnded;
        boolean bannedBoogeyman = !Main.currentSeason.boogeymanManager.BOOGEYMAN_ENABLED || Main.currentSeason.boogeymanManager.boogeymanChosen;
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId != null && action.sessionId.equalsIgnoreCase("Begin Secret Society")) {
                bannedSociety = true;
            }
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Choose Boogeymen")) continue;
            bannedBoogeyman = true;
        }
        if (bannedBoogeyman && bannedSociety) {
            source.method_9213(class_2561.method_30163((String)"Picking failed"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Randomly picking the Boogeyman or the Secret Society..."));
        if (!bannedBoogeyman && bannedSociety) {
            Main.currentSeason.boogeymanManager.addSessionActions();
            return 1;
        }
        if (bannedBoogeyman && !bannedSociety) {
            Main.currentSeason.secretSociety.addSessionActions();
            return 1;
        }
        if (!bannedBoogeyman && !bannedSociety) {
            if (this.rnd.nextInt(2) == 0) {
                Main.currentSeason.boogeymanManager.addSessionActions();
            } else {
                Main.currentSeason.secretSociety.addSessionActions();
            }
            Main.currentSession.getSessionActions().getLast().sessionMessage = "Randomly Selected Twist";
            return 1;
        }
        return 1;
    }

    public int pickSociety(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        if (!Main.currentSeason.secretSociety.SOCIETY_ENABLED) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society is disabled in the config"));
            return -1;
        }
        if (Main.currentSeason.secretSociety.societyEnded) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already ended"));
            return -1;
        }
        if (Main.currentSeason.secretSociety.societyStarted) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already started"));
            return -1;
        }
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Begin Secret Society")) continue;
            source.method_9213(class_2561.method_30163((String)"The Secret Society is already queued"));
            return -1;
        }
        Main.currentSeason.secretSociety.addSessionActions();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Added the Secret Society to queued session actions"));
        return 1;
    }

    public int pickBoogeyman(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has not started yet"));
            return -1;
        }
        if (!Main.currentSeason.boogeymanManager.BOOGEYMAN_ENABLED) {
            source.method_9213(class_2561.method_30163((String)"The Boogeyman is disabled in the config"));
            return -1;
        }
        if (Main.currentSeason.boogeymanManager.boogeymanChosen) {
            source.method_9213(class_2561.method_30163((String)"The Boogeyman has already been chosen"));
            return -1;
        }
        for (SessionAction action : Main.currentSession.getSessionActions()) {
            if (action.sessionId == null || !action.sessionId.equalsIgnoreCase("Choose Boogeymen")) continue;
            source.method_9213(class_2561.method_30163((String)"The Boogeyman is already queued"));
            return -1;
        }
        Main.currentSeason.boogeymanManager.addSessionActions();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Added the Boogeyman to queued session actions"));
        return 1;
    }
}

