/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLifeCommands;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLifeConfig;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskManager;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SecretLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /gift, /task, /health, /secretlife";
    public static final String COMMANDS_TEXT = "/claimkill, /lives, /gift";
    public static double MAX_HEALTH = 60.0;
    public static double MAX_KILL_HEALTH = 1000.0;
    public static boolean ONLY_LOSE_HEARTS_IN_SESSION = false;
    public ItemSpawner itemSpawner;
    SessionAction taskWarningAction = new SessionAction(this, OtherUtils.minutesToTicks(-5) + 1){

        @Override
        public void trigger() {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"Go submit / fail your secret tasks if you haven't!").method_27692(class_124.field_1080));
        }
    };
    SessionAction taskWarningAction2 = new SessionAction(this, OtherUtils.minutesToTicks(-30) + 1){

        @Override
        public void trigger() {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"You better start finishing your secret tasks if you haven't already!").method_27692(class_124.field_1080));
        }
    };
    private long ticks = 0L;
    private Map<UUID, class_1799> giveBookOnRespawn = new HashMap<UUID, class_1799>();

    @Override
    public Seasons getSeason() {
        return Seasons.SECRET_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        TaskManager.initialize();
        return new SecretLifeConfig();
    }

    @Override
    public String getAdminCommands() {
        return COMMANDS_ADMIN_TEXT;
    }

    @Override
    public String getNonAdminCommands() {
        return COMMANDS_TEXT;
    }

    @Override
    public void initialize() {
        super.initialize();
        TaskManager.initialize();
        this.initializeItemSpawner();
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof SecretLifeConfig)) {
            return;
        }
        SecretLifeConfig config = (SecretLifeConfig)configManager;
        MAX_HEALTH = ((Integer)config.MAX_PLAYER_HEALTH.get(config)).intValue();
        MAX_KILL_HEALTH = SecretLifeConfig.MAX_PLAYER_KILL_HEALTH.get(config).intValue();
        TaskManager.EASY_SUCCESS = SecretLifeConfig.TASK_HEALTH_EASY_PASS.get(config);
        TaskManager.EASY_FAIL = SecretLifeConfig.TASK_HEALTH_EASY_FAIL.get(config);
        TaskManager.HARD_SUCCESS = SecretLifeConfig.TASK_HEALTH_HARD_PASS.get(config);
        TaskManager.HARD_FAIL = SecretLifeConfig.TASK_HEALTH_HARD_FAIL.get(config);
        TaskManager.RED_SUCCESS = SecretLifeConfig.TASK_HEALTH_RED_PASS.get(config);
        TaskManager.RED_FAIL = SecretLifeConfig.TASK_HEALTH_RED_FAIL.get(config);
        TaskManager.ASSIGN_TASKS_MINUTE = SecretLifeConfig.ASSIGN_TASKS_MINUTE.get(config);
        TaskManager.BROADCAST_SECRET_KEEPER = SecretLifeConfig.BROADCAST_SECRET_KEEPER.get(config);
        TaskManager.CONSTANT_TASKS = SecretLifeConfig.CONSTANT_TASKS.get(config);
        TaskManager.PUBLIC_TASKS_ON_SUBMIT = SecretLifeConfig.BROADCAST_TASKS_WHEN_SUBMITTED.get(config);
        ONLY_LOSE_HEARTS_IN_SESSION = SecretLifeConfig.ONLY_LOSE_HEARTS_IN_SESSION.get(config);
    }

    @Override
    public void onPlayerRespawn(class_3222 player) {
        super.onPlayerRespawn(player);
        if (this.giveBookOnRespawn.containsKey(player.method_5667())) {
            class_1799 book = this.giveBookOnRespawn.get(player.method_5667());
            this.giveBookOnRespawn.remove(player.method_5667());
            if (book != null) {
                player.method_31548().method_7394(book);
            }
        }
        TaskTypes type = TaskManager.getPlayersTaskType(player);
        if (this.livesManager.isOnLastLife(player, false) && TaskManager.submittedOrFailed.contains(player.method_5667()) && type == null) {
            TaskManager.chooseTasks(List.of(player), TaskTypes.RED);
        }
    }

    public void initializeItemSpawner() {
        this.itemSpawner = new ItemSpawner();
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_41946), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22019), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8287, 16), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8108), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8477, 2), 20);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8494, 2), 20);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8773, 2), 20);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8797, 2), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8463), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8225, 16), 7);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37538, 2), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_28101, 8), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8626, 4), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8281, 8), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8107, 32), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_47831), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_27023), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8634, 2), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8536, 4), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_16998, 16), 10);
        class_1799 pot = new class_1799((class_1935)class_1802.field_8574);
        class_1799 pot2 = new class_1799((class_1935)class_1802.field_8574);
        class_1799 pot3 = new class_1799((class_1935)class_1802.field_8574);
        pot.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8997));
        pot2.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8974));
        pot3.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8987));
        this.itemSpawner.addItem(pot, 10);
        this.itemSpawner.addItem(pot2, 10);
        this.itemSpawner.addItem(pot3, 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9111, 3)), 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9129, 3)), 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9099, 1)), 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9130, 3)), 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9110, 3)), 10);
        this.itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9131, 4)), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8485), 15);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8193), 10);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_42710), 7);
        this.itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8435), 10);
        class_1799 camel = new class_1799((class_1935)class_1802.field_40239);
        class_1799 zombieHorse = new class_1799((class_1935)class_1802.field_8728);
        class_1799 skeletonHorse = new class_1799((class_1935)class_1802.field_8232);
        class_2487 nbtCompSkeleton = new class_2487();
        nbtCompSkeleton.method_10569("Tame", 1);
        nbtCompSkeleton.method_10582("id", "skeleton_horse");
        class_2487 nbtCompZombie = new class_2487();
        nbtCompZombie.method_10569("Tame", 1);
        nbtCompZombie.method_10582("id", "zombie_horse");
        class_2487 nbtCompCamel = new class_2487();
        nbtCompCamel.method_10569("Tame", 1);
        nbtCompCamel.method_10582("id", "camel");
        class_2487 equipmentItemComp = new class_2487();
        class_2487 saddleItemComp = new class_2487();
        saddleItemComp.method_10582("id", "saddle");
        equipmentItemComp.method_10566("saddle", (class_2520)saddleItemComp);
        nbtCompSkeleton.method_10566("equipment", (class_2520)equipmentItemComp);
        nbtCompZombie.method_10566("equipment", (class_2520)equipmentItemComp);
        nbtCompCamel.method_10566("equipment", (class_2520)equipmentItemComp);
        class_9279 nbtSkeleton = class_9279.method_57456((class_2487)nbtCompSkeleton);
        class_9279 nbtZombie = class_9279.method_57456((class_2487)nbtCompZombie);
        class_9279 nbtCamel = class_9279.method_57456((class_2487)nbtCompCamel);
        zombieHorse.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)class_1299.field_6051, (class_2487)nbtZombie.method_57461()));
        skeletonHorse.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)class_1299.field_6137, (class_2487)nbtSkeleton.method_57461()));
        camel.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)class_1299.field_40116, (class_2487)nbtCamel.method_57461()));
        this.itemSpawner.addItem(zombieHorse, 10);
        this.itemSpawner.addItem(skeletonHorse, 10);
        this.itemSpawner.addItem(camel, 10);
        class_1799 endCrystal = new class_1799((class_1935)class_1802.field_8301);
        ItemStackUtils.setCustomComponentBoolean(endCrystal, "IgnoreBlacklist", true);
        this.itemSpawner.addItem(endCrystal, 10);
        class_1799 mace = new class_1799((class_1935)class_1802.field_49814);
        ItemStackUtils.setCustomComponentBoolean(mace, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(mace, "NoModifications", true);
        mace.method_7974(mace.method_7936() - 1);
        this.itemSpawner.addItem(mace, 3);
        class_1799 patat = new class_1799((class_1935)class_1802.field_8635);
        patat.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)"\u00a76\u00a7l\u00a7nThe Sacred Patat"));
        ItemStackUtils.addLoreToItemStack(patat, List.of(class_2561.method_30163((String)"\u00a75\u00a7oEating this might help you. Or maybe not...")));
        this.itemSpawner.addItem(patat, 1);
    }

    @Override
    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
        if (player.method_6059(class_1294.field_5914)) {
            player.method_6016(class_1294.field_5914);
        }
        TaskScheduler.scheduleTask(1, () -> this.syncPlayerHealth(player));
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        super.onPlayerDeath(player, source);
        this.setPlayerHealth(player, MAX_HEALTH);
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        super.onPlayerJoin(player);
        if (TaskManager.tasksChosen && !TaskManager.tasksChosenFor.contains(player.method_5667())) {
            TaskScheduler.scheduleTask(100, () -> TaskManager.chooseTasks(List.of(player), null));
        }
    }

    @Override
    public void assignDefaultLives(class_3222 player) {
        this.setPlayerHealth(player, MAX_HEALTH);
        player.method_6033((float)MAX_HEALTH);
        super.assignDefaultLives(player);
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        TaskManager.checkSecretLifePositions();
        super.onPlayerFinishJoining(player);
    }

    @Override
    public boolean sessionStart() {
        if (TaskManager.checkSecretLifePositions()) {
            super.sessionStart();
            SecretLifeCommands.playersGiven.clear();
            TaskManager.tasksChosen = false;
            TaskManager.tasksChosenFor.clear();
            TaskManager.submittedOrFailed.clear();
            TaskScheduler.scheduleTask(1, this::heartsTranscript);
            return true;
        }
        return false;
    }

    @Override
    public void addSessionActions() {
        super.addSessionActions();
        Main.currentSession.addSessionAction(TaskManager.getActionChooseTasks());
        Main.currentSession.addSessionActionIfTime(this.taskWarningAction);
        Main.currentSession.addSessionActionIfTime(this.taskWarningAction2);
    }

    @Override
    public void sessionEnd() {
        super.sessionEnd();
        ArrayList<String> playersWithTaskBooks = new ArrayList<String>();
        for (class_3222 player : this.livesManager.getNonRedPlayers()) {
            if (this.livesManager.isDead(player) || TaskManager.submittedOrFailed.contains(player.method_5667()) || TaskManager.CONSTANT_TASKS) continue;
            playersWithTaskBooks.add(player.method_5820());
        }
        if (!playersWithTaskBooks.isEmpty()) {
            boolean isOne = playersWithTaskBooks.size() == 1;
            String playerNames = String.join((CharSequence)", ", playersWithTaskBooks);
            PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.formatLoosely("\u00a74{}\u00a7c still {} not submitted / failed a task this session.", playerNames, isOne ? "has" : "have"));
        }
    }

    public void heartsTranscript() {
        for (class_3222 player : this.livesManager.getAlivePlayers()) {
            SessionTranscript.logHealth(player, this.getRoundedHealth(player));
        }
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        double amountGained;
        super.onPlayerKilledByPlayer(victim, killer);
        if (this.livesManager.isOnLastLife(killer, false) && (amountGained = Math.min(Math.max(MAX_KILL_HEALTH, MAX_HEALTH) - this.getPlayerHealth(killer), 20.0)) > 0.0) {
            this.addPlayerHealth(killer, amountGained);
            double roundedHearts = Math.ceil(amountGained) / 2.0;
            String text = TextUtils.pluralize(TextUtils.formatString("+{} Heart", roundedHearts), roundedHearts);
            PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1061), 0, 40, 20);
        }
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        TaskManager.tick();
        ++this.ticks;
        if (this.ticks % 20L == 0L) {
            this.checkNaturalRegeneration();
        }
    }

    @Override
    public void modifyEntityDrops(class_1309 entity, class_1282 damageSource) {
        super.modifyEntityDrops(entity, damageSource);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            boolean dropBook = SecretLifeConfig.PLAYERS_DROP_TASK_ON_DEATH.get(Main.seasonConfig);
            if (dropBook || Main.server == null) {
                return;
            }
            boolean keepInventory = PlayerUtils.getServerWorld(player).method_64395().method_8355(class_1928.field_19389);
            if (keepInventory) {
                return;
            }
            this.giveBookOnRespawn.put(player.method_5667(), TaskManager.getPlayersTaskBook(player));
            TaskManager.removePlayersTaskBook(player);
        }
    }

    public void removePlayerHealth(class_3222 player, double health) {
        this.addPlayerHealth(player, -health);
    }

    public void addPlayerHealth(class_3222 player, double health) {
        double currentHealth = AttributeUtils.getMaxPlayerHealth(player);
        this.setPlayerHealth(player, currentHealth + health);
    }

    public void setPlayerHealth(class_3222 player, double health) {
        if (player == null) {
            return;
        }
        if (health < 0.1) {
            health = 0.1;
        }
        if (this.canChangeHealth() || health > this.getPlayerHealth(player)) {
            AttributeUtils.setMaxPlayerHealth(player, health);
        }
        if (health > (double)player.method_6032() && player.method_5805()) {
            player.method_6033((float)health);
        }
    }

    public double getPlayerHealth(class_3222 player) {
        return AttributeUtils.getMaxPlayerHealth(player);
    }

    public double getRoundedHealth(class_3222 player) {
        return Math.floor(this.getPlayerHealth(player) * 100.0) / 100.0;
    }

    public void syncPlayerHealth(class_3222 player) {
        if (player == null) {
            return;
        }
        if (!player.method_5805()) {
            return;
        }
        this.setPlayerHealth(player, player.method_6032());
    }

    public void syncAllPlayerHealth() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            this.setPlayerHealth(player, player.method_6032());
        }
    }

    public void resetPlayerHealth(class_3222 player) {
        this.setPlayerHealth(player, MAX_HEALTH);
    }

    public void resetAllPlayerHealth() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            this.resetPlayerHealth(player);
        }
    }

    public boolean canChangeHealth() {
        if (!ONLY_LOSE_HEARTS_IN_SESSION) {
            return true;
        }
        return Main.currentSession != null && Main.currentSession.statusStarted();
    }

    @Override
    public void sessionChangeStatus(SessionStatus newStatus) {
        super.sessionChangeStatus(newStatus);
        this.checkNaturalRegeneration();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_6033((float)this.getPlayerHealth(player));
        }
    }

    public void checkNaturalRegeneration() {
        if (Main.server == null) {
            return;
        }
        boolean naturalRegeneration = false;
        if (ONLY_LOSE_HEARTS_IN_SESSION && !Main.currentSession.statusStarted()) {
            naturalRegeneration = true;
        }
        if (Main.server.method_30002() == null) {
            return;
        }
        ((class_1928.class_4310)Main.server.method_30002().method_64395().method_20746(class_1928.field_19395)).method_20758(naturalRegeneration, Main.server);
    }
}

