/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeLivesManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9011;

public class LivesCommand {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    public static boolean isAllowedNormal() {
        return LivesCommand.isAllowed() && LivesCommand.isNormalLife();
    }

    public static boolean isAllowedLimited() {
        return LivesCommand.isAllowed() && !LivesCommand.isNormalLife();
    }

    public static boolean isNormalLife() {
        return Main.currentSeason.getSeason() != Seasons.LIMITED_LIFE;
    }

    public static boolean isLastLife() {
        return Main.currentSeason.getSeason() == Seasons.LAST_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (LivesCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is not available when you have not selected a season."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lives").requires(source -> LivesCommand.isAllowed())).executes(context -> LivesCommand.showLives((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LivesCommand.reloadLives((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), 1, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(source -> LivesCommand.isAllowedNormal())).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).requires(source -> LivesCommand.isAllowedLimited())).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), false, false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -1, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(source -> LivesCommand.isAllowedNormal())).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).requires(source -> LivesCommand.isAllowedLimited())).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), false, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).requires(source -> LivesCommand.isAllowedNormal())).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).requires(source -> LivesCommand.isAllowedLimited())).suggests((context, builder) -> class_2172.method_9265(List.of("8h", "16h", "24h"), (SuggestionsBuilder)builder)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"time"), true, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> LivesCommand.getLivesFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).then(class_2170.method_9247((String)"*").executes(context -> LivesCommand.getAllLives((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.resetLives((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetAll").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LivesCommand.resetAllLives((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rollLives").requires(source -> LivesCommand.isLastLife())).executes(context -> LivesCommand.assignRandomLives((class_2168)context.getSource(), PlayerUtils.getAllPlayers()))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.assignRandomLives((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"players"))))));
    }

    public static int showLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!Main.livesManager.hasAssignedLives(self)) {
            String timeOrLives = normalLife ? "lives" : "time";
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have not been assigned any {} yet", timeOrLives));
            return 1;
        }
        Integer playerLives = Main.livesManager.getPlayerLives(self);
        if (normalLife) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} {}", Main.livesManager.getFormattedLives(playerLives), TextUtils.pluralize("life", "lives", playerLives)));
        } else {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} left", Main.livesManager.getFormattedLives(playerLives)));
        }
        if (playerLives == null || playerLives <= 0) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Womp womp."));
        }
        return 1;
    }

    public static int getAllLives(class_2168 source) {
        String timeOrLives;
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String string = timeOrLives = normalLife ? "lives" : "time";
        if (!ScoreboardUtils.existsObjective("Lives")) {
            source.method_9213((class_2561)TextUtils.format("Nobody has been assigned {} yet", timeOrLives));
            return -1;
        }
        Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
        if (entries.isEmpty()) {
            source.method_9213((class_2561)TextUtils.format("Nobody has been assigned {} yet", timeOrLives));
            return -1;
        }
        String timeOrLives2 = normalLife ? "Lives" : "Times";
        class_5250 text = TextUtils.format("Assigned {}: \n", timeOrLives2);
        for (class_9011 entry : entries) {
            String name = entry.comp_2127();
            if (name.startsWith("`")) continue;
            int lives = entry.comp_2128();
            class_124 color = Main.livesManager.getColorForLives(lives);
            if (normalLife) {
                text.method_10852((class_2561)TextUtils.format("{} has {} {}\n", class_2561.method_43470((String)name).method_27692(color), Main.livesManager.getFormattedLives(lives), TextUtils.pluralize("life", "lives", lives)));
                continue;
            }
            text.method_10852((class_2561)TextUtils.format("{} has {} left\n", class_2561.method_43470((String)name).method_27692(color), Main.livesManager.getFormattedLives(lives)));
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public static int getLivesFor(class_2168 source, class_3222 target) {
        String timeOrLives;
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String string = timeOrLives = normalLife ? "lives" : "time";
        if (!Main.livesManager.hasAssignedLives(target)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} has not been assigned any {}", target, timeOrLives));
            return -1;
        }
        Integer lives = Main.livesManager.getPlayerLives(target);
        if (normalLife) {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} {}", target, Main.livesManager.getFormattedLives(lives), TextUtils.pluralize("life", "lives", lives)));
        } else {
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} left", target, Main.livesManager.getFormattedLives(lives)));
        }
        return 1;
    }

    public static int reloadLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String timeOrLives = normalLife ? "lives" : "times";
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.formatLoosely("\u00a77Reloading {}...", timeOrLives));
        Main.currentSeason.reloadAllPlayerTeams();
        return 1;
    }

    public static int lifeManager(class_2168 source, Collection<class_3222> targets, String timeArgument, boolean setNotGive, boolean reverse) {
        Integer amount = OtherUtils.parseTimeSecondsFromArgument(timeArgument);
        if (amount == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid time format. Use h, m, s for hours, minutes, and seconds."));
            return -1;
        }
        if (reverse) {
            amount = amount * -1;
        }
        return LivesCommand.lifeManager(source, targets, amount, setNotGive);
    }

    public static int lifeManager(class_2168 source, Collection<class_3222> targets, int amount, boolean setNotGive) {
        Season season;
        String timeOrLives;
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String string = timeOrLives = normalLife ? "lives" : "time";
        if (setNotGive) {
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s {} to {}", targets.iterator().next(), timeOrLives, Main.livesManager.getFormattedLives(amount)));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {} to {} for {} targets", timeOrLives, Main.livesManager.getFormattedLives(amount), targets.size()));
            }
            for (class_3222 player : targets) {
                Main.livesManager.setPlayerLives(player, amount);
            }
        } else {
            String toOrFrom;
            String timeOrLives2;
            String addOrRemove = amount >= 0 ? "Added" : "Removed";
            String string2 = timeOrLives2 = Math.abs(amount) == 1 ? "life" : "lives";
            if (!normalLife) {
                timeOrLives2 = OtherUtils.formatTime(Math.abs(amount) * 20);
            }
            String string3 = toOrFrom = amount >= 0 ? "to" : "from";
            if (targets.size() == 1) {
                if (normalLife) {
                    OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} {}", addOrRemove, Math.abs(amount), timeOrLives2, toOrFrom, targets.iterator().next()));
                } else {
                    OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {}", addOrRemove, timeOrLives2, toOrFrom, targets.iterator().next()));
                }
            } else if (normalLife) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} {} targets", addOrRemove, Math.abs(amount), timeOrLives2, toOrFrom, targets.size()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} targets", addOrRemove, timeOrLives2, toOrFrom, targets.size()));
            }
            for (class_3222 player : targets) {
                Main.livesManager.addToPlayerLives(player, amount);
            }
        }
        if ((season = Main.currentSeason) instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            targets.forEach(doubleLife::syncSoulboundLives);
        }
        return 1;
    }

    public static int resetLives(class_2168 source, Collection<class_3222> targets) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String timeOrLives = normalLife ? "lives" : "time";
        targets.forEach(Main.livesManager::resetPlayerLife);
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s {}", targets.iterator().next(), timeOrLives));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {} of {} targets", timeOrLives, targets.size()));
        }
        return 1;
    }

    public static int resetAllLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        boolean normalLife = LivesCommand.isNormalLife();
        String timeOrLives = normalLife ? "lives" : "times";
        Main.livesManager.resetAllPlayerLives();
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset everyone's {}", timeOrLives));
        return 1;
    }

    public static int assignRandomLives(class_2168 source, Collection<class_3222> players) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (players == null || players.isEmpty()) {
            return -1;
        }
        if (players.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Assigning random lives to {}\u00a77...", players.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Assigning random lives to {}\u00a77 targets...", players.size()));
        }
        LivesManager livesManager = Main.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            lastLifeLivesManager.assignRandomLives(players);
        }
        return 1;
    }
}

