/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class SessionCommand {
    public static final String INVALID_TIME_FORMAT_ERROR = "Invalid time format. Use h, m, s for hours, minutes, and seconds.";

    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    public static boolean checkBanned(class_2168 source) {
        if (SessionCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when you have selected a Season."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"session").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> SessionCommand.startSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> SessionCommand.stopSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pause").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> SessionCommand.pauseSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"timer").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("1h", "1h30m", "2h"), (SuggestionsBuilder)builder)).executes(context -> SessionCommand.setTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> SessionCommand.addTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fastforward").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("5m"), (SuggestionsBuilder)builder)).executes(context -> SessionCommand.skipTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("5m"), (SuggestionsBuilder)builder)).executes(context -> SessionCommand.removeTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(class_2170.method_9247((String)"remaining").executes(context -> SessionCommand.getTime((class_2168)context.getSource())))).then(class_2170.method_9247((String)"showDisplay").executes(context -> SessionCommand.displayTimer((class_2168)context.getSource())))));
    }

    public static int getTime(class_2168 source) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.validTime()) {
            source.method_9213(class_2561.method_30163((String)"The session time has not been set yet"));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("The session ends in {}", Main.currentSession.getRemainingTime()));
        return 1;
    }

    public static int displayTimer(class_2168 source) {
        boolean isInDisplayTimer;
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (NetworkHandlerServer.wasHandshakeSuccessful(self)) {
            NetworkHandlerServer.sendStringPacket(self, PacketNames.TOGGLE_TIMER, "");
        }
        if (isInDisplayTimer = Main.currentSession.isInDisplayTimer(self)) {
            Main.currentSession.removeFromDisplayTimer(self);
        } else {
            Main.currentSession.addToDisplayTimer(self);
        }
        return 1;
    }

    public static int startSession(class_2168 source) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.validTime()) {
            source.method_9213(class_2561.method_30163((String)"The session time is not set! Use '/session timer set <time>' to set the session time."));
            return -1;
        }
        if (Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has already started"));
            return -1;
        }
        if (Main.currentSession.statusPaused()) {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Unpausing session..."));
            Main.currentSession.sessionPause();
            return 1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Starting session..."));
        if (!Main.currentSession.sessionStart()) {
            source.method_9213(class_2561.method_30163((String)"Could not start session"));
            return -1;
        }
        return 1;
    }

    public static int stopSession(class_2168 source) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            source.method_9213(class_2561.method_30163((String)"The session has not yet started"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Stopping session..."));
        Main.currentSession.sessionEnd();
        return 1;
    }

    public static int pauseSession(class_2168 source) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            source.method_9213(class_2561.method_30163((String)"The session has not yet started"));
            return -1;
        }
        if (Main.currentSession.statusPaused()) {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Unpausing session..."));
        } else {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Pausing session..."));
        }
        Main.currentSession.sessionPause();
        return 1;
    }

    public static int skipTime(class_2168 source, String timeArgument) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Skipped {} in the session length", OtherUtils.formatTime(totalTicks)));
        Main.currentSession.passedTime += (double)totalTicks.intValue();
        return 1;
    }

    public static int setTime(class_2168 source, String timeArgument) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.setSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("The session length has been set to {}", OtherUtils.formatTime(totalTicks)));
        return 1;
    }

    public static int addTime(class_2168 source, String timeArgument) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.addSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Added {} to the session length", OtherUtils.formatTime(totalTicks)));
        return 1;
    }

    public static int removeTime(class_2168 source, String timeArgument) {
        if (SessionCommand.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.removeSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed {} from the session length", OtherUtils.formatTime(totalTicks)));
        return 1;
    }
}

