/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigFileEntry;
import net.mat0u5.lifeseries.config.DefaultConfigValues;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.seasons.season.aprilfools.reallife.RealLifeConfig;
import net.mat0u5.lifeseries.seasons.season.aprilfools.simplelife.SimpleLifeConfig;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLifeConfig;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeConfig;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeConfig;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLifeConfig;
import net.mat0u5.lifeseries.seasons.season.thirdlife.ThirdLifeConfig;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLifeConfig;
import net.minecraft.class_3222;

public abstract class ConfigManager
extends DefaultConfigValues {
    protected Properties properties = new Properties();
    protected String folderPath;
    protected String filePath;

    protected ConfigManager(String folderPath, String filePath) {
        this.folderPath = folderPath;
        this.filePath = folderPath + "/" + filePath;
        this.createFileIfNotExists();
        this.loadProperties();
        this.renamedProperties();
        this.instantiateProperties();
    }

    protected List<ConfigFileEntry<?>> getDefaultConfigEntries() {
        return new ArrayList(List.of(this.GROUP_GLOBAL, this.GROUP_SEASON, this.DEFAULT_LIVES, this.MAX_PLAYER_HEALTH, this.KEEP_INVENTORY, this.WORLDBORDER_SIZE, this.ALLOW_SELF_DEFENSE, this.GROUP_BLACKLIST, this.BOOGEYMAN, this.GIVELIFE_COMMAND_ENABLED, this.GROUP_FINAL_DEATH, this.CUSTOM_ENCHANTER_ALGORITHM, this.MUTE_DEAD_PLAYERS, this.GROUP_TABLIST, this.TAB_LIST_SHOW_DEAD_PLAYERS, this.TAB_LIST_SHOW_LIVES, this.GROUP_SPAWN_EGG, this.GROUP_WATCHERS, this.SHOW_HEALTH_BELOW_NAME, this.BLACKLIST_ITEMS, this.BLACKLIST_BLOCKS, this.BLACKLIST_CLAMPED_ENCHANTS, this.BLACKLIST_BANNED_ENCHANTS, this.BLACKLIST_BANNED_POTION_EFFECTS, this.CREATIVE_IGNORE_BLACKLIST, this.BOOGEYMAN_MIN_AMOUNT, this.BOOGEYMAN_MAX_AMOUNT, this.BOOGEYMAN_CHANCE_MULTIPLIER, this.BOOGEYMAN_IGNORE, this.BOOGEYMAN_FORCE, this.BOOGEYMAN_MESSAGE, this.BOOGEYMAN_CHOOSE_MINUTE, this.BOOGEYMAN_ANNOUNCE_OUTCOME, this.PLAYERS_DROP_ITEMS_ON_FINAL_DEATH, this.FINAL_DEATH_TITLE_SHOW, this.FINAL_DEATH_TITLE_SUBTITLE, this.FINAL_DEATH_MESSAGE, this.FINAL_DEATH_LIGHTNING, this.FINAL_DEATH_SOUND, this.GIVELIFE_LIVES_MAX, this.GIVELIFE_BROADCAST, this.TAB_LIST_SHOW_EXACT_LIVES, this.SPAWN_EGG_DROP_CHANCE, this.SPAWN_EGG_DROP_ONLY_NATURAL, this.SPAWN_EGG_ALLOW_ON_SPAWNER, this.SPAWNER_RECIPE, this.WATCHERS_IN_TAB, this.WATCHERS_MUTED));
    }

    protected List<ConfigFileEntry<?>> getSeasonSpecificConfigEntries() {
        return new ArrayList(List.of());
    }

    protected List<ConfigFileEntry<?>> getAllConfigEntries() {
        ArrayList allEntries = new ArrayList();
        allEntries.addAll(this.getDefaultConfigEntries());
        allEntries.addAll(this.getSeasonSpecificConfigEntries());
        return allEntries;
    }

    protected void instantiateProperties() {
        for (ConfigFileEntry<?> entry : this.getAllConfigEntries()) {
            Object t = entry.defaultValue;
            if (t instanceof Integer) {
                Integer integerValue = (Integer)t;
                this.getOrCreateInt(entry.key, integerValue);
                continue;
            }
            t = entry.defaultValue;
            if (t instanceof Boolean) {
                Boolean booleanValue = (Boolean)t;
                this.getOrCreateBoolean(entry.key, booleanValue);
                continue;
            }
            t = entry.defaultValue;
            if (t instanceof Double) {
                Double doubleValue = (Double)t;
                this.getOrCreateDouble(entry.key, doubleValue);
                continue;
            }
            t = entry.defaultValue;
            if (!(t instanceof String)) continue;
            String stringValue = (String)t;
            this.getOrCreateProperty(entry.key, stringValue);
        }
    }

    public void sendConfigTo(class_3222 player) {
        int index = 0;
        for (ConfigFileEntry<?> entry : this.getAllConfigEntries()) {
            this.sendConfigEntry(player, entry, index);
            ++index;
        }
    }

    public void sendConfigEntry(class_3222 player, ConfigFileEntry<?> entry, int index) {
        NetworkHandlerServer.sendConfig(player, this.getConfigPayload(entry, index));
    }

    public ConfigPayload getConfigPayload(ConfigFileEntry<?> entry, int index) {
        String value = "";
        if (!entry.type.parentText()) {
            value = this.getPropertyAsString(entry.key, entry.defaultValue);
        }
        String defaultValue = "";
        if (entry.defaultValue != null) {
            defaultValue = entry.defaultValue.toString();
        }
        ArrayList<String> args = new ArrayList<String>(List.of(value, defaultValue, entry.groupInfo));
        if (entry.args != null) {
            args.addAll(entry.args);
        }
        return new ConfigPayload(entry.type.toString(), entry.key, index, entry.displayName, entry.description, args);
    }

    private String getPropertyAsString(String key, Object defaultValue) {
        if (defaultValue instanceof Integer) {
            Integer intValue = (Integer)defaultValue;
            return String.valueOf(this.getOrCreateInt(key, intValue));
        }
        if (defaultValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)defaultValue;
            return String.valueOf(this.getOrCreateBoolean(key, booleanValue));
        }
        if (defaultValue instanceof Double) {
            Double doubleValue = (Double)defaultValue;
            return String.valueOf(this.getOrCreateDouble(key, doubleValue));
        }
        if (defaultValue instanceof String) {
            String stringValue = (String)defaultValue;
            return this.getOrCreateProperty(key, stringValue);
        }
        return defaultValue.toString();
    }

    protected void renamedProperties() {
        this.renamedProperty("show_death_title_on_last_death", "final_death_title_show");
        this.renamedProperty("players_drop_items_on_last_death", "players_drop_items_on_final_death");
        this.renamedProperty("blacklist_banned_potions", "blacklist_banned_potion_effects");
        this.renamedProperty("auto_keep_inventory", "keep_inventory");
    }

    private void renamedProperty(String from, String to) {
        if (this.properties.containsKey(from)) {
            String value;
            if (!this.properties.containsKey(to) && (value = this.getProperty(from)) != null) {
                this.setProperty(to, value);
            }
            this.removeProperty(from);
        }
    }

    public static void moveOldMainFileIfExists() {
        File newFolder = new File("./config/lifeseries/main/");
        if (!newFolder.exists() && !newFolder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)newFolder);
            return;
        }
        File oldFile = new File("./config/lifeseries.properties");
        if (!oldFile.exists()) {
            return;
        }
        File newFile = new File("./config/lifeseries/main/lifeseries.properties");
        if (newFile.exists()) {
            if (oldFile.delete()) {
                Main.LOGGER.info("Deleted old config file.");
            }
        } else {
            try {
                Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Main.LOGGER.info("Moved old config file.");
            }
            catch (IOException e) {
                Main.LOGGER.info("Failed to move old config file.");
            }
        }
    }

    public static void createConfigs() {
        new ThirdLifeConfig();
        new LastLifeConfig();
        new DoubleLifeConfig();
        new LimitedLifeConfig();
        new SecretLifeConfig();
        new WildLifeConfig();
        new RealLifeConfig();
        new SimpleLifeConfig();
    }

    private void createFileIfNotExists() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        File configDir = new File(this.folderPath);
        if (!configDir.exists() && !configDir.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)configDir);
            return;
        }
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            try {
                if (!configFile.createNewFile()) {
                    Main.LOGGER.error("Failed to create file {}", (Object)configFile);
                    return;
                }
                try (FileOutputStream output = new FileOutputStream(configFile);){
                    this.instantiateProperties();
                    this.properties.store(output, null);
                }
            }
            catch (IOException ex) {
                Main.LOGGER.error(ex.getMessage());
            }
        }
    }

    public void loadProperties() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.filePath);){
            this.properties.load(input);
        }
        catch (IOException ex) {
            Main.LOGGER.error(ex.getMessage());
        }
    }

    public void setProperty(String key, String value) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties.setProperty(key, value);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            Main.LOGGER.error(ex.getMessage());
        }
    }

    public void removeProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        if (!this.properties.containsKey(key)) {
            return;
        }
        this.properties.remove(key);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            Main.LOGGER.error(ex.getMessage());
        }
    }

    public void setPropertyCommented(String key, String value, String comment) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties.setProperty(key, value);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, comment);
        }
        catch (IOException ex) {
            Main.LOGGER.error(ex.getMessage());
        }
    }

    public void resetProperties(String comment) {
        this.properties.clear();
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, comment);
        }
        catch (IOException ex) {
            Main.LOGGER.error(ex.getMessage());
        }
    }

    public String getProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return null;
        }
        if (this.properties == null) {
            return null;
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    public String getOrCreateProperty(String key, String defaultValue) {
        if (this.folderPath == null || this.filePath == null) {
            return "";
        }
        if (this.properties == null) {
            return "";
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        this.setProperty(key, defaultValue);
        return defaultValue;
    }

    public boolean getOrCreateBoolean(String key, boolean defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public double getOrCreateDouble(String key, double defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int getOrCreateInt(String key, int defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

