/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.holder.entity.EntityHolder;
import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.pathfinder.PathFinder;
import net.mat0u5.lifeseries.entity.snail.goal.MiningNavigation;
import net.mat0u5.lifeseries.entity.snail.goal.SnailBlockInteractGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailFlyGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailGlideGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailJumpAttackPlayerGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailLandGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailMineTowardsPlayerGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailPushEntitiesGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailPushProjectilesGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailStartFlyingGoal;
import net.mat0u5.lifeseries.entity.snail.goal.SnailTeleportGoal;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.SnailSkinsServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.AstralProjection;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.WorldUitls;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1409;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Snail
extends class_1588
implements AnimatedEntity {
    public static final class_5321<class_8110> SNAIL_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)class_2960.method_60655((String)"lifeseries", (String)"snail"));
    public static final class_2960 ID = class_2960.method_60655((String)"lifeseries", (String)"snail");
    public static final Model MODEL = BbModelLoader.load((class_2960)ID);
    public static final class_2960 TRIVIA_ID = class_2960.method_60655((String)"lifeseries", (String)"trivia_snail");
    public static final Model TRIVIA_MODEL = BbModelLoader.load((class_2960)TRIVIA_ID);
    public static double GLOBAL_SPEED_MULTIPLIER = 1.0;
    public static boolean SHOULD_DROWN_PLAYER = true;
    public EntityHolder<Snail> holder = null;
    public EntityAttachment attachment = null;
    public UUID boundPlayerUUID;
    public boolean attacking;
    public boolean flying;
    public boolean gliding;
    public boolean landing;
    public boolean mining;
    public boolean setNavigation = false;
    public boolean fromTrivia = false;
    public int dontAttackFor = 0;
    @Nullable
    public PathFinder groundPathFinder;
    @Nullable
    public PathFinder pathFinder;
    public int nullPlayerChecks = 0;
    public class_2561 snailName;
    private int lastAir = 0;
    private int snailSkin = -1;
    private int updateModelCooldown = -1;
    public static final float MOVEMENT_SPEED = 0.35f;
    public static final float FLYING_SPEED = 0.3f;
    public static final int STATIONARY_TP_COOLDOWN = 400;
    public static final int TP_MIN_RANGE = 75;
    public static final int MAX_DISTANCE = 150;
    public static final int JUMP_COOLDOWN_SHORT = 10;
    public static final int JUMP_COOLDOWN_LONG = 30;
    public static final int JUMP_RANGE_SQUARED = 14;
    private int flyAnimation = 0;
    private double lastSpeedMultiplier = 1.0;
    boolean isInLavaLocal = false;
    private int propellerSoundCooldown = 0;
    private int walkSoundCooldown = 0;
    private boolean lastFlying = false;
    private boolean lastGlidingOrLanding = false;
    private int soundCooldown = 0;

    public Snail(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5684(true);
        this.method_5971();
    }

    public void setSnailSkin(int skinIndex) {
        this.snailSkin = skinIndex;
    }

    public void updateHolderSkin() {
        if (this.snailSkin >= 0) {
            List elements = this.holder.getElements();
            for (VirtualElement element : elements) {
                ItemDisplayElement itemDisplayElement;
                class_1799 currentItem;
                class_2960 customModelComponent;
                if (!(element instanceof ItemDisplayElement) || (customModelComponent = (class_2960)(currentItem = (itemDisplayElement = (ItemDisplayElement)element).getItem()).method_58694(class_9334.field_54199)) == null) continue;
                int modelIndex = 0;
                int oldCMD = 0;
                String path = customModelComponent.method_12832().replaceAll("snail/", "").replaceAll("snail_snail_", "");
                if (customModelComponent.method_12836().equalsIgnoreCase("bil")) {
                    if (path.startsWith("e4d04078")) {
                        modelIndex = 1;
                    } else if (path.startsWith("bfab22f7")) {
                        modelIndex = 2;
                    } else if (path.startsWith("795d5ecc")) {
                        modelIndex = 3;
                    } else if (path.startsWith("f10b7849")) {
                        modelIndex = 4;
                    } else if (path.startsWith("b19373c3")) {
                        modelIndex = 5;
                    } else if (path.startsWith("6106e834")) {
                        modelIndex = 6;
                    } else if (path.startsWith("21270a34")) {
                        modelIndex = 7;
                    } else if (path.startsWith("579f1e4f")) {
                        modelIndex = 8;
                    } else if (path.startsWith("b2a5becb")) {
                        modelIndex = 9;
                    }
                    oldCMD = modelIndex + 1;
                } else if (path.startsWith("body") && path.contains("_")) {
                    try {
                        String[] split = path.split("_");
                        modelIndex = Integer.parseInt(split[0].replaceAll("body", ""));
                        oldCMD = Integer.parseInt(split[1]);
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (modelIndex <= 0 || oldCMD <= 0) continue;
                if (oldCMD > 10000) {
                    oldCMD = (oldCMD - 9999) % 10;
                }
                int newCMD = 9999 + oldCMD + this.snailSkin * 10;
                class_2960 finalIdentifier = class_2960.method_60655((String)"snailtextures", (String)("body" + modelIndex + "_" + newCMD));
                currentItem.method_57379(class_9334.field_54199, (Object)finalIdentifier);
                class_1799 newItem = class_1802.field_8560.method_7854();
                newItem.method_57365(currentItem.method_57353());
                itemDisplayElement.setItem(newItem);
            }
        }
    }

    public void updateSkin(class_3222 player) {
        if (player == null) {
            return;
        }
        String playerNameLower = player.method_5820().toLowerCase();
        if (SnailSkinsServer.indexedSkins.containsKey(playerNameLower)) {
            this.setSnailSkin(SnailSkinsServer.indexedSkins.get(playerNameLower));
            this.updateModel(true);
        }
    }

    public void updateModel(boolean force) {
        if (this.updateModelCooldown > 0 && !force) {
            return;
        }
        this.updateModelCooldown = 5;
        if (this.attachment != null) {
            this.attachment.destroy();
        }
        if (this.holder != null) {
            this.holder.destroy();
        }
        this.holder = !this.fromTrivia ? new LivingEntityHolder((class_1309)this, MODEL) : new LivingEntityHolder((class_1309)this, TRIVIA_MODEL);
        this.holder.tick();
        this.attachment = EntityAttachment.ofTicking(this.holder, (class_1297)this);
        this.attachment.tick();
        if (this.snailSkin >= 0) {
            this.updateHolderSkin();
        }
        if (this.getActualBoundPlayer() != null) {
            this.sendDisplayEntityPackets(this.getActualBoundPlayer());
        }
    }

    public int getJumpRangeSquared() {
        if (this.isNerfed()) {
            return 9;
        }
        return 14;
    }

    public void setBoundPlayer(class_3222 player) {
        if (player == null) {
            return;
        }
        this.boundPlayerUUID = player.method_5667();
        this.updateSnailName();
        this.sendDisplayEntityPackets(player);
    }

    public void sendDisplayEntityPackets(class_3222 player) {
        if (this.holder == null) {
            return;
        }
        List elements = this.holder.getElements();
        for (VirtualElement element : elements) {
            if (!(element instanceof ItemDisplayElement)) continue;
            ItemDisplayElement itemDisplayElement = (ItemDisplayElement)element;
            if (!this.fromTrivia) {
                NetworkHandlerServer.sendStringPacket(player, PacketNames.SNAIL_PART, itemDisplayElement.getUuid().toString());
                continue;
            }
            NetworkHandlerServer.sendStringPacket(player, PacketNames.TRIVIA_SNAIL_PART, itemDisplayElement.getUuid().toString());
        }
    }

    public void updateSnailName() {
        if (this.getBoundPlayer() == null) {
            return;
        }
        this.snailName = class_2561.method_30163((String)Snails.getSnailName(this.getBoundPlayer()));
    }

    protected class_2561 method_23315() {
        if (this.fromTrivia) {
            return class_2561.method_30163((String)"VHSnail");
        }
        if (this.snailName == null) {
            return this.method_5864().method_5897();
        }
        if (this.snailName.getString().isEmpty()) {
            return this.method_5864().method_5897();
        }
        return this.snailName;
    }

    public EntityHolder<Snail> getHolder() {
        return this.holder;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10000.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23720, (double)0.3f).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23717, 150.0).method_26868(class_5134.field_51578, 1.0).method_26868(class_5134.field_49079, 100.0).method_26868(class_5134.field_23721, 20.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SnailTeleportGoal(this));
        this.field_6201.method_6277(1, (class_1352)new SnailLandGoal(this));
        this.field_6201.method_6277(2, (class_1352)new SnailMineTowardsPlayerGoal(this));
        this.field_6201.method_6277(3, (class_1352)new SnailFlyGoal(this));
        this.field_6201.method_6277(4, (class_1352)new SnailGlideGoal(this));
        this.field_6201.method_6277(5, (class_1352)new SnailJumpAttackPlayerGoal(this));
        this.field_6201.method_6277(6, (class_1352)new SnailStartFlyingGoal(this));
        this.field_6201.method_6277(7, (class_1352)new SnailBlockInteractGoal(this));
        this.field_6201.method_6277(8, (class_1352)new SnailPushEntitiesGoal(this));
        this.field_6201.method_6277(9, (class_1352)new SnailPushProjectilesGoal(this));
    }

    public void method_5773() {
        class_3222 boundPlayer;
        if (this.isPaused()) {
            this.field_6189.method_6340();
            return;
        }
        super.method_5773();
        if (this.field_6012 % 10 == 0 && this.getActualBoundPlayer() != null) {
            class_2338 pos = this.method_24515();
            boolean sameDimensions = this.method_37908().method_27983().equals(this.getActualBoundPlayer().method_37908().method_27983());
            if (sameDimensions) {
                if (!this.fromTrivia) {
                    NetworkHandlerServer.sendStringPacket(this.getActualBoundPlayer(), PacketNames.SNAIL_POS, TextUtils.formatString("{}_{}_{}", pos.method_10263(), pos.method_10264(), pos.method_10260()));
                } else {
                    NetworkHandlerServer.sendStringPacket(this.getActualBoundPlayer(), PacketNames.TRIVIA_SNAIL_POS, TextUtils.formatString("{}_{}_{}", pos.method_10263(), pos.method_10264(), pos.method_10260()));
                }
            }
        }
        if (this.field_6012 % 400 == 0 && this.getActualBoundPlayer() != null && this.getActualBoundPlayer() != null) {
            this.sendDisplayEntityPackets(this.getActualBoundPlayer());
        }
        if (this.updateModelCooldown > 0) {
            --this.updateModelCooldown;
        }
        if ((this.holder == null || this.attachment == null) && this.field_6012 > 2) {
            this.updateModel(false);
        }
        if (this.dontAttackFor > 0) {
            --this.dontAttackFor;
        }
        if (this.nullPlayerChecks > 200 && !this.fromTrivia) {
            this.despawn();
        }
        if (this.field_6012 % 20 == 0) {
            this.updateSnailName();
        }
        if (this.field_6012 % 2 == 0) {
            this.updateAnimations();
        }
        if (this.field_6012 % 50 == 0) {
            if (!this.fromTrivia) {
                if (!Snails.snails.containsValue((Object)this) || !WildcardManager.isActiveWildcard(Wildcards.SNAILS)) {
                    this.despawn();
                }
            } else if (!WildcardManager.isActiveWildcard(Wildcards.TRIVIA) || this.field_6012 >= 36000) {
                this.despawn();
            }
        }
        if ((boundPlayer = this.getBoundPlayer()) != null) {
            if (this.method_5829().method_1014(0.05).method_994(boundPlayer.method_5829())) {
                this.killBoundPlayer();
            }
            if (this.field_6012 % 100 == 0 || !this.setNavigation) {
                this.setNavigation = true;
                this.updateMoveControl();
                this.updateNavigation();
            } else if (this.field_6012 % 21 == 0) {
                this.updateMovementSpeed();
            } else if (this.field_6012 % 5 == 0) {
                this.updateNavigationTarget();
            }
        }
        if (SHOULD_DROWN_PLAYER && !this.fromTrivia && this.getBoundPlayer() != null) {
            int currentAir = this.method_5669();
            if (this.getBoundPlayer().method_6059(class_1294.field_5923)) {
                currentAir = this.method_5748();
            }
            if (this.lastAir != currentAir) {
                this.lastAir = currentAir;
                NetworkHandlerServer.sendNumberPacket(this.getBoundPlayer(), PacketNames.SNAIL_AIR, currentAir);
            }
            if (currentAir == 0) {
                this.damageFromDrowning();
            }
        }
        this.handleHighVelocity();
        this.updatePathFinders();
        this.chunkLoading();
        this.playSounds();
        this.method_6012();
    }

    public boolean isPaused() {
        return Main.currentSession.statusPaused();
    }

    public boolean isNerfed() {
        if (this.fromTrivia) {
            return true;
        }
        return WildcardManager.isActiveWildcard(Wildcards.CALLBACK);
    }

    public void setFromTrivia() {
        this.fromTrivia = true;
        this.dontAttackFor = 100;
        this.method_59928();
    }

    public void chunkLoading() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.addTicket(world);
        }
    }

    public void addTicket(class_3218 world) {
        world.method_14178().method_66009(class_3230.field_19280, new class_1923(this.method_24515()), 2);
    }

    public void despawn() {
        NetworkHandlerServer.sendNumberPacket(this.getBoundPlayer(), PacketNames.SNAIL_AIR, 300.0);
        if (this.boundPlayerUUID != null) {
            TriviaWildcard.bots.remove(this.boundPlayerUUID);
        }
        this.killPathFinders();
        this.method_5768((class_3218)this.method_37908());
        this.method_31472();
    }

    public void killPathFinders() {
        if (this.groundPathFinder != null) {
            this.groundPathFinder.method_5768((class_3218)this.groundPathFinder.method_37908());
        }
        if (this.pathFinder != null) {
            this.pathFinder.method_5768((class_3218)this.pathFinder.method_37908());
        }
        if (this.groundPathFinder != null) {
            this.groundPathFinder.method_31472();
        }
        if (this.pathFinder != null) {
            this.pathFinder.method_31472();
        }
    }

    public void handleHighVelocity() {
        class_243 velocity = this.method_18798();
        if (velocity.field_1351 > 0.15) {
            this.method_18800(velocity.field_1352, 0.15, velocity.field_1350);
        } else if (velocity.field_1351 < -0.15) {
            this.method_18800(velocity.field_1352, -0.15, velocity.field_1350);
        }
    }

    public void killBoundPlayer() {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        class_3218 world = PlayerUtils.getServerWorld(player);
        class_1282 damageSource = new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_46747(SNAIL_DAMAGE));
        player.method_6015((class_1309)this);
        player.method_64397(world, damageSource, 1000.0f);
    }

    public void damageFromDrowning() {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        if (player.method_29504()) {
            return;
        }
        class_3218 world = PlayerUtils.getServerWorld(player);
        class_1282 damageSource = new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_46747(class_8111.field_42342));
        player.method_6015((class_1309)this);
        player.method_64397(world, damageSource, 2.0f);
        if (player.method_29504()) {
            this.despawn();
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public void updateAnimations() {
        if (this.holder == null) {
            return;
        }
        Animator animator = this.holder.getAnimator();
        if (this.flyAnimation < 0) {
            ++this.flyAnimation;
            this.pauseAllAnimations("stopFly");
        } else if (this.flyAnimation > 0) {
            --this.flyAnimation;
            this.pauseAllAnimations("startFly");
        } else if (this.flying) {
            this.pauseAllAnimations("fly");
            animator.playAnimation("fly", 3);
        } else if (this.gliding || this.landing) {
            this.pauseAllAnimations("glide");
            animator.playAnimation("glide", 2);
        } else if (this.field_42108.method_48571() && (double)this.field_42108.method_48566() > 0.02) {
            this.pauseAllAnimations("walk");
            animator.playAnimation("walk", 1);
        } else {
            this.pauseAllAnimations("idle");
            animator.playAnimation("idle", 0, true);
        }
    }

    public void pauseAllAnimations(String except) {
        Animator animator = this.holder.getAnimator();
        if (!except.equalsIgnoreCase("glide")) {
            animator.pauseAnimation("glide");
        }
        if (!except.equalsIgnoreCase("fly")) {
            animator.pauseAnimation("fly");
        }
        if (!except.equalsIgnoreCase("walk")) {
            animator.pauseAnimation("walk");
        }
        if (!except.equalsIgnoreCase("idle")) {
            animator.pauseAnimation("idle");
        }
    }

    public void playStartFlyAnimation() {
        this.flyAnimation = 7;
        Animator animator = this.holder.getAnimator();
        animator.playAnimation("startFly", 4);
    }

    public void playStopFlyAnimation() {
        this.flyAnimation = -7;
        Animator animator = this.holder.getAnimator();
        animator.playAnimation("stopFly", 5);
    }

    public void updatePathFinders() {
        class_2338 pos;
        if (this.pathFinder != null && this.pathFinder.method_33724()) {
            this.pathFinder.method_31472();
            this.pathFinder = null;
        } else if (this.pathFinder == null || this.pathFinder.method_31481()) {
            this.pathFinder = (PathFinder)MobRegistry.PATH_FINDER.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16462);
        } else {
            this.pathFinder.resetDespawnTimer();
        }
        if (this.groundPathFinder != null && this.groundPathFinder.method_33724()) {
            this.groundPathFinder.method_31472();
            this.groundPathFinder = null;
        } else if (this.groundPathFinder == null || this.groundPathFinder.method_31481()) {
            this.groundPathFinder = (PathFinder)MobRegistry.PATH_FINDER.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16462);
        } else {
            this.groundPathFinder.resetDespawnTimer();
        }
        class_3218 world = (class_3218)this.method_37908();
        if (this.pathFinder != null) {
            this.pathFinder.method_48105(world, this.method_23317(), this.method_23318(), this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), false);
        }
        if ((pos = this.getGroundBlock()) == null) {
            return;
        }
        if (this.groundPathFinder != null) {
            this.groundPathFinder.method_48105(world, this.method_23317(), pos.method_10264() + 1, this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), false);
        }
    }

    @Nullable
    public class_2338 getGroundBlock() {
        class_243 startPos = this.method_19538();
        class_243 endPos = new class_243(startPos.method_10216(), (double)this.method_37908().method_31607(), startPos.method_10215());
        class_3965 result = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return result.method_17777();
    }

    public double getDistanceToGroundBlock() {
        class_2338 belowBlock = this.getGroundBlock();
        if (belowBlock == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.method_23318() - (double)belowBlock.method_10264() - 1.0;
    }

    public void fakeTeleportNearPlayer(double minDistanceFromPlayer) {
        class_3222 player = this.getBoundPlayer();
        if (player == null) {
            return;
        }
        class_3218 playerWorld = PlayerUtils.getServerWorld(player);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_2338 tpTo = Snail.getBlockPosNearTarget(player, minDistanceFromPlayer);
            world.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_46945, this.method_5634(), this.method_6107(), this.method_6017());
            playerWorld.method_43128(null, (double)tpTo.method_10263(), (double)tpTo.method_10264(), (double)tpTo.method_10260(), class_3417.field_46945, this.method_5634(), this.method_6107(), this.method_6017());
            AnimationUtils.spawnTeleportParticles(world, this.method_19538());
            AnimationUtils.spawnTeleportParticles(playerWorld, tpTo.method_46558());
            this.despawn();
            Snails.spawnSnailFor(player, tpTo);
        }
    }

    public static class_2338 getBlockPosNearTarget(class_3222 target, double distanceFromTarget) {
        if (target == null) {
            return null;
        }
        class_2338 targetPos = target.method_24515();
        return WorldUitls.getCloseBlockPos(PlayerUtils.getServerWorld(target), targetPos, distanceFromTarget, 1, false);
    }

    public boolean canPathToPlayer(boolean flying) {
        if (this.pathFinder == null) {
            return false;
        }
        return this.pathFinder.canPathfind((class_1297)this.getBoundPlayer(), flying);
    }

    public boolean canPathToPlayerFromGround(boolean flying) {
        if (this.groundPathFinder == null) {
            return false;
        }
        return this.groundPathFinder.canPathfind((class_1297)this.getBoundPlayer(), flying);
    }

    public boolean isValidBlockOnGround() {
        if (this.groundPathFinder == null) {
            return false;
        }
        class_2680 block = this.groundPathFinder.method_37908().method_8320(this.groundPathFinder.method_24515());
        if (block.method_27852(class_2246.field_10164)) {
            return false;
        }
        if (block.method_27852(class_2246.field_10382)) {
            return false;
        }
        return !block.method_27852(class_2246.field_27879);
    }

    public void updateNavigation() {
        if (this.mining) {
            this.setNavigationMining();
        } else if (this.flying) {
            this.setNavigationFlying();
        } else {
            this.setNavigationWalking();
        }
    }

    public void updateMoveControl() {
        if (this.flying || this.mining) {
            this.setMoveControlFlight();
        } else {
            this.setMoveControlWalking();
        }
    }

    public void setNavigationFlying() {
        this.method_5941(class_7.field_22, -1.0f);
        this.method_5941(class_7.field_19, -1.0f);
        this.method_5941(class_7.field_47413, -1.0f);
        this.method_5941(class_7.field_26446, -1.0f);
        this.method_5941(class_7.field_15, -1.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6189 = new class_1407((class_1308)this, this.method_37908());
        this.updateNavigationTarget();
    }

    public void setNavigationWalking() {
        this.method_5941(class_7.field_22, -1.0f);
        this.method_5941(class_7.field_19, -1.0f);
        this.method_5941(class_7.field_47413, -1.0f);
        this.method_5941(class_7.field_26446, -1.0f);
        this.method_5941(class_7.field_15, -1.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6189 = new class_1409((class_1308)this, this.method_37908());
        this.updateNavigationTarget();
    }

    public void setNavigationMining() {
        this.method_5941(class_7.field_22, 0.0f);
        this.method_5941(class_7.field_19, 0.0f);
        this.method_5941(class_7.field_47413, 0.0f);
        this.method_5941(class_7.field_26446, 0.0f);
        this.method_5941(class_7.field_15, 0.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6189 = new MiningNavigation((class_1308)this, this.method_37908());
        this.updateNavigationTarget();
    }

    public void updateNavigationTarget() {
        if (this.getBoundPlayer() == null) {
            return;
        }
        if (this.method_5739((class_1297)this.getBoundPlayer()) > 150.0f) {
            return;
        }
        if (this.field_6189 instanceof class_1407) {
            this.field_6189.method_6344(1.0);
            class_11 path = this.field_6189.method_6349((class_1297)this.getBoundPlayer(), 0);
            if (path != null) {
                this.field_6189.method_6334(path, 1.0);
            }
        } else {
            this.field_6189.method_6344((double)0.35f);
            class_11 path = this.field_6189.method_6349((class_1297)this.getBoundPlayer(), 0);
            if (path != null) {
                this.field_6189.method_6334(path, (double)0.35f);
            }
        }
    }

    public void updateMovementSpeed() {
        class_11 path = this.field_6189.method_6345();
        if (path != null) {
            double length = path.method_38();
            double speedMultiplier = 1.0;
            if (length > 10.0) {
                speedMultiplier += length / 100.0;
            }
            if (speedMultiplier != this.lastSpeedMultiplier) {
                this.lastSpeedMultiplier = speedMultiplier;
                double movementSpeed = (double)0.35f * speedMultiplier * GLOBAL_SPEED_MULTIPLIER;
                double flyingSpeed = (double)0.3f * speedMultiplier * GLOBAL_SPEED_MULTIPLIER;
                if (this.isNerfed()) {
                    movementSpeed *= 0.6;
                    flyingSpeed *= 0.6;
                }
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(movementSpeed);
                Objects.requireNonNull(this.method_5996(class_5134.field_23720)).method_6192(flyingSpeed);
            }
        }
    }

    public void setMoveControlFlight() {
        this.method_5875(true);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
    }

    public void setMoveControlWalking() {
        this.method_5875(false);
        this.field_6207 = new class_1335((class_1308)this);
    }

    @Nullable
    public class_3222 getBoundPlayer() {
        Superpower superpower;
        if (Main.server == null) {
            return null;
        }
        class_3222 player = PlayerUtils.getPlayer(this.boundPlayerUUID);
        if (player == null || player.method_7325() && !Main.livesManager.isAlive(player)) {
            ++this.nullPlayerChecks;
            return null;
        }
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.ASTRAL_PROJECTION) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof AstralProjection) {
            AstralProjection astralProjection = (AstralProjection)superpower;
            return astralProjection.clone;
        }
        this.nullPlayerChecks = 0;
        if (player.method_68878()) {
            return null;
        }
        if (player.method_7325()) {
            return null;
        }
        if (!Main.livesManager.isAlive(player)) {
            return null;
        }
        if (Events.joiningPlayers.contains(player.method_5667())) {
            return null;
        }
        return player;
    }

    @Nullable
    public class_3222 getActualBoundPlayer() {
        if (Main.server == null) {
            return null;
        }
        return PlayerUtils.getPlayer(this.boundPlayerUUID);
    }

    public class_243 method_26317(double gravity, boolean falling, class_243 motion) {
        return motion;
    }

    public boolean method_29920() {
        return false;
    }

    public boolean method_5799() {
        return false;
    }

    public void method_5796(boolean swimming) {
        this.method_5729(4, false);
    }

    public boolean method_5692(class_6862<class_3611> tag, double speed) {
        if (class_3486.field_15518 != tag) {
            return false;
        }
        if (this.method_33724()) {
            return false;
        }
        class_238 box = this.method_5829().method_1011(0.001);
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1322);
        int l = class_3532.method_15384((double)box.field_1325);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        double d = 0.0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = k; q < l; ++q) {
                for (int r = m; r < n; ++r) {
                    double e;
                    mutable.method_10103(p, q, r);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(tag) || !((e = (double)((float)q + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable))) >= box.field_1322)) continue;
                    d = Math.max(e - box.field_1322, d);
                }
            }
        }
        this.isInLavaLocal = d > 0.0;
        return false;
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        this.killPathFinders();
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    public boolean method_37222(class_1293 effect, @Nullable class_1297 source) {
        return false;
    }

    public void playSounds() {
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if (this.isInLavaLocal && this.field_5974.method_43048(100) == 0) {
            this.playLavaSound();
        }
        if (this.method_5809() && this.field_5974.method_43048(100) == 0) {
            this.playBurnSound();
        }
        if (this.method_5669() == 0 && this.field_5974.method_43048(100) == 0) {
            this.playDrownSound();
        }
        if ((this.gliding || this.landing) && !this.lastGlidingOrLanding) {
            this.playFallSound();
        }
        if (this.flying) {
            if (!this.lastFlying) {
                this.playFlySound();
            }
            if (this.propellerSoundCooldown > 0) {
                --this.propellerSoundCooldown;
            }
            if (this.propellerSoundCooldown == 0) {
                this.propellerSoundCooldown = 40;
                this.playPropellerSound();
            }
        }
        if (!this.flying && !this.gliding && !this.landing && (double)this.field_6250 > 0.001) {
            if (this.walkSoundCooldown > 0) {
                --this.walkSoundCooldown;
            }
            if (this.walkSoundCooldown == 0) {
                this.walkSoundCooldown = 22;
                this.playWalkSound();
            }
        }
        this.lastFlying = this.flying;
        this.lastGlidingOrLanding = this.gliding || this.landing;
    }

    public void method_59928() {
        this.playRandomSound("attack", 0.25f, 1, 9);
    }

    public void playBurnSound() {
        this.playRandomSound("burn", 0.25f, 1, 9);
    }

    public void playDrownSound() {
        this.playRandomSound("drown", 0.25f, 1, 9);
    }

    public void playFallSound() {
        this.playRandomSound("fall", 0.25f, 1, 5);
    }

    public void playFlySound() {
        this.playRandomSound("fly", 0.25f, 1, 8);
    }

    public void playPropellerSound() {
        int cooldownBefore = this.soundCooldown;
        this.soundCooldown = 0;
        this.playRandomSound("propeller", 0.2f, 0, 0);
        this.soundCooldown = cooldownBefore;
    }

    public void playWalkSound() {
        int cooldownBefore = this.soundCooldown;
        this.soundCooldown = 0;
        this.playRandomSound("walk", 0.1f, 0, 0);
        this.soundCooldown = cooldownBefore;
    }

    public void playLavaSound() {
        this.playRandomSound("lava", 0.25f, 1, 2);
    }

    public void playThrowSound() {
        this.playRandomSound("throw", 0.25f, 1, 7);
    }

    public void playRandomSound(String name, float volume, int from, int to) {
        if (this.soundCooldown > 0) {
            return;
        }
        this.soundCooldown = 20;
        class_3414 sound = OtherUtils.getRandomSound("wildlife_snail_" + name, from, to);
        this.method_5783(sound, volume, 1.0f);
    }
}

