/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.Collection;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.fakeplayer.FakePlayer;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=1)
public class ServerPlayerEntityMixin {
    @Unique
    private boolean ls$processing = false;

    @Inject(method={"getRespawnTarget"}, at={@At(value="HEAD")})
    private void getRespawnTarget(boolean alive, class_5454.class_9823 postDimensionTransition, CallbackInfoReturnable<class_5454> cir) {
        if (!Main.isLogicalSide()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        UUID uuid = player.method_5667();
        Main.currentSeason.onPlayerRespawn(Objects.requireNonNull(PlayerUtils.getPlayer(uuid)));
        TaskScheduler.scheduleTask(1, () -> Main.currentSeason.postPlayerRespawn(Objects.requireNonNull(PlayerUtils.getPlayer(uuid))));
    }

    @Inject(method={"openHandledScreen"}, at={@At(value="HEAD")})
    private void onInventoryOpen(@Nullable class_3908 factory, CallbackInfoReturnable<OptionalInt> cir) {
        if (!Main.isLogicalSide()) {
            return;
        }
        class_3222 player = this.ls$get();
        if (Main.blacklist == null) {
            return;
        }
        TaskScheduler.scheduleTask(1, () -> {
            player.field_7512.method_7602().forEach(itemStack -> Main.blacklist.processItemStack(player, (class_1799)itemStack));
            PlayerUtils.updatePlayerInventory(player);
        });
    }

    @Inject(method={"sendMessageToClient"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendMessageToClient(class_2561 message, boolean overlay, CallbackInfo ci) {
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            ci.cancel();
        }
    }

    @Inject(method={"acceptsMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsMessage(boolean overlay, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"acceptsChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void acceptsChatMessage(CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = this.ls$get();
        if (player instanceof FakePlayer) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttackEntity(class_1297 target, CallbackInfo ci) {
        class_3222 player = this.ls$get();
        Main.currentSeason.onUpdatedInventory(player);
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="TAIL")})
    private void onStatusEffectApplied(class_1293 effect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    @Inject(method={"onStatusEffectsRemoved"}, at={@At(value="TAIL")})
    private void onStatusEffectRemoved(Collection<class_1293> effects, CallbackInfo ci) {
        for (class_1293 effect : effects) {
            this.ls$onUpdatedEffects(effect, false);
        }
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="TAIL")})
    private void onStatusEffectUpgraded(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        this.ls$onUpdatedEffects(effect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void ls$onUpdatedEffects(class_1293 effect, boolean add) {
        if (this.ls$processing) {
            return;
        }
        class_3222 player = this.ls$get();
        this.ls$processing = true;
        try {
            Season season = Main.currentSeason;
            if (season instanceof DoubleLife) {
                DoubleLife doubleLife = (DoubleLife)season;
                doubleLife.syncStatusEffectsFrom(player, effect, add);
            }
        }
        finally {
            this.ls$processing = false;
        }
    }

    @Unique
    private class_3222 ls$get() {
        return (class_3222)this;
    }
}

