/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_9015;

public class LimitedLifeBoogeymanManager
extends BoogeymanManager {
    @Override
    public void sessionEnd() {
        if (!this.BOOGEYMAN_ENABLED) {
            return;
        }
        if (Main.server == null) {
            return;
        }
        for (Boogeyman boogeyman : this.boogeymen) {
            if (boogeyman.died || boogeyman.cured) continue;
            class_3222 player = PlayerUtils.getPlayer(boogeyman.uuid);
            if (player == null) {
                Integer currentLives = ScoreboardUtils.getScore(class_9015.method_55422((String)boogeyman.name), "Lives");
                if (currentLives == null || currentLives <= LimitedLifeLivesManager.RED_TIME) continue;
                if (this.BOOGEYMAN_ANNOUNCE_OUTCOME) {
                    PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. They have been dropped to their \u00a7cLast Life\u00a77.", boogeyman.name));
                }
                if (currentLives > LimitedLifeLivesManager.RED_TIME && currentLives <= LimitedLifeLivesManager.YELLOW_TIME) {
                    ScoreboardUtils.setScore(class_9015.method_55422((String)boogeyman.name), "Lives", LimitedLifeLivesManager.RED_TIME);
                }
                if (currentLives <= LimitedLifeLivesManager.YELLOW_TIME) continue;
                ScoreboardUtils.setScore(class_9015.method_55422((String)boogeyman.name), "Lives", LimitedLifeLivesManager.YELLOW_TIME);
                continue;
            }
            this.playerFailBoogeyman(player);
        }
    }

    @Override
    public void playerFailBoogeyman(class_3222 player) {
        if (!Main.livesManager.isAlive(player)) {
            return;
        }
        if (Main.livesManager.isOnLastLife(player, true)) {
            return;
        }
        if (Main.livesManager.isOnSpecificLives(player, 3, false)) {
            Main.livesManager.setPlayerLives(player, LimitedLifeLivesManager.YELLOW_TIME);
        } else if (Main.livesManager.isOnSpecificLives(player, 2, false)) {
            Main.livesManager.setPlayerLives(player, LimitedLifeLivesManager.RED_TIME);
        }
        class_2561 setTo = Main.livesManager.getFormattedLives(player);
        PlayerUtils.sendTitle(player, class_2561.method_30163((String)"\u00a7cYou have failed."), 20, 30, 20);
        PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"lastlife_boogeyman_fail")));
        if (this.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 failed to kill a player while being the \u00a7cBoogeyman\u00a77. Their time has been dropped to {}", player, setTo));
        }
    }
}

