/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.main;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.EmptyConfigEntry;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.interfaces.IEntryGroupHeader;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TextConfigEntry
extends EmptyConfigEntry
implements IEntryGroupHeader {
    protected static final int TEXT_OFFSET_X = -5;
    protected static final int TEXT_OFFSET_Y = 6;
    private final boolean clickable;
    public boolean clicked;

    public TextConfigEntry(String fieldName, String displayName, String description) {
        this(fieldName, displayName, description, true);
    }

    public TextConfigEntry(String fieldName, String displayName, String description, boolean clickable) {
        super(fieldName, displayName, description);
        this.clickable = clickable;
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        if (!this.clickable) {
            return;
        }
        String text = !this.clicked ? "Click to expand" : "Click to collapse";
        RenderUtils.drawTextRight(context, this.textRenderer, TextColors.LIGHT_GRAY_A128, class_2561.method_30163((String)text), x + width + -5, y + 6);
    }

    @Override
    protected boolean mouseClickedEntry(class_11909 click, boolean doubled) {
        if (this.clickable && click.method_74245() == 0) {
            this.clicked = !this.clicked;
        }
        return this.clickable;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.TEXT;
    }

    @Override
    public void expand() {
        this.clicked = true;
    }

    @Override
    public boolean shouldExpand() {
        return this.clicked;
    }
}

