/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin;

import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2846;
import net.minecraft.class_2886;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.class_7635;
import net.minecraft.class_9449;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class}, priority=1)
public class ServerGamePacketListenerImplMixin {
    @Unique
    private static final List<String> mutedCommands = List.of("msg", "tell", "whisper", "w", "me");

    @Inject(method={"method_44155(Lnet/minecraft/class_7471;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleDecoratedMessage(class_7471 message, CallbackInfo ci) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        class_3222 player = handler.field_14140;
        if (this.ls$mute(handler.field_14140, ci)) {
            return;
        }
        class_2561 originalText = message.method_46291();
        String originalContent = originalText.getString();
        if (!originalContent.contains(":")) {
            return;
        }
        String formattedContent = TextUtils.replaceEmotes(originalContent);
        if (!originalContent.equals(formattedContent)) {
            class_5250 formattedContentText = class_2561.method_43470((String)formattedContent).method_10862(originalText.method_10866());
            class_5250 finalMessage = TextUtils.format("<{}> {}", player, formattedContentText);
            PlayerUtils.broadcastMessage((class_2561)finalMessage);
            ci.cancel();
        }
    }

    @Inject(method={"method_12065(Lnet/minecraft/class_2886;)V"}, at={@At(value="HEAD")})
    private void onPlayerInteractItem(class_2886 packet, CallbackInfo ci) {
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        class_3222 player = handler.field_14140;
        if (Main.currentSeason instanceof WildLife) {
            WildcardManager.onUseItem(player);
        }
    }

    @Inject(method={"method_58590(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void executeCommand(String command, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        for (String mutedCmd : mutedCommands) {
            boolean stoppedCommand;
            if (!command.startsWith(mutedCmd + " ") || !(stoppedCommand = this.ls$mute(handler.field_14140, ci))) continue;
            return;
        }
    }

    @Inject(method={"method_45010(Lnet/minecraft/class_9449;Lnet/minecraft/class_7635;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2170;method_9249(Lcom/mojang/brigadier/ParseResults;Ljava/lang/String;)V")}, cancellable=true)
    private void handleCommandExecution(class_9449 packet, class_7635 lastSeenMessages, CallbackInfo ci) {
        if (Main.modDisabled()) {
            return;
        }
        class_3244 handler = (class_3244)this;
        for (String command : mutedCommands) {
            boolean stoppedCommand;
            if (!packet.comp_2532().startsWith(command + " ") || !(stoppedCommand = this.ls$mute(handler.field_14140, ci))) continue;
            return;
        }
    }

    @Unique
    private boolean ls$mute(class_3222 player, CallbackInfo ci) {
        TriviaBot bot;
        if (player == null || PermissionManager.isAdmin(player) || Main.modDisabled()) {
            return false;
        }
        if (TriviaWildcard.bots.containsKey(player.method_5667()) && (bot = TriviaWildcard.bots.get(player.method_5667())).interactedWith() && !bot.submittedAnswer()) {
            player.method_64398(class_2561.method_30163((String)"<Trivia Bot> No phoning a friend allowed!"));
            ci.cancel();
            return true;
        }
        if (Main.currentSeason.WATCHERS_MUTED && player.ls$isWatcher()) {
            player.method_64398(class_2561.method_30163((String)"Watchers aren't allowed to talk in chat! Admins can change this behavior in the config."));
            ci.cancel();
            return true;
        }
        if (Main.currentSeason.MUTE_DEAD_PLAYERS && player.ls$isDead() && !player.ls$isWatcher()) {
            player.method_64398(class_2561.method_30163((String)"Dead players aren't allowed to talk in chat! Admins can change this behavior in the config."));
            ci.cancel();
            return true;
        }
        return false;
    }

    @Inject(method={"method_12066(Lnet/minecraft/class_2846;)V"}, at={@At(value="RETURN")})
    public void onPlayerAction(class_2846 packet, CallbackInfo ci) {
        class_3244 handler = (class_3244)this;
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            return;
        }
        if (packet.method_12363() == class_2846.class_2847.field_12969) {
            Main.currentSeason.onUpdatedInventory(handler.field_14140);
        }
    }

    @Redirect(method={"method_52415()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3324;method_43514(Lnet/minecraft/class_2561;Z)V"))
    public void noLogoffMessage(class_3324 instance, class_2561 message, boolean overlay) {
        class_3244 handler = (class_3244)this;
        if (!Main.isLogicalSide() || Main.modDisabled()) {
            instance.method_43514(message, overlay);
        } else {
            PlayerUtils.broadcastToVisiblePlayers(handler.field_14140, message);
        }
    }
}

