/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.Collection;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeBoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeConfig;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeSecretSociety;
import net.mat0u5.lifeseries.seasons.secretsociety.SecretSociety;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.interfaces.IServerPlayer;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9011;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public class LimitedLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /boogeyman";
    public static final String COMMANDS_TEXT = "/claimkill, /lives";
    private boolean SHOW_DEATH_TITLE = true;
    public static int DEATH_NORMAL = -3600;
    private int DEATH_BOOGEYMAN = -7200;
    private int KILL_NORMAL = 1800;
    private int KILL_BOOGEYMAN = 3600;
    public static boolean TICK_OFFLINE_PLAYERS = false;
    private int secondCounter = 0;

    @Override
    public Seasons getSeason() {
        return Seasons.LIMITED_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new LimitedLifeConfig();
    }

    @Override
    public BoogeymanManager createBoogeymanManager() {
        return new LimitedLifeBoogeymanManager();
    }

    @Override
    public SecretSociety createSecretSociety() {
        return new LimitedLifeSecretSociety();
    }

    @Override
    public LivesManager createLivesManager() {
        return new LimitedLifeLivesManager();
    }

    @Override
    public String getAdminCommands() {
        return COMMANDS_ADMIN_TEXT;
    }

    @Override
    public String getNonAdminCommands() {
        return COMMANDS_TEXT;
    }

    public void displayTimers(MinecraftServer server) {
        String message = "";
        if (Main.currentSession.statusNotStarted()) {
            message = "Session has not started";
        } else if (Main.currentSession.statusStarted()) {
            message = Main.currentSession.getRemainingTimeStr();
        } else if (Main.currentSession.statusPaused()) {
            message = "Session has been paused";
        } else if (Main.currentSession.statusFinished()) {
            message = "Session has ended";
        }
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
                Integer playerLivesInt;
                long timestamp = SessionTimerStates.OFF.getValue();
                if (Main.currentSession.statusNotStarted()) {
                    timestamp = SessionTimerStates.NOT_STARTED.getValue();
                } else if (Main.currentSession.statusPaused()) {
                    timestamp = SessionTimerStates.PAUSED.getValue();
                } else if (Main.currentSession.statusFinished()) {
                    timestamp = SessionTimerStates.ENDED.getValue();
                } else if (Main.currentSession.sessionLength != null) {
                    long remainingMillis = (Main.currentSession.sessionLength - (int)Main.currentSession.passedTime) * 50;
                    timestamp = System.currentTimeMillis() + remainingMillis;
                }
                if (timestamp != (long)SessionTimerStates.OFF.getValue()) {
                    NetworkHandlerServer.sendLongPacket(player, PacketNames.SESSION_TIMER, timestamp);
                }
                if (!player.ls$hasAssignedLives() || player.ls$getLives() == null) continue;
                long playerLives = player.ls$isAlive() ? ((playerLivesInt = player.ls$getLives()) == null ? -1L : (long)playerLivesInt.intValue()) : -1L;
                String livesColor = this.livesManager.getColorForLives(player).toString();
                NetworkHandlerServer.sendLongPacket(player, PacketNames.fromName(PacketNames.LIMITED_LIFE_TIMER.getName() + livesColor), playerLives);
                continue;
            }
            class_5250 fullMessage = class_2561.method_43473();
            if (Main.currentSession.displayTimer.contains(player.method_5667())) {
                fullMessage.method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1080));
            }
            if (player.ls$hasAssignedLives()) {
                if (!fullMessage.getString().isEmpty()) {
                    fullMessage.method_10852(class_2561.method_30163((String)"  |  "));
                }
                fullMessage.method_10852(this.livesManager.getFormattedLives(player));
            }
            player.method_7353((class_2561)fullMessage, true);
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        if (!Main.currentSession.statusStarted()) {
            return;
        }
        --this.secondCounter;
        if (this.secondCounter <= 0) {
            this.secondCounter = 20;
            this.livesManager.getAlivePlayers().forEach(IServerPlayer::ls$removeLife);
            if (TICK_OFFLINE_PLAYERS) {
                Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
                for (class_9011 entry : entries) {
                    if (entry.comp_2128() <= 0 || PlayerUtils.getPlayer(entry.comp_2127()) != null) continue;
                    ScoreboardUtils.setScore(class_9015.method_55422((String)entry.comp_2127()), "Lives", entry.comp_2128() - 1);
                }
            }
        }
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        class_1297 class_12972;
        SessionTranscript.onPlayerDeath(player, source);
        if (source != null && (class_12972 = source.method_5529()) instanceof class_3222) {
            class_3222 serverAttacker = (class_3222)class_12972;
            if (player != source.method_5529()) {
                this.onPlayerKilledByPlayer(player, serverAttacker);
                return;
            }
        }
        if (player.method_6124() != null && (class_12972 = player.method_6124()) instanceof class_3222) {
            class_3222 serverAdversary = (class_3222)class_12972;
            if (player != player.method_6124()) {
                this.onPlayerKilledByPlayer(player, serverAdversary);
                return;
            }
        }
        this.onPlayerDiedNaturally(player);
        if (this.livesManager.canChangeLivesNaturally(player)) {
            player.ls$addLives(DEATH_NORMAL);
            if (player.ls$isAlive()) {
                PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)OtherUtils.formatSecondsToReadable(DEATH_NORMAL)).method_27692(class_124.field_1061), 20, 80, 20);
            }
        }
    }

    @Override
    public void onClaimKill(class_3222 killer, class_3222 victim) {
        boolean wasAllowedToAttack = this.isAllowedToAttack(killer, victim, false);
        boolean wasBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        super.onClaimKill(killer, victim);
        if (!wasBoogeyCure) {
            if (wasAllowedToAttack && this.livesManager.canChangeLivesNaturally()) {
                killer.ls$addLives(this.KILL_NORMAL);
                PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)OtherUtils.formatSecondsToReadable(this.KILL_NORMAL)).method_27692(class_124.field_1060), 20, 80, 20);
            }
        } else if (this.livesManager.canChangeLivesNaturally()) {
            boolean wasAlive = false;
            String msgVictim = OtherUtils.formatSecondsToReadable(this.DEATH_BOOGEYMAN - DEATH_NORMAL);
            String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_BOOGEYMAN);
            if (victim.ls$isAlive()) {
                victim.ls$addLives(this.DEATH_BOOGEYMAN - DEATH_NORMAL);
                wasAlive = true;
            }
            killer.ls$addLives(this.KILL_BOOGEYMAN);
            if (victim.ls$isAlive()) {
                PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
                PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
            } else if (wasAlive && this.SHOW_DEATH_TITLE) {
                PlayerUtils.sendTitleWithSubtitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), this.livesManager.getDeathMessage(victim), 20, 80, 20);
            } else {
                PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
            }
        }
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        boolean wasAllowedToAttack = this.isAllowedToAttack(killer, victim, false);
        boolean wasBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        super.onPlayerKilledByPlayer(victim, killer);
        if (!wasBoogeyCure && this.livesManager.canChangeLivesNaturally()) {
            boolean wasFinalKill;
            boolean bl = wasFinalKill = victim.ls$isAlive() || !this.SHOW_DEATH_TITLE;
            if (wasAllowedToAttack) {
                String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_NORMAL);
                killer.ls$addLives(this.KILL_NORMAL);
                if (wasFinalKill) {
                    PlayerUtils.sendTitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
                } else {
                    PlayerUtils.sendTitleWithSubtitle(killer, (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), this.livesManager.getDeathMessage(victim), 20, 80, 20);
                }
            }
            String msgVictim = OtherUtils.formatSecondsToReadable(DEATH_NORMAL);
            victim.ls$addLives(DEATH_NORMAL);
            if (wasFinalKill) {
                PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
            }
        } else if (this.livesManager.canChangeLivesNaturally()) {
            String msgVictim = OtherUtils.formatSecondsToReadable(this.DEATH_BOOGEYMAN);
            String msgKiller = OtherUtils.formatSecondsToReadable(this.KILL_BOOGEYMAN);
            victim.ls$addLives(this.DEATH_BOOGEYMAN);
            killer.ls$addLives(this.KILL_BOOGEYMAN);
            if (victim.ls$isAlive() || !this.SHOW_DEATH_TITLE) {
                PlayerUtils.sendTitle(victim, (class_2561)class_2561.method_43470((String)msgVictim).method_27692(class_124.field_1061), 20, 80, 20);
                PlayerUtils.sendTitleWithSubtitle(killer, class_2561.method_30163((String)"\u00a7aYou are cured!"), (class_2561)class_2561.method_43470((String)msgKiller).method_27692(class_124.field_1060), 20, 80, 20);
            } else {
                PlayerUtils.sendTitleWithSubtitle(killer, class_2561.method_30163((String)("\u00a7aYou are cured, " + msgKiller)), this.livesManager.getDeathMessage(victim), 20, 80, 20);
            }
        }
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim, boolean allowSelfDefense) {
        if (attacker.ls$isOnSpecificLives(2, false) && victim.ls$isOnAtLeastLives(3, false)) {
            return true;
        }
        return super.isAllowedToAttack(attacker, victim, allowSelfDefense);
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof LimitedLifeConfig)) {
            return;
        }
        LimitedLifeConfig config = (LimitedLifeConfig)configManager;
        LimitedLifeLivesManager.DEFAULT_TIME = LimitedLifeConfig.TIME_DEFAULT.get(config);
        LimitedLifeLivesManager.YELLOW_TIME = LimitedLifeConfig.TIME_YELLOW.get(config);
        LimitedLifeLivesManager.RED_TIME = LimitedLifeConfig.TIME_RED.get(config);
        DEATH_NORMAL = LimitedLifeConfig.TIME_DEATH.get(config);
        this.DEATH_BOOGEYMAN = LimitedLifeConfig.TIME_DEATH_BOOGEYMAN.get(config);
        this.KILL_NORMAL = LimitedLifeConfig.TIME_KILL.get(config);
        this.KILL_BOOGEYMAN = LimitedLifeConfig.TIME_KILL_BOOGEYMAN.get(config);
        TICK_OFFLINE_PLAYERS = LimitedLifeConfig.TICK_OFFLINE_PLAYERS.get(config);
        LimitedLifeLivesManager.BROADCAST_COLOR_CHANGES = LimitedLifeConfig.BROADCAST_COLOR_CHANGES.get(config);
    }

    @Override
    public Integer getDefaultLives() {
        return LimitedLifeLivesManager.DEFAULT_TIME;
    }

    public static Integer getNextLivesColorLives(Integer currentLives) {
        if (currentLives == null) {
            return null;
        }
        if (currentLives > LimitedLifeLivesManager.DEFAULT_TIME) {
            return LimitedLifeLivesManager.DEFAULT_TIME;
        }
        if (currentLives > LimitedLifeLivesManager.YELLOW_TIME) {
            return LimitedLifeLivesManager.YELLOW_TIME;
        }
        if (currentLives > LimitedLifeLivesManager.RED_TIME) {
            return LimitedLifeLivesManager.RED_TIME;
        }
        return 0;
    }
}

