/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9011;

public class LivesCommand {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.LIMITED_LIFE && Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    public static boolean checkBanned(class_2168 source) {
        if (LivesCommand.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is not available during Limited Life. Use '/limitedlife time' instead."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lives").executes(context -> LivesCommand.showLives((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LivesCommand.reloadLives((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), 1, false))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -1, false))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LivesCommand.lifeManager((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> LivesCommand.getLivesFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).then(class_2170.method_9247((String)"*").executes(context -> LivesCommand.getAllLives((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> LivesCommand.resetLives((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetAll").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).executes(context -> LivesCommand.resetAllLives((class_2168)context.getSource()))));
    }

    public static int showLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!Main.currentSeason.hasAssignedLives(self)) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"You have not been assigned any lives yet"));
            return 1;
        }
        Integer playerLives = Main.currentSeason.getPlayerLives(self);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("You have {} {}", Main.currentSeason.getFormattedLives(playerLives), TextUtils.pluralize("life", "lives", playerLives)));
        if (playerLives == null || playerLives <= 0) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"Womp womp."));
        }
        return 1;
    }

    public static int getAllLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (!ScoreboardUtils.existsObjective("Lives")) {
            source.method_9213(class_2561.method_30163((String)"Nobody has been assigned lives yet"));
            return -1;
        }
        Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
        if (entries.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"Nobody has been assigned lives yet"));
            return -1;
        }
        class_5250 text = class_2561.method_43470((String)"Assigned Lives: \n");
        for (class_9011 entry : entries) {
            String name = entry.comp_2127();
            if (name.startsWith("`")) continue;
            int lives = entry.comp_2128();
            class_124 color = Main.currentSeason.getColorForLives(lives);
            text.method_10852((class_2561)TextUtils.format("{} has {} {}\n", class_2561.method_43470((String)name).method_27692(color), Main.currentSeason.getFormattedLives(lives), TextUtils.pluralize("life", "lives", lives)));
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)text);
        return 1;
    }

    public static int getLivesFor(class_2168 source, class_3222 target) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!Main.currentSeason.hasAssignedLives(target)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} has not been assigned any lives", target));
            return -1;
        }
        Integer lives = Main.currentSeason.getPlayerLives(target);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{} has {} {}", target, Main.currentSeason.getFormattedLives(lives), TextUtils.pluralize("life", "lives", lives)));
        return 1;
    }

    public static int reloadLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Reloading lives..."));
        Main.currentSeason.reloadAllPlayerTeams();
        return 1;
    }

    public static int lifeManager(class_2168 source, Collection<class_3222> targets, int amount, boolean setNotGive) {
        Object object;
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (setNotGive) {
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s lives to {}", targets.iterator().next(), Main.currentSeason.getFormattedLives(amount)));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set lives to {} for {} targets", Main.currentSeason.getFormattedLives(amount), targets.size()));
            }
            for (class_3222 player : targets) {
                Main.currentSeason.setPlayerLives(player, amount);
            }
        } else {
            String toOrFrom;
            String addOrRemove = amount >= 0 ? "Added" : "Removed";
            String lifeOrLives = Math.abs(amount) == 1 ? "life" : "lives";
            String string = toOrFrom = amount >= 0 ? "to" : "from";
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} {}", addOrRemove, Math.abs(amount), lifeOrLives, toOrFrom, targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} {} {} {} {} targets", addOrRemove, Math.abs(amount), lifeOrLives, toOrFrom, targets.size()));
            }
            for (class_3222 player : targets) {
                Main.currentSeason.addToPlayerLives(player, amount);
            }
        }
        if ((object = Main.currentSeason) instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)object;
            for (class_3222 player : targets) {
                doubleLife.syncSoulboundLives(player);
            }
        }
        return 1;
    }

    public static int resetLives(class_2168 source, Collection<class_3222> targets) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            Main.currentSeason.resetPlayerLife(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s lives", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset lives of {} targets", targets.size()));
        }
        return 1;
    }

    public static int resetAllLives(class_2168 source) {
        if (LivesCommand.checkBanned(source)) {
            return -1;
        }
        Main.currentSeason.resetAllPlayerLives();
        OtherUtils.sendCommandFeedback(source, (class_2561)class_2561.method_43470((String)"Reset everyone's lives"));
        return 1;
    }
}

