/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards;

import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.MobSwap;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;

public enum Wildcards {
    NULL,
    SIZE_SHIFTING,
    HUNGER,
    SNAILS,
    TIME_DILATION,
    TRIVIA,
    MOB_SWAP,
    SUPERPOWERS,
    CALLBACK;


    public static Wildcards getFromString(String wildcard) {
        try {
            return Enum.valueOf(Wildcards.class, wildcard.toUpperCase());
        }
        catch (Exception exception) {
            return NULL;
        }
    }

    public static Wildcard getInstance(Wildcards wildcard) {
        if (wildcard == SIZE_SHIFTING) {
            return new SizeShifting();
        }
        if (wildcard == HUNGER) {
            return new Hunger();
        }
        if (wildcard == SNAILS) {
            return new Snails();
        }
        if (wildcard == TIME_DILATION) {
            return new TimeDilation();
        }
        if (wildcard == TRIVIA) {
            return new TriviaWildcard();
        }
        if (wildcard == MOB_SWAP) {
            return new MobSwap();
        }
        if (wildcard == SUPERPOWERS) {
            return new SuperpowersWildcard();
        }
        if (wildcard == CALLBACK) {
            return new Callback();
        }
        return null;
    }

    public static List<Wildcards> getWildcards() {
        return List.of(SIZE_SHIFTING, HUNGER, SNAILS, TIME_DILATION, TRIVIA, MOB_SWAP, SUPERPOWERS, CALLBACK);
    }

    public static List<String> getWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getWildcards()) {
            String name = Wildcards.getStringName(wildcard);
            result.add(name);
        }
        return result;
    }

    public static String getStringName(Wildcards wildcard) {
        return wildcard.toString().toLowerCase();
    }

    public static List<Wildcards> getActiveWildcards() {
        return new ArrayList<Wildcards>(WildcardManager.activeWildcards.keySet());
    }

    public static List<Wildcards> getInactiveWildcards() {
        ArrayList<Wildcards> result = new ArrayList<Wildcards>(Wildcards.getWildcards());
        result.removeAll(Wildcards.getActiveWildcards());
        return result;
    }

    public static List<String> getInactiveWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getInactiveWildcards()) {
            String name = Wildcards.getStringName(wildcard);
            result.add(name);
        }
        return result;
    }

    public static List<String> getActiveWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getActiveWildcards()) {
            String name = Wildcards.getStringName(wildcard);
            result.add(name);
        }
        return result;
    }
}

