/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Mimicry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class SuperpowersWildcard
extends Wildcard {
    private static final Map<UUID, Superpower> playerSuperpowers = new HashMap<UUID, Superpower>();
    public static final Map<UUID, Superpowers> assignedSuperpowers = new HashMap<UUID, Superpowers>();

    @Override
    public Wildcards getType() {
        return Wildcards.SUPERPOWERS;
    }

    @Override
    public void activate() {
        SuperpowersWildcard.rollRandomSuperpowers();
        super.activate();
    }

    @Override
    public void deactivate() {
        SuperpowersWildcard.resetAllSuperpowers();
        super.deactivate();
    }

    public static void onTick() {
        playerSuperpowers.values().forEach(Superpower::tick);
    }

    public static void resetSuperpower(class_3222 player) {
        UUID uuid = player.method_5667();
        if (!playerSuperpowers.containsKey(uuid)) {
            return;
        }
        playerSuperpowers.get(uuid).turnOff();
        playerSuperpowers.remove(uuid);
    }

    public static void resetAllSuperpowers() {
        playerSuperpowers.values().forEach(Superpower::turnOff);
        playerSuperpowers.clear();
    }

    public static void rollRandomSuperpowers() {
        SuperpowersWildcard.resetAllSuperpowers();
        ArrayList<Superpowers> implemented = new ArrayList<Superpowers>(Superpowers.getImplemented());
        boolean shouldIncludeNecromancy = implemented.contains((Object)Superpowers.NECROMANCY) && Necromancy.shouldBeIncluded();
        boolean shouldRandomizeNecromancy = false;
        double necromancyRandomizeChance = 0.0;
        if (shouldIncludeNecromancy) {
            int deadPlayersNum;
            int alivePlayersNum = Main.currentSeason.getAlivePlayers().size();
            int totalPlayersNum = alivePlayersNum + (deadPlayersNum = Necromancy.getDeadPlayers().size());
            if (totalPlayersNum >= 6) {
                implemented.remove((Object)Superpowers.NECROMANCY);
                shouldRandomizeNecromancy = true;
                necromancyRandomizeChance = (double)deadPlayersNum / (double)alivePlayersNum;
            }
        } else {
            implemented.remove((Object)Superpowers.NECROMANCY);
        }
        Collections.shuffle(implemented);
        int pos = 0;
        List<class_3222> allPlayers = Main.currentSeason.getAlivePlayers();
        Collections.shuffle(allPlayers);
        for (class_3222 player : allPlayers) {
            Superpower instance;
            Superpowers power = (Superpowers)((Object)implemented.get(pos % implemented.size()));
            if (assignedSuperpowers.containsKey(player.method_5667())) {
                power = assignedSuperpowers.get(player.method_5667());
                assignedSuperpowers.remove(player.method_5667());
            } else if (shouldIncludeNecromancy && shouldRandomizeNecromancy && player.method_59922().method_43058() <= necromancyRandomizeChance) {
                power = Superpowers.NECROMANCY;
            }
            if (power == Superpowers.NECROMANCY) {
                implemented.remove((Object)Superpowers.NECROMANCY);
                shouldIncludeNecromancy = false;
            }
            if ((instance = Superpowers.getInstance(player, power)) != null) {
                playerSuperpowers.put(player.method_5667(), instance);
            }
            ++pos;
        }
        PlayerUtils.playSoundToPlayers(allPlayers, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"wildlife_superpowers")), 0.2f, 1.0f);
    }

    public static void rollRandomSuperpowerForPlayer(class_3222 player) {
        Superpower instance;
        ArrayList<Superpowers> implemented = new ArrayList<Superpowers>(Superpowers.getImplemented());
        implemented.remove((Object)Superpowers.NECROMANCY);
        Collections.shuffle(implemented);
        Superpowers power = (Superpowers)((Object)implemented.getFirst());
        if (assignedSuperpowers.containsKey(player.method_5667())) {
            power = assignedSuperpowers.get(player.method_5667());
            assignedSuperpowers.remove(player.method_5667());
        }
        if ((instance = Superpowers.getInstance(player, power)) != null) {
            playerSuperpowers.put(player.method_5667(), instance);
        }
        PlayerUtils.playSoundToPlayers(List.of(player), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"wildlife_superpowers")), 0.2f, 1.0f);
    }

    public static void setSuperpower(class_3222 player, Superpowers superpower) {
        Superpower instance;
        if (playerSuperpowers.containsKey(player.method_5667())) {
            playerSuperpowers.get(player.method_5667()).turnOff();
        }
        if ((instance = Superpowers.getInstance(player, superpower)) != null) {
            playerSuperpowers.put(player.method_5667(), instance);
        }
        PlayerUtils.playSoundToPlayers(List.of(player), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"wildlife_superpowers")), 0.2f, 1.0f);
    }

    public static void pressedSuperpowerKey(class_3222 player) {
        if (playerSuperpowers.containsKey(player.method_5667())) {
            if (Main.currentSeason.isAlive(player)) {
                playerSuperpowers.get(player.method_5667()).onKeyPressed();
            } else {
                PlayerUtils.displayMessageToPlayer(player, (class_2561)class_2561.method_43470((String)"Dead players can't use superpowers!"), 60);
            }
        }
    }

    public static boolean hasPower(class_3222 player) {
        return playerSuperpowers.containsKey(player.method_5667());
    }

    public static boolean hasActivePower(class_3222 player, Superpowers superpower) {
        if (!playerSuperpowers.containsKey(player.method_5667())) {
            return false;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            if (superpower != Superpowers.MIMICRY) {
                return mimicry.getMimickedPower().getSuperpower() == superpower;
            }
        }
        return power.getSuperpower() == superpower;
    }

    public static boolean hasActivatedPower(class_3222 player, Superpowers superpower) {
        if (!SuperpowersWildcard.hasActivePower(player, superpower)) {
            return false;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            if (superpower != Superpowers.MIMICRY) {
                return mimicry.getMimickedPower().active;
            }
        }
        return power.active;
    }

    public static Superpowers getSuperpower(class_3222 player) {
        if (playerSuperpowers.containsKey(player.method_5667())) {
            Superpower power = playerSuperpowers.get(player.method_5667());
            if (power instanceof Mimicry) {
                Mimicry mimicry = (Mimicry)power;
                return mimicry.getMimickedPower().getSuperpower();
            }
            return power.getSuperpower();
        }
        return Superpowers.NONE;
    }

    @Nullable
    public static Superpower getSuperpowerInstance(class_3222 player) {
        if (!playerSuperpowers.containsKey(player.method_5667())) {
            return null;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            return mimicry.getMimickedPower();
        }
        return power;
    }
}

