/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class Session {
    public Map<UUID, Integer> playerNaturalDeathLog = new HashMap<UUID, Integer>();
    private List<SessionAction> activeActions = new ArrayList<SessionAction>();
    public List<UUID> displayTimer = new ArrayList<UUID>();
    public static final int NATURAL_DEATH_LOG_MAX = 2400;
    public static final int DISPLAY_TIMER_INTERVAL = 5;
    public static final int TAB_LIST_INTERVAL = 20;
    public long currentTimer = 0L;
    public Integer sessionLength = null;
    public double passedTime = 0.0;
    private SessionStatus status = SessionStatus.NOT_STARTED;
    SessionAction endWarning1 = new SessionAction(this, OtherUtils.minutesToTicks(-5)){

        @Override
        public void trigger() {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"Session ends in 5 minutes!").method_27692(class_124.field_1065));
        }
    };
    SessionAction endWarning2 = new SessionAction(this, OtherUtils.minutesToTicks(-30)){

        @Override
        public void trigger() {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"Session ends in 30 minutes!").method_27692(class_124.field_1065));
        }
    };
    SessionAction actionInfoAction = new SessionAction(OtherUtils.secondsToTicks(7)){

        @Override
        public void trigger() {
            Session.this.showActionInfo();
        }
    };
    private Map<UUID, class_243> lastNonBorderPositions = new HashMap<UUID, class_243>();
    public static final Map<UUID, Integer> skipTimer = new HashMap<UUID, Integer>();

    public boolean sessionStart() {
        if (!this.canStartSession()) {
            return false;
        }
        this.clearSessionActions();
        if (!Main.currentSeason.sessionStart()) {
            return false;
        }
        this.changeStatus(SessionStatus.STARTED);
        this.passedTime = 0.0;
        class_5250 line1 = TextUtils.formatLoosely("\u00a76Session started! \u00a77[{}]", OtherUtils.formatTime(this.sessionLength));
        class_5250 line2 = class_2561.method_43470((String)"\u00a7f/session timer showDisplay\u00a77 - toggles a session timer on your screen.");
        PlayerUtils.broadcastMessage((class_2561)line1);
        PlayerUtils.broadcastMessage((class_2561)line2);
        this.addSessionActionIfTime(this.endWarning1);
        this.addSessionActionIfTime(this.endWarning2);
        this.addSessionAction(this.actionInfoAction);
        SessionTranscript.sessionStart();
        SessionTranscript.logPlayers();
        return true;
    }

    public void clearSessionActions() {
        this.activeActions.clear();
    }

    public List<SessionAction> getSessionActions() {
        return this.activeActions;
    }

    public void addSessionAction(SessionAction action) {
        this.activeActions.add(action);
    }

    public void addSessionActionIfTime(SessionAction action) {
        if (action.shouldTrigger()) {
            return;
        }
        this.addSessionAction(action);
    }

    public void sessionEnd() {
        SessionTranscript.sessionEnd();
        if (this.status != SessionStatus.FINISHED && this.status != SessionStatus.NOT_STARTED) {
            SessionTranscript.onSessionEnd();
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"The session has ended!").method_27692(class_124.field_1065));
        }
        this.changeStatus(SessionStatus.FINISHED);
        this.passedTime = 0.0;
        Main.currentSeason.sessionEnd();
    }

    public void sessionPause() {
        if (this.statusPaused()) {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"Session unpaused!").method_27692(class_124.field_1065));
            this.changeStatus(SessionStatus.STARTED);
        } else {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"Session paused!").method_27692(class_124.field_1065));
            this.changeStatus(SessionStatus.PAUSED);
        }
    }

    public boolean canStartSession() {
        if (!this.validTime()) {
            return false;
        }
        if (this.statusStarted()) {
            return false;
        }
        return !this.statusPaused();
    }

    public void setSessionLength(int lengthTicks) {
        this.sessionLength = lengthTicks;
        Main.getMainConfig().setProperty("session_length", String.valueOf(this.sessionLength));
    }

    public void addSessionLength(int lengthTicks) {
        if (this.sessionLength == null) {
            this.sessionLength = 0;
        }
        this.setSessionLength(this.sessionLength + lengthTicks);
    }

    public void removeSessionLength(int lengthTicks) {
        if (this.sessionLength == null) {
            this.sessionLength = 0;
        }
        this.setSessionLength(this.sessionLength - lengthTicks);
    }

    public String getSessionLength() {
        if (this.sessionLength == null) {
            return "";
        }
        return OtherUtils.formatTime(this.sessionLength);
    }

    public String getPassedTimeStr() {
        return OtherUtils.formatTime(this.getPassedTime());
    }

    public String getRemainingTimeStr() {
        if (this.sessionLength == null) {
            return "";
        }
        return OtherUtils.formatTime(this.getRemainingTime());
    }

    public int getPassedTime() {
        return (int)this.passedTime;
    }

    public int getRemainingTime() {
        return this.sessionLength - this.getPassedTime();
    }

    public boolean validTime() {
        return this.sessionLength != null;
    }

    public boolean isInDisplayTimer(class_3222 player) {
        return this.displayTimer.contains(player.method_5667());
    }

    public void addToDisplayTimer(class_3222 player) {
        this.displayTimer.add(player.method_5667());
    }

    public void removeFromDisplayTimer(class_3222 player) {
        if (!this.displayTimer.contains(player.method_5667())) {
            return;
        }
        this.displayTimer.remove(player.method_5667());
    }

    public void tick(MinecraftServer server) {
        ++this.currentTimer;
        if (this.currentTimer % 5L == 0L) {
            this.displayTimers(server);
            for (class_3222 class_32222 : PlayerUtils.getAllPlayers()) {
                NetworkHandlerServer.sendStringPacket(class_32222, PacketNames.SESSION_STATUS, this.status.getName());
            }
            for (class_6880 class_68802 : Main.blacklist.getBannedEffects()) {
                for (class_3222 class_32223 : PlayerUtils.getAllPlayers()) {
                    class_1293 actualEffect;
                    if (!class_32223.method_6059(class_68802) || (actualEffect = class_32223.method_6112(class_68802)) != null && !actualEffect.method_5591() && !actualEffect.method_5592() && !actualEffect.method_5581()) continue;
                    class_32223.method_6016(class_68802);
                }
            }
        }
        if (this.currentTimer % 20L == 0L) {
            Events.updatePlayerListsNextTick = true;
        }
        if (this.playerNaturalDeathLog != null && !this.playerNaturalDeathLog.isEmpty()) {
            int currentTime = server.method_3780();
            ArrayList<UUID> arrayList = new ArrayList<UUID>();
            for (Map.Entry entry : this.playerNaturalDeathLog.entrySet()) {
                int tickDiff = currentTime - (Integer)entry.getValue();
                if (tickDiff < 2400) continue;
                arrayList.add((UUID)entry.getKey());
            }
            if (!arrayList.isEmpty()) {
                arrayList.forEach(this.playerNaturalDeathLog::remove);
            }
        }
        for (class_3222 class_32224 : PlayerUtils.getAllPlayers()) {
            if (class_32224.method_7325()) continue;
            this.checkPlayerPosition(class_32224);
        }
        if (!this.validTime()) {
            return;
        }
        if (!this.statusStarted()) {
            return;
        }
        this.tickSessionOn(server);
        Main.currentSeason.tickSessionOn(server);
    }

    public void tickSessionOn(MinecraftServer server) {
        float tickRate = server.method_54833().method_54748();
        this.passedTime = tickRate == 20.0f ? (this.passedTime += 1.0) : (this.passedTime += (double)(20.0f / tickRate));
        if (this.passedTime >= (double)this.sessionLength.intValue()) {
            this.sessionEnd();
        }
        if (this.activeActions == null) {
            return;
        }
        if (this.activeActions.isEmpty()) {
            return;
        }
        ArrayList<SessionAction> remaining = new ArrayList<SessionAction>();
        for (SessionAction action : this.activeActions) {
            boolean triggered = action.tick();
            if (triggered) continue;
            remaining.add(action);
        }
        this.activeActions = remaining;
    }

    public void checkPlayerPosition(class_3222 player) {
        class_2784 border = player.ls$getServerLevel().method_8621();
        double playerSize = player.method_5829().method_17939() / 2.0;
        double minX = Math.floor(border.method_11976()) + playerSize;
        double maxX = Math.ceil(border.method_11963()) - playerSize;
        double minZ = Math.floor(border.method_11958()) + playerSize;
        double maxZ = Math.ceil(border.method_11977()) - playerSize;
        double playerX = player.method_23317();
        double playerZ = player.method_23321();
        UUID uuid = player.method_5667();
        if (playerX < minX || playerX > maxX || playerZ < minZ || playerZ > maxZ) {
            if (this.lastNonBorderPositions.containsKey(uuid)) {
                class_243 pos = this.lastNonBorderPositions.get(uuid);
                if (!(pos.field_1352 < minX || pos.field_1352 > maxX || pos.field_1350 < minZ || pos.field_1350 > maxZ)) {
                    PlayerUtils.teleport(player, pos);
                    return;
                }
            }
            double clampedX = Math.clamp(playerX, minX, maxX);
            double clampedZ = Math.clamp(playerZ, minZ, maxZ);
            PlayerUtils.teleport(player, clampedX, player.method_23318(), clampedZ);
        } else {
            this.lastNonBorderPositions.put(uuid, player.method_19538());
        }
    }

    public void displayTimers(MinecraftServer server) {
        Season season = Main.currentSeason;
        if (season instanceof LimitedLife) {
            LimitedLife limitedLife = (LimitedLife)season;
            limitedLife.displayTimers(server);
            return;
        }
        String message = "";
        if (this.statusNotStarted()) {
            message = "Session has not started";
        } else if (this.statusStarted()) {
            message = this.getRemainingTimeStr();
        } else if (this.statusPaused()) {
            message = "Session has been paused";
        } else if (this.statusFinished()) {
            message = "Session has ended";
        }
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            UUID uuid = player.method_5667();
            if (this.displayTimer.contains(player.method_5667())) {
                if (skipTimer.containsKey(uuid)) {
                    int value = skipTimer.get(uuid);
                    if (--value > 0) {
                        skipTimer.put(uuid, value);
                        continue;
                    }
                    skipTimer.remove(uuid);
                    continue;
                }
                if (!NetworkHandlerServer.wasHandshakeSuccessful(player)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1080), true);
                }
            }
            if (!NetworkHandlerServer.wasHandshakeSuccessful(player)) continue;
            long timestamp = SessionTimerStates.OFF.getValue();
            if (this.statusNotStarted()) {
                timestamp = SessionTimerStates.NOT_STARTED.getValue();
            } else if (this.statusPaused()) {
                timestamp = SessionTimerStates.PAUSED.getValue();
            } else if (this.statusFinished()) {
                timestamp = SessionTimerStates.ENDED.getValue();
            } else if (this.sessionLength != null) {
                long remainingMillis = (this.sessionLength - (int)this.passedTime) * 50;
                timestamp = System.currentTimeMillis() + remainingMillis;
            }
            if (timestamp == (long)SessionTimerStates.OFF.getValue()) continue;
            NetworkHandlerServer.sendLongPacket(player, PacketNames.SESSION_TIMER, timestamp);
        }
    }

    public void showActionInfo() {
        if (this.getSessionActions().isEmpty()) {
            return;
        }
        ArrayList<SessionAction> actions = new ArrayList<SessionAction>(this.getSessionActions());
        actions.sort(Comparator.comparingInt(SessionAction::getTriggerTime));
        ArrayList<class_2561> messages = new ArrayList<class_2561>();
        for (SessionAction action : actions) {
            String actionMessage = action.sessionMessage;
            if (actionMessage == null || actionMessage.isEmpty()) continue;
            if (messages.isEmpty()) {
                messages.add(class_2561.method_30163((String)"\u00a77Queued session actions:"));
            }
            messages.add(class_2561.method_30163((String)("\u00a77- " + actionMessage)));
        }
        messages.forEach(PlayerUtils::broadcastMessageToAdmins);
    }

    public boolean statusStarted() {
        return this.status == SessionStatus.STARTED;
    }

    public boolean statusPaused() {
        return this.status == SessionStatus.PAUSED;
    }

    public boolean statusFinished() {
        return this.status == SessionStatus.FINISHED;
    }

    public boolean statusNotStarted() {
        return this.status == SessionStatus.NOT_STARTED;
    }

    public void changeStatus(SessionStatus newStatus) {
        this.status = newStatus;
        Main.currentSeason.sessionChangeStatus(this.status);
    }
}

