/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.utils.enums.Direction;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2781;
import net.minecraft.class_310;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9812;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientUtils {
    public static boolean shouldPreventGliding() {
        if (!MainClient.preventGliding) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        if (client.field_1724 == null) {
            return false;
        }
        if (class_1309.method_63624((class_1799)client.field_1724.method_6118(class_1304.field_6174), (class_1304)class_1304.field_6174) || class_1309.method_63624((class_1799)client.field_1724.method_6118(class_1304.field_6172), (class_1304)class_1304.field_6172) || class_1309.method_63624((class_1799)client.field_1724.method_6118(class_1304.field_6166), (class_1304)class_1304.field_6166)) {
            return false;
        }
        class_1799 helmet = PlayerUtils.getEquipmentSlot((class_1657)client.field_1724, 3);
        return ItemStackUtils.hasCustomComponentEntry(helmet, "FlightSuperpower");
    }

    @Nullable
    public static class_1657 getPlayer(UUID uuid) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return null;
        }
        if (client.field_1687 == null) {
            return null;
        }
        return client.field_1687.method_18470(uuid);
    }

    @Nullable
    public static class_268 getPlayerTeam() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return null;
        }
        if (client.field_1724 == null) {
            return null;
        }
        return client.field_1724.method_5781();
    }

    public static void runCommand(String command) {
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        handler.method_45730(command);
    }

    public static void disconnect(class_2561 reason) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_634 handler = client.method_1562();
        if (handler == null) {
            return;
        }
        client.field_1687.method_8525();
        handler.method_10839(new class_9812(reason));
    }

    public static boolean handleUpdatedAttribute(class_638 level, class_1324 instance, double baseValue, class_2781 packet) {
        class_1297 entity = level.method_8469(packet.method_11937());
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof class_746)) {
            return false;
        }
        class_746 player = (class_746)entity;
        if (!MainClient.isClientPlayer(player.method_5667())) {
            return false;
        }
        class_6880 scaleAttribute = class_5134.field_47760;
        if (instance.method_6198() != scaleAttribute) {
            return false;
        }
        if (MainClient.clientCurrentSeason != Seasons.WILD_LIFE) {
            return false;
        }
        if (!MainClient.clientActiveWildcards.contains((Object)Wildcards.SIZE_SHIFTING)) {
            return false;
        }
        if (!MainClient.FIX_SIZECHANGING_BUGS) {
            return false;
        }
        double oldBaseValue = player.method_45326(scaleAttribute);
        if (oldBaseValue == baseValue) {
            return false;
        }
        class_4048 oldEntityDimensions = player.method_55694(player.method_18376()).method_18383((float)oldBaseValue);
        class_238 oldBoundingBox = oldEntityDimensions.method_30757(player.method_19538());
        double oldHitboxSize = oldEntityDimensions.comp_2185();
        class_4048 newEntityDimensions = player.method_55694(player.method_18376()).method_18383((float)baseValue);
        class_238 newBoundingBox = newEntityDimensions.method_30757(player.method_19538());
        double newHitboxSize = newEntityDimensions.comp_2185();
        double changedBy = newHitboxSize - oldHitboxSize;
        class_243 move = null;
        if (changedBy < 0.0) {
            boolean oldSpaceBelowEmpty = ClientUtils.isSpaceEmpty(player, oldBoundingBox, 0.0, -1.0E-5, 0.0);
            boolean newSpaceBelowEmpty = ClientUtils.isSpaceEmpty(player, newBoundingBox, 0.0, -1.0E-5, 0.0);
            if (!oldSpaceBelowEmpty && newSpaceBelowEmpty) {
                move = ClientUtils.findDesiredCollission(player, newBoundingBox, changedBy, -1.0E-5, false, false);
            }
        } else {
            boolean oldSpaceEmpty = ClientUtils.isSpaceEmpty(player, oldBoundingBox, 0.0, 1.0E-5, 0.0);
            boolean newSpaceEmpty = ClientUtils.isSpaceEmpty(player, newBoundingBox, 0.0, 1.0E-5, 0.0);
            if (oldSpaceEmpty && !newSpaceEmpty && (move = ClientUtils.findDesiredCollission(player, newBoundingBox, changedBy, 1.0E-5, true, false)) != null) {
                move = move.method_1021(5.0);
            }
            if (!oldSpaceEmpty && !newSpaceEmpty) {
                move = ClientUtils.recursivelyFindDesiredCollission(player, newBoundingBox, 1.0E-5, true);
            }
        }
        if (move != null) {
            if (changedBy > 0.0) {
                class_243 playerVelocity = player.method_18798();
                double speedX = playerVelocity.field_1352;
                double speedZ = playerVelocity.field_1350;
                if (move.field_1352 != 0.0) {
                    speedX = 0.0;
                }
                if (move.field_1350 != 0.0) {
                    speedZ = 0.0;
                }
                player.method_18800(speedX, playerVelocity.field_1351, speedZ);
            }
            player.method_23327(player.method_23317() + move.field_1352, player.method_23318(), player.method_23321() + move.field_1350);
            instance.method_6192(baseValue);
            player.method_18382();
            return true;
        }
        if (changedBy > 0.0) {
            instance.method_6192(baseValue);
            player.method_18382();
            return true;
        }
        return false;
    }

    public static boolean isSpaceEmpty(class_746 player, class_238 box, double offsetX, double offsetY, double offsetZ) {
        if (player.field_5960 || player.method_7325()) {
            return true;
        }
        class_238 newBox = new class_238(box.field_1323 + offsetX, box.field_1322 + offsetY, box.field_1321 + offsetZ, box.field_1320 + offsetX, box.field_1322, box.field_1324 + offsetZ);
        return player.method_37908().method_8587((class_1297)player, newBox);
    }

    public static class_243 recursivelyFindDesiredCollission(class_746 player, class_238 newBoundingBox, double offsetY, boolean desiredSpaceEmpty) {
        for (double changedBy = 0.05; changedBy <= 0.4; changedBy += 0.05) {
            class_243 found = ClientUtils.findDesiredCollission(player, newBoundingBox, changedBy, offsetY, desiredSpaceEmpty, true);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static class_243 findDesiredCollission(class_746 player, class_238 newBoundingBox, double changedBy, double offsetY, boolean desiredSpaceEmpty, boolean onlyCardinal) {
        Direction[] directions;
        for (Direction direction : directions = onlyCardinal ? Direction.getCardinalDirections() : Direction.values()) {
            double offsetX = changedBy * (double)direction.x;
            double offsetZ = changedBy * (double)direction.z;
            boolean movedSpaceEmpty = ClientUtils.isSpaceEmpty(player, newBoundingBox, offsetX, offsetY, offsetZ);
            if (movedSpaceEmpty != desiredSpaceEmpty) continue;
            return new class_243(offsetX, 0.0, offsetZ);
        }
        return null;
    }

    public static class_2561 getPlayerName(class_2561 text) {
        if (text == null || Main.modFullyDisabled()) {
            return text;
        }
        if (class_310.method_1551().method_1562() == null) {
            return text;
        }
        if (MainClient.playerDisguiseNames.containsKey(text.getString())) {
            String name = MainClient.playerDisguiseNames.get(text.getString());
            for (class_640 entry : class_310.method_1551().method_1562().method_2880()) {
                if (!OtherUtils.profileName(entry.method_2966()).equalsIgnoreCase(TextUtils.removeFormattingCodes(name))) continue;
                if (entry.method_2971() != null) {
                    return ClientUtils.applyColorblindToName(entry.method_2971(), entry.method_2955());
                }
                return ClientUtils.applyColorblindToName((class_2561)class_2561.method_43470((String)name), entry.method_2955());
            }
        } else {
            for (class_640 entry : class_310.method_1551().method_1562().method_2880()) {
                if (!OtherUtils.profileName(entry.method_2966()).equalsIgnoreCase(TextUtils.removeFormattingCodes(text.getString()))) continue;
                return ClientUtils.applyColorblindToName(text, entry.method_2955());
            }
        }
        return text;
    }

    public static class_2561 applyColorblindToName(class_2561 original, class_268 team) {
        if (!MainClient.COLORBLIND_SUPPORT) {
            return original;
        }
        if (original == null) {
            return original;
        }
        if (team == null) {
            return original;
        }
        return TextUtils.format("[{}] ", team.method_1140().getString()).method_27692(team.method_1202()).method_10852(original);
    }
}

