/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.ConfigScreen;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.EmptyConfigEntry;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.interfaces.IEntryGroupHeader;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class GroupConfigEntry<T extends ConfigEntry>
extends EmptyConfigEntry {
    private static final int CHILD_INDENT = 20;
    protected static final int EXPAND_TEXT_OFFSET_X = 15;
    protected static final int EXPAND_TEXT_OFFSET_Y = 6;
    private static final int EXPAND_SIDEBAR_THICKNESS = 1;
    private static final int EXPAND_SIDEBAR_OFFSET_X = -9;
    private static final float ANIMATION_OPEN_SPEED = 0.15f;
    private static final float ANIMATION_CLOSE_SPEED = 0.4f;
    private final T mainEntry;
    private final List<ConfigEntry> childEntries;
    private boolean isExpanded = false;
    private boolean showSidebar;
    private boolean renderBottomBar = false;
    private int currentHeight;
    private int y;

    public GroupConfigEntry(T mainEntry, List<ConfigEntry> childEntries, boolean showSidebar, boolean openByDefault) {
        super("", "", "");
        this.mainEntry = mainEntry;
        this.currentHeight = ((ConfigEntry)mainEntry).getPreferredHeight();
        this.childEntries = new ArrayList<ConfigEntry>(childEntries);
        this.showSidebar = showSidebar;
        if (openByDefault) {
            ((IEntryGroupHeader)mainEntry).expand();
        }
        ((ConfigEntry)this.mainEntry).parentGroup = this;
        ((ConfigEntry)this.mainEntry).groupTopology.add(this);
        this.childEntries.forEach(entry -> {
            entry.parentGroup = this;
            entry.groupTopology.add(this);
        });
    }

    @Override
    public void setScreen(ConfigScreen screen) {
        super.setScreen(screen);
        if (this.mainEntry != null) {
            ((ConfigEntry)this.mainEntry).setScreen(screen);
        }
        for (ConfigEntry child : this.childEntries) {
            child.setScreen(screen);
        }
    }

    @Override
    public void render(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.y = y;
        this.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        boolean shouldBeExpanded;
        int maxHeight = this.getMaxHeight();
        if (this.hasExpandingChild()) {
            this.currentHeight = maxHeight;
        } else if ((float)Math.abs(this.currentHeight - maxHeight) > 1.5f) {
            float animationSpeed = this.currentHeight < maxHeight ? 0.15f : 0.4f;
            float change = (float)(maxHeight - this.currentHeight) * animationSpeed * tickDelta;
            if (Math.abs(change) < animationSpeed * 10.0f) {
                change *= animationSpeed * 10.0f / Math.abs(change);
            }
            this.currentHeight += (int)change;
        } else {
            this.currentHeight = maxHeight;
        }
        int currentY = y;
        if (this.mainEntry != null && this.screen != null) {
            int entryHeight = ((ConfigEntry)this.mainEntry).getPreferredHeight();
            boolean entryHovered = mouseX >= x && mouseX < x + width && mouseY >= currentY && mouseY < currentY + entryHeight;
            ((ConfigEntry)this.mainEntry).render(context, x, y, width, entryHeight, mouseX, mouseY, entryHovered, tickDelta);
            currentY += entryHeight + 2;
            String expandText = !((IEntryGroupHeader)this.mainEntry).shouldExpand() ? "Click to expand" : "Click to collapse";
            RenderUtils.drawTextRight(context, this.textRenderer, TextColors.LIGHT_GRAY_A128, class_2561.method_30163((String)expandText), ((IEntryGroupHeader)this.mainEntry).expandTextX(x, width), y + 6);
        }
        if ((shouldBeExpanded = this.shouldExpand()) != this.isExpanded) {
            this.isExpanded = shouldBeExpanded;
        }
        if (this.isExpanded) {
            for (ConfigEntry child : this.childEntries) {
                int entryHeight = child.getPreferredHeight();
                if (currentY + entryHeight + 2 - 10 <= y + this.currentHeight) {
                    boolean entryHovered = mouseX >= x && mouseX < x + width && mouseY >= currentY && mouseY < currentY + entryHeight;
                    child.render(context, x + 20, currentY, width - 20, entryHeight, mouseX, mouseY, entryHovered, tickDelta);
                }
                currentY += entryHeight + 2;
            }
        }
        this.renderExpandIcon(context, x, y, this.isExpanded, y + this.currentHeight + 1, width);
    }

    private void renderExpandIcon(class_332 context, int x, int y, boolean expanded, int endY, int width) {
        String text = expanded ? "- " : "+ ";
        RenderUtils.drawTextRight(context, this.textRenderer, TextColors.WHITE, class_2561.method_30163((String)text), x + 15, y + 6);
        if (this.showSidebar) {
            context.method_25294(x + -9, y, x + -9 + 1, endY - 2, TextColors.WHITE_A128);
        }
        if (expanded && this.renderBottomBar) {
            context.method_25294(x + -9, endY - 2, Math.max(x + 25 + 20 + 20, (x + width) / 2), endY - 2 + 1, TextColors.WHITE_A32);
        }
    }

    private boolean shouldExpand() {
        return ((IEntryGroupHeader)this.mainEntry).shouldExpand();
    }

    private boolean hasExpandingChild() {
        for (ConfigEntry child : this.childEntries) {
            GroupConfigEntry groupChild;
            if (!(child instanceof GroupConfigEntry) || !(groupChild = (GroupConfigEntry)child).isAnimating() && !groupChild.hasExpandingChild()) continue;
            return true;
        }
        return false;
    }

    private boolean isAnimating() {
        return (float)Math.abs(this.currentHeight - this.getMaxHeight()) > 1.5f;
    }

    @Override
    protected boolean mouseClickedEntry(class_11909 click, boolean doubled) {
        int mouseX = (int)click.comp_4798();
        int mouseY = (int)click.comp_4799();
        int currentY = mouseY - this.y;
        if (currentY < 0 || this.mainEntry == null) {
            return false;
        }
        if (currentY <= ((ConfigEntry)this.mainEntry).getPreferredHeight()) {
            ((ConfigEntry)this.mainEntry).setFocused(true);
            if (((ConfigEntry)this.mainEntry).mouseClicked(click, doubled)) {
                return true;
            }
        }
        if (this.isExpanded) {
            double childY = ((ConfigEntry)this.mainEntry).getPreferredHeight();
            for (ConfigEntry child : this.childEntries) {
                int childHeight = child.getPreferredHeight() + 2;
                if (childY + (double)childHeight + 2.0 - 10.0 <= (double)(currentY + this.currentHeight) && (double)currentY >= childY && (double)currentY < childY + (double)childHeight) {
                    child.setFocused(true);
                    if (child.mouseClicked(click, doubled)) {
                        return true;
                    }
                }
                childY += (double)childHeight;
            }
        }
        return false;
    }

    @Override
    protected boolean keyPressedEntry(class_11908 input) {
        if (this.mainEntry != null && ((ConfigEntry)this.mainEntry).isFocused() && ((ConfigEntry)this.mainEntry).keyPressed(input)) {
            return true;
        }
        if (this.isExpanded) {
            for (ConfigEntry child : this.childEntries) {
                if (!child.isFocused() || !child.keyPressed(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean charTypedEntry(class_11905 input) {
        if (this.mainEntry != null && ((ConfigEntry)this.mainEntry).isFocused() && ((ConfigEntry)this.mainEntry).charTyped(input)) {
            return true;
        }
        if (this.isExpanded) {
            for (ConfigEntry child : this.childEntries) {
                if (!child.isFocused() || !child.charTyped(input)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPreferredHeight() {
        return this.currentHeight;
    }

    public int getMaxHeight() {
        int height = 20;
        if (this.mainEntry != null) {
            height = ((ConfigEntry)this.mainEntry).getPreferredHeight();
        }
        if (this.isExpanded) {
            for (ConfigEntry child : this.childEntries) {
                height += child.getPreferredHeight() + 2;
            }
        }
        return height;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.GROUP;
    }

    @Override
    public boolean hasError() {
        if (this.mainEntry != null && ((ConfigEntry)this.mainEntry).hasError) {
            return true;
        }
        for (ConfigEntry child : this.childEntries) {
            if (!child.hasError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markChanged() {
        super.markChanged();
        if (this.mainEntry != null) {
            ((ConfigEntry)this.mainEntry).markChanged();
        }
    }

    public void addChildEntry(ConfigEntry entry) {
        entry.parentGroup = this;
        entry.groupTopology.add(this);
        entry.setScreen(this.screen);
        this.childEntries.add(entry);
    }

    public void removeChildEntry(ConfigEntry entry) {
        this.childEntries.remove(entry);
        entry.parentGroup = null;
        entry.groupTopology.remove(this);
    }

    public List<ConfigEntry> getChildEntries() {
        return new ArrayList<ConfigEntry>(this.childEntries);
    }

    public ConfigEntry getMainEntry() {
        return this.mainEntry;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    @Override
    public boolean isFocused() {
        boolean isFocused = super.isFocused();
        if (isFocused) {
            return true;
        }
        for (ConfigEntry child : this.childEntries) {
            if (!child.isFocused()) continue;
            return true;
        }
        return false;
    }
}

