/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.lastlife;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeConfig;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeLivesManager;

public class LastLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /givelife, /boogeyman, /lastlife";
    public static final String COMMANDS_TEXT = "/claimkill, /lives, /givelife";
    public static int ROLL_MAX_LIVES = 6;
    public static int ROLL_MIN_LIVES = 2;

    @Override
    public Seasons getSeason() {
        return Seasons.LAST_LIFE;
    }

    @Override
    public ConfigManager getConfig() {
        return new LastLifeConfig();
    }

    @Override
    public LivesManager createLivesManager() {
        return new LastLifeLivesManager();
    }

    @Override
    public String getAdminCommands() {
        return COMMANDS_ADMIN_TEXT;
    }

    @Override
    public String getNonAdminCommands() {
        return COMMANDS_TEXT;
    }

    @Override
    public boolean sessionStart() {
        super.sessionStart();
        LivesManager livesManager = this.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            Main.currentSession.activeActions.add(lastLifeLivesManager.actionChooseLives);
        }
        return true;
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof LastLifeConfig)) {
            return;
        }
        LastLifeConfig config = (LastLifeConfig)configManager;
        ROLL_MIN_LIVES = LastLifeConfig.RANDOM_LIVES_MIN.get(config);
        ROLL_MAX_LIVES = LastLifeConfig.RANDOM_LIVES_MAX.get(config);
    }

    @Override
    public Integer getDefaultLives() {
        return null;
    }
}

