/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.server;

import java.util.EnumSet;
import java.util.Objects;
import net.mat0u5.lifeseries.entity.pathfinder.PathFinder;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.snail.goal.MiningNavigation;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class SnailPathfinding {
    private final Snail snail;
    @Nullable
    public PathFinder groundPathFinder;
    @Nullable
    public PathFinder pathFinder;
    public boolean navigationInit = false;
    private double lastSpeedMultiplier = 0.99;

    public SnailPathfinding(Snail snail) {
        this.snail = snail;
    }

    public void tick() {
        this.updatePathFinders();
        if (this.snail.isPaused()) {
            this.snail.method_5942().method_6340();
            return;
        }
        if (this.snail.field_6012 % 100 == 0 || !this.navigationInit) {
            this.navigationInit = true;
            this.updateMoveControl();
            this.updateNavigation();
        } else if (this.snail.field_6012 % 21 == 0) {
            this.updateMovementSpeed();
        } else if (this.snail.field_6012 % 5 == 0) {
            this.updateNavigationTarget();
        }
    }

    public void updatePathFinders() {
        class_2338 pos;
        if (this.snail.getSnailWorld().method_8608()) {
            return;
        }
        if (this.pathFinder != null && this.pathFinder.method_33724()) {
            this.pathFinder.method_31472();
            this.pathFinder = null;
        } else if (this.pathFinder == null || this.pathFinder.method_31481()) {
            this.pathFinder = (PathFinder)MobRegistry.PATH_FINDER.method_47821((class_3218)this.snail.getSnailWorld(), this.snail.method_24515(), class_3730.field_16462);
        } else {
            this.pathFinder.resetDespawnTimer();
        }
        if (this.groundPathFinder != null && this.groundPathFinder.method_33724()) {
            this.groundPathFinder.method_31472();
            this.groundPathFinder = null;
        } else if (this.groundPathFinder == null || this.groundPathFinder.method_31481()) {
            this.groundPathFinder = (PathFinder)MobRegistry.PATH_FINDER.method_47821((class_3218)this.snail.getSnailWorld(), this.snail.method_24515(), class_3730.field_16462);
        } else {
            this.groundPathFinder.resetDespawnTimer();
        }
        class_3218 world = (class_3218)this.snail.getSnailWorld();
        if (this.pathFinder != null) {
            this.pathFinder.method_48105(world, this.snail.method_23317(), this.snail.method_23318(), this.snail.method_23321(), EnumSet.noneOf(class_2709.class), this.snail.method_36454(), this.snail.method_36455(), false);
        }
        if ((pos = this.getGroundBlock()) == null) {
            return;
        }
        if (this.groundPathFinder != null) {
            this.groundPathFinder.method_48105(world, this.snail.method_23317(), pos.method_10264() + 1, this.snail.method_23321(), EnumSet.noneOf(class_2709.class), this.snail.method_36454(), this.snail.method_36455(), false);
        }
    }

    public void killPathFinders() {
        if (!this.snail.getSnailWorld().method_8608()) {
            if (this.groundPathFinder != null) {
                this.groundPathFinder.method_5768((class_3218)WorldUtils.getEntityWorld((class_1297)this.groundPathFinder));
            }
            if (this.pathFinder != null) {
                this.pathFinder.method_5768((class_3218)WorldUtils.getEntityWorld((class_1297)this.pathFinder));
            }
            if (this.groundPathFinder != null) {
                this.groundPathFinder.method_31472();
            }
            if (this.pathFinder != null) {
                this.pathFinder.method_31472();
            }
        }
    }

    @Nullable
    public class_2338 getGroundBlock() {
        class_243 startPos = WorldUtils.getEntityPos((class_1297)this.snail);
        class_243 endPos = new class_243(startPos.method_10216(), (double)this.snail.getSnailWorld().method_31607(), startPos.method_10215());
        class_3965 result = this.snail.getSnailWorld().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.snail));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return result.method_17777();
    }

    public double getDistanceToGroundBlock() {
        class_2338 belowBlock = this.getGroundBlock();
        if (belowBlock == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.snail.method_23318() - (double)belowBlock.method_10264() - 1.0;
    }

    public void fakeTeleportNearPlayer(double minDistanceFromPlayer) {
        class_1937 class_19372 = this.snail.getSnailWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_1309 boundEntity = this.snail.serverData.getBoundEntity();
            class_3222 boundPlayer = this.snail.serverData.getBoundPlayer();
            if (boundEntity == null || boundPlayer == null) {
                return;
            }
            class_1937 class_19373 = WorldUtils.getEntityWorld((class_1297)boundEntity);
            if (class_19373 instanceof class_3218) {
                class_3218 entityWorld = (class_3218)class_19373;
                if (!this.snail.serverData.shouldPathfind()) {
                    return;
                }
                class_2338 tpTo = this.getBlockPosNearTarget((class_1297)boundEntity, minDistanceFromPlayer);
                world.method_43128(null, this.snail.method_23317(), this.snail.method_23318(), this.snail.method_23321(), class_3417.field_46945, this.snail.method_5634(), this.snail.soundVolume(), this.snail.method_6017());
                entityWorld.method_43128(null, (double)tpTo.method_10263(), (double)tpTo.method_10264(), (double)tpTo.method_10260(), class_3417.field_46945, this.snail.method_5634(), this.snail.soundVolume(), this.snail.method_6017());
                AnimationUtils.spawnTeleportParticles(world, WorldUtils.getEntityPos((class_1297)this.snail));
                AnimationUtils.spawnTeleportParticles(entityWorld, tpTo.method_46558());
                this.snail.serverData.despawn();
                Snails.spawnSnailFor(boundPlayer, tpTo);
            }
        }
    }

    public static class_2338 getBlockPosNearPlayer(class_1297 target, double distanceFromTarget) {
        if (target == null) {
            return null;
        }
        class_2338 targetPos = target.method_24515();
        return WorldUtils.getCloseBlockPos(WorldUtils.getEntityWorld(target), targetPos, distanceFromTarget, 1, false);
    }

    public class_2338 getBlockPosNearTarget(class_1297 target, double distanceFromTarget) {
        if (target == null) {
            return null;
        }
        class_243 targetPos = this.snail.serverData.getPlayerPos();
        if (targetPos == null) {
            return null;
        }
        class_2338 targetBlockPos = class_2338.method_49637((double)targetPos.field_1352, (double)targetPos.field_1351, (double)targetPos.field_1350);
        return WorldUtils.getCloseBlockPos(WorldUtils.getEntityWorld(target), targetBlockPos, distanceFromTarget, 1, false);
    }

    public boolean canPathToPlayer(boolean flying) {
        if (!this.snail.serverData.shouldPathfind()) {
            return false;
        }
        if (this.pathFinder == null) {
            return false;
        }
        return this.pathFinder.canPathfind((class_1297)this.snail.serverData.getBoundEntity(), flying);
    }

    public boolean canPathToPlayerFromGround(boolean flying) {
        if (!this.snail.serverData.shouldPathfind()) {
            return false;
        }
        if (this.groundPathFinder == null) {
            return false;
        }
        return this.groundPathFinder.canPathfind((class_1297)this.snail.serverData.getBoundEntity(), flying);
    }

    public boolean isValidBlockOnGround() {
        if (this.groundPathFinder == null) {
            return false;
        }
        class_2680 block = WorldUtils.getEntityWorld((class_1297)this.groundPathFinder).method_8320(this.groundPathFinder.method_24515());
        if (block.method_27852(class_2246.field_10164)) {
            return false;
        }
        if (block.method_27852(class_2246.field_10382)) {
            return false;
        }
        return !block.method_27852(class_2246.field_27879);
    }

    public void updateNavigation() {
        if (this.snail.isSnailMining()) {
            this.setNavigationMining();
        } else if (this.snail.isSnailFlying()) {
            this.setNavigationFlying();
        } else {
            this.setNavigationWalking();
        }
    }

    public void updateMoveControl() {
        if (this.snail.isSnailFlying() || this.snail.isSnailMining()) {
            this.setMoveControlFlight();
        } else {
            this.setMoveControlWalking();
        }
    }

    public void setNavigationFlying() {
        this.snail.method_5941(class_7.field_22, -1.0f);
        this.snail.method_5941(class_7.field_19, -1.0f);
        this.snail.method_5941(class_7.field_47413, -1.0f);
        this.snail.method_5941(class_7.field_26446, -1.0f);
        this.snail.method_5941(class_7.field_15, -1.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.setNavigation((class_1408)new class_1407((class_1308)this.snail, this.snail.getSnailWorld()));
        this.updateNavigationTarget();
    }

    public void setNavigationWalking() {
        this.snail.method_5941(class_7.field_22, -1.0f);
        this.snail.method_5941(class_7.field_19, -1.0f);
        this.snail.method_5941(class_7.field_47413, -1.0f);
        this.snail.method_5941(class_7.field_26446, -1.0f);
        this.snail.method_5941(class_7.field_15, -1.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.setNavigation((class_1408)new class_1409((class_1308)this.snail, this.snail.getSnailWorld()));
        this.updateNavigationTarget();
    }

    public void setNavigationMining() {
        this.snail.method_5941(class_7.field_22, 0.0f);
        this.snail.method_5941(class_7.field_19, 0.0f);
        this.snail.method_5941(class_7.field_47413, 0.0f);
        this.snail.method_5941(class_7.field_26446, 0.0f);
        this.snail.method_5941(class_7.field_15, 0.0f);
        this.snail.method_5941(class_7.field_25418, 0.0f);
        this.snail.setNavigation((class_1408)new MiningNavigation((class_1308)this.snail, this.snail.getSnailWorld()));
        this.updateNavigationTarget();
    }

    public void updateNavigationTarget() {
        class_243 targetPos = this.snail.serverData.getPlayerPos();
        if (!this.snail.serverData.shouldPathfind() || targetPos == null || this.snail.method_5707(targetPos) > 22500.0) {
            this.snail.method_5942().method_6340();
            return;
        }
        if (this.snail.method_5942() instanceof class_1407) {
            this.snail.method_5942().method_6344(1.0);
            class_11 path = this.snail.method_5942().method_6352(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 0);
            if (path != null) {
                this.snail.method_5942().method_6334(path, 1.0);
            }
        } else {
            this.snail.method_5942().method_6344((double)0.35f);
            class_11 path = this.snail.method_5942().method_6352(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 0);
            if (path != null) {
                this.snail.method_5942().method_6334(path, (double)0.35f);
            }
        }
    }

    public void updateMovementSpeed() {
        class_11 path = this.snail.method_5942().method_6345();
        if (path != null) {
            double length = path.method_38();
            double speedMultiplier = 1.0;
            if (length > 10.0) {
                speedMultiplier += length / 100.0;
            }
            if (speedMultiplier != this.lastSpeedMultiplier) {
                this.lastSpeedMultiplier = speedMultiplier;
                double movementSpeed = (double)0.35f * speedMultiplier * Snail.GLOBAL_SPEED_MULTIPLIER;
                double flyingSpeed = (double)0.3f * speedMultiplier * Snail.GLOBAL_SPEED_MULTIPLIER;
                if (this.snail.serverData.isNerfed()) {
                    movementSpeed *= 0.6;
                    flyingSpeed *= 0.6;
                }
                if (movementSpeed < 0.01) {
                    movementSpeed = 0.01;
                }
                if (flyingSpeed < 0.01) {
                    flyingSpeed = 0.01;
                }
                Objects.requireNonNull(this.snail.method_5996(class_5134.field_23719)).method_6192(movementSpeed);
                Objects.requireNonNull(this.snail.method_5996(class_5134.field_23720)).method_6192(flyingSpeed);
            }
        }
    }

    public void setMoveControlFlight() {
        this.snail.method_5875(true);
        this.snail.setMoveControl((class_1335)new class_1331((class_1308)this.snail, 20, true));
    }

    public void setMoveControlWalking() {
        this.snail.method_5875(false);
        this.snail.setMoveControl(new class_1335((class_1308)this.snail));
    }
}

