/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.MobSwap;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.AstralProjection;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Creaking;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Invisibility;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.PlayerDisguise;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.TimeControl;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class WildcardManager {
    public static final Map<Wildcards, Wildcard> activeWildcards = new HashMap<Wildcards, Wildcard>();
    public static final Random rnd = new Random();
    public static double ACTIVATE_WILDCARD_MINUTE = 2.5;
    public static Wildcards chosenWildcard = null;
    private static final List<String> allColorCodes = List.of("6", "9", "a", "b", "c", "d", "e");

    public static void addSessionActions() {
        Main.currentSession.addSessionActionIfTime(new SessionAction(OtherUtils.minutesToTicks(ACTIVATE_WILDCARD_MINUTE - 2.0)){

            @Override
            public void trigger() {
                if (activeWildcards.isEmpty()) {
                    PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"A Wildcard will be activated in 2 minutes!").method_27692(class_124.field_1080));
                }
            }
        });
        Main.currentSession.addSessionAction(new SessionAction(OtherUtils.minutesToTicks(ACTIVATE_WILDCARD_MINUTE), TextUtils.formatString("\u00a77Activate Wildcard \u00a7f[{}]", OtherUtils.formatTime(OtherUtils.minutesToTicks(ACTIVATE_WILDCARD_MINUTE))), "Activate Wildcard"){

            @Override
            public void trigger() {
                if (activeWildcards.isEmpty()) {
                    WildcardManager.activateWildcards();
                }
            }
        });
    }

    public static WildLife getSeason() {
        Season season = Main.currentSeason;
        if (season instanceof WildLife) {
            WildLife wildLife = (WildLife)season;
            return wildLife;
        }
        return null;
    }

    public static void chosenWildcard(Wildcards wildcard) {
        PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("The {} wildcard has been selected for this session.", new Object[]{wildcard}));
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77Use the \u00a7f'/wildcard choose' \u00a77 command if you want to change it."));
        chosenWildcard = wildcard;
    }

    public static void chooseRandomWildcard() {
        if (chosenWildcard != null) {
            activeWildcards.put(chosenWildcard, chosenWildcard.getInstance());
            return;
        }
        int index = rnd.nextInt(7);
        if (index == 0) {
            activeWildcards.put(Wildcards.SIZE_SHIFTING, new SizeShifting());
        }
        if (index == 1) {
            activeWildcards.put(Wildcards.HUNGER, new Hunger());
        }
        if (index == 2) {
            activeWildcards.put(Wildcards.TIME_DILATION, new TimeDilation());
        }
        if (index == 3) {
            activeWildcards.put(Wildcards.SNAILS, new Snails());
        }
        if (index == 4) {
            activeWildcards.put(Wildcards.MOB_SWAP, new MobSwap());
        }
        if (index == 5) {
            activeWildcards.put(Wildcards.TRIVIA, new TriviaWildcard());
        }
        if (index == 6) {
            activeWildcards.put(Wildcards.SUPERPOWERS, new SuperpowersWildcard());
        }
    }

    public static void onPlayerJoin(class_3222 player) {
        if (!WildcardManager.isActiveWildcard(Wildcards.SIZE_SHIFTING) && SizeShifting.getPlayerSize(player) != 1.0 && !TriviaHandler.cursedGigantificationPlayers.contains(player.method_5667())) {
            SizeShifting.setPlayerSize(player, 1.0);
        }
        if (!WildcardManager.isActiveWildcard(Wildcards.HUNGER)) {
            player.method_6016(class_1294.field_5903);
        }
        if (!WildcardManager.isActiveWildcard(Wildcards.TRIVIA)) {
            TriviaWildcard.resetPlayerOnBotSpawn(player);
        }
        TaskScheduler.scheduleTask(1, () -> {
            for (class_3222 onlinePlayer : PlayerUtils.getAllPlayers()) {
                Superpower power = SuperpowersWildcard.getSuperpowerInstance(onlinePlayer);
                if (power == null) continue;
                if (power instanceof PlayerDisguise) {
                    PlayerDisguise playerDisguise = (PlayerDisguise)power;
                    playerDisguise.sendDisguisePacket();
                }
                if (power instanceof AstralProjection) {
                    AstralProjection astralProjection = (AstralProjection)power;
                    astralProjection.sendDisguisePacket();
                }
                if (!(power instanceof Invisibility)) continue;
                Invisibility invisibility = (Invisibility)power;
                invisibility.sendInvisibilityPacket();
            }
        });
        MorphManager.resetMorph((class_1657)player);
    }

    public static void onPlayerFinishJoining(class_3222 player) {
        if (WildcardManager.isActiveWildcard(Wildcards.SUPERPOWERS) && !SuperpowersWildcard.hasPower(player) && Main.livesManager.isAlive(player)) {
            SuperpowersWildcard.rollRandomSuperpowerForPlayer(player);
        }
    }

    public static void activateWildcards() {
        WildcardManager.showDots();
        TaskScheduler.scheduleTask(90, () -> {
            if (activeWildcards.isEmpty()) {
                WildcardManager.chooseRandomWildcard();
            }
            for (Wildcard wildcard : activeWildcards.values()) {
                if (wildcard.active) continue;
                wildcard.activate();
            }
            WildcardManager.showCryptTitle("A wildcard is active!");
        });
        TaskScheduler.scheduleTask(92, NetworkHandlerServer::sendUpdatePackets);
    }

    public static void fadedWildcard() {
        PlayerUtils.broadcastMessage(class_2561.method_30163((String)"\u00a77A Wildcard has faded..."));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_19344);
    }

    public static void showDots() {
        List<class_3222> players = PlayerUtils.getAllPlayers();
        PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
        PlayerUtils.sendTitleToPlayers(players, (class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l,"), 0, 40, 0);
        TaskScheduler.scheduleTask(30, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, (class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l, \u00a7e\u00a7l,"), 0, 40, 0);
        });
        TaskScheduler.scheduleTask(60, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, (class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l, \u00a7e\u00a7l, \u00a7c\u00a7l,"), 0, 40, 0);
        });
    }

    public static void showCryptTitle(String text) {
        int i;
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14905, 0.2f, 1.0f);
        String colorCrypt = "\u00a7r\u00a76\u00a7l\u00a7k";
        String colorNormal = "\u00a7r\u00a76\u00a7l";
        ArrayList<Integer> encryptedIndexes = new ArrayList<Integer>();
        for (i = 0; i < text.length(); ++i) {
            encryptedIndexes.add(i);
        }
        for (i = 0; i < text.length(); ++i) {
            if (!encryptedIndexes.isEmpty()) {
                encryptedIndexes.remove(rnd.nextInt(encryptedIndexes.size()));
            }
            StringBuilder result = new StringBuilder();
            for (int j = 0; j < text.length(); ++j) {
                result.append(encryptedIndexes.contains(j) ? colorCrypt : colorNormal);
                result.append(text.charAt(j));
            }
            TaskScheduler.scheduleTask((i + 1) * 4, () -> PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)String.valueOf(result)), 0, 30, 20));
        }
    }

    public static void showRainbowCryptTitle(String text) {
        int i;
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14905, 0.2f, 1.0f);
        String colorCrypt = "\u00a7r\u00a7_\u00a7l\u00a7k";
        String colorNormal = "\u00a7r\u00a7_\u00a7l";
        ArrayList<Integer> encryptedIndexes = new ArrayList<Integer>();
        for (i = 0; i < text.length(); ++i) {
            encryptedIndexes.add(i);
        }
        for (i = 0; i < text.length() + 24; ++i) {
            if (!encryptedIndexes.isEmpty()) {
                encryptedIndexes.remove(rnd.nextInt(encryptedIndexes.size()));
            }
            StringBuilder result = new StringBuilder();
            for (int j = 0; j < text.length(); ++j) {
                String randomColor = allColorCodes.get(rnd.nextInt(allColorCodes.size()));
                result.append(encryptedIndexes.contains(j) ? colorCrypt.replace("_", randomColor) : colorNormal.replace("_", randomColor));
                result.append(text.charAt(j));
            }
            TaskScheduler.scheduleTask((i + 1) * 2, () -> PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)String.valueOf(result)), 0, 4, 4));
        }
    }

    public static void tick() {
        SuperpowersWildcard.onTick();
        for (Wildcard wildcard : activeWildcards.values()) {
            wildcard.softTick();
            if (!wildcard.active) continue;
            wildcard.tick();
        }
        SizeShifting.resetSizesTick(WildcardManager.isActiveWildcard(Wildcards.SIZE_SHIFTING));
        if (Main.server != null && Main.server.method_3780() % 200 == 0) {
            if (!WildcardManager.isActiveWildcard(Wildcards.MOB_SWAP)) {
                MobSwap.killMobSwapMobs();
            }
            Creaking.killUnassignedMobs();
        }
        if (TimeControl.changedSpeedFor > 0) {
            --TimeControl.changedSpeedFor;
        }
        if (!WildcardManager.isActiveWildcard(Wildcards.TIME_DILATION) && TimeControl.changedSpeedFor <= 0 && TimeDilation.getWorldSpeed() != 20.0f) {
            TimeDilation.setWorldSpeed(20.0f);
        }
        if (WildcardManager.isActiveWildcard(Wildcards.TRIVIA)) {
            for (UUID uuid : TriviaHandler.cursedSliding) {
                class_3222 player = PlayerUtils.getPlayer(uuid);
                NetworkHandlerServer.sendLongPacket(player, PacketNames.CURSE_SLIDING, System.currentTimeMillis());
            }
        }
    }

    public static void tickSessionOn() {
        for (Wildcard wildcard : activeWildcards.values()) {
            if (!wildcard.active) continue;
            wildcard.tickSessionOn();
        }
    }

    public static void onSessionStart() {
        if (chosenWildcard == null && activeWildcards.isEmpty()) {
            for (class_3222 player : PlayerUtils.getAdminPlayers()) {
                NetworkHandlerServer.sendStringPacket(player, PacketNames.SELECT_WILDCARDS, "true");
            }
        }
    }

    public static void onSessionEnd() {
        Wildcard wildcard;
        if (!activeWildcards.isEmpty()) {
            WildcardManager.fadedWildcard();
        }
        if (WildcardManager.isActiveWildcard(Wildcards.CALLBACK) && (wildcard = activeWildcards.get((Object)Wildcards.CALLBACK)) instanceof Callback) {
            Callback callback = (Callback)wildcard;
            callback.deactivate();
            activeWildcards.remove((Object)Wildcards.CALLBACK);
        }
        for (Wildcard wildcard2 : activeWildcards.values()) {
            wildcard2.deactivate();
        }
        activeWildcards.clear();
        SuperpowersWildcard.resetAllSuperpowers();
        NetworkHandlerServer.sendUpdatePackets();
        chosenWildcard = null;
    }

    public static boolean isActiveWildcard(Wildcards wildcard) {
        return activeWildcards.containsKey((Object)wildcard);
    }

    public static void onUseItem(class_3222 player) {
        Hunger.onUseItem(player);
    }
}

