/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;

public class TriviaQuestionManager {
    private static final String DEFAULT_EASY_TRIVIA = "[\n\t{\n\t\t\"question\": \"Which pair was out first in Double Life?\",\n\t\t\"answers\": [\"Jimmy and Tango\", \"Joel and Etho\", \"Grian and Scar\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What did the Southlanders say when using a spyglass in Last Life?\",\n\t\t\"answers\": [\"Aha!\", \"Oho!\", \"Hee-hee!\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who was Etho's favorite son in Limited Life?\",\n\t\t\"answers\": [\"Bdubs\", \"Scar\", \"He didn't play favorites\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Secret Life, who failed the 100-block-high water bucket clutch? \",\n\t\t\"answers\": [\"Grian\", \"Joel\", \"Martyn\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"In Limited Life, which player went AFK for a whole session because they were sick?\",\n\t\t\"answers\": [\"Pearl\", \"Grian\", \"Cleo\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What did Scott and Martyn call themselves in Limited Life?\",\n\t\t\"answers\": [\"Mean Gills\", \"LGB-SEA\", \"H2-bros\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the name of Pearl's dog in Double Life?\",\n\t\t\"answers\": [\"Tilly\", \"Milly\", \"Billy\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Which of these was NOT a Life Series Season?\",\n\t\t\"answers\": [\"Second Life\", \"Limited Life\", \"Real Life\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Where did Grian and Mumbo hide their diamonds in Last Life?\",\n\t\t\"answers\": [\"Right here!\", \"In a hidden chest below Mumbo's bunker\", \"In an enderchest\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In what season did Scar take care of Jellie Pandas?\",\n\t\t\"answers\": [\"Last Life\", \"Double Life\", \"Secret Life\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Of these pairs, who got married in Third Life?\",\n\t\t\"answers\": [\"Ren and Martyn\", \"Etho and Bdubs\", \"Jimmy and Scott\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who was Pearl's soulmate in Double Life?\",\n\t\t\"answers\": [\"Scott\", \"Cleo\", \"Martyn\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Third Life, who declared \\\"Red winter is coming!\\\" when they turned red?\",\n\t\t\"answers\": [\"Ren\", \"Martyn\", \"Skizz\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the name of Etho and Joel's base in Double Life?\",\n\t\t\"answers\": [\"The Pirate-ship\", \"The Big Barge\", \"The Relation-ship\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What season is Team TIES from? \",\n\t\t\"answers\": [\"Last Life\", \"Secret Life\", \"Limited Life\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who was Bdubs' soulmate Double Life?\",\n\t\t\"answers\": [\"Ren\", \"Etho\", \"Impulse\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What item was stolen from the front of BigB's Third Life base? \",\n\t\t\"answers\": [\"Enchanter\", \"Giant cookie\", \"Doors\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Which two mobs fought against each other for a task in Secret Life?\",\n\t\t\"answers\": [\"Warden vs Guardian\", \"Warden vs Wither\", \"Wither vs Ender Dragon\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"\\\"The 3 G's\\\" are an alliance consisting of Cleo, Scott, and Pearl. In which season did this alliance form?\",\n\t\t\"answers\": [\"Limited Life\", \"Double Life\", \"Last Life\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Where was the Enchanter located originally in Double Life? \",\n\t\t\"answers\": [\"Spawn\", \"Ancient City\", \"A mangrove forest\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who won Real Life?\",\n\t\t\"answers\": [\"Scott\", \"Cleo\", \"Pearl\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What was the name of Gem, Impulse, and Scott's band? \",\n\t\t\"answers\": [\"Gem and the Boys\", \"Cherryblossoms\", \"Gem and the Scotts\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Why was Bdubs' house upside down in Secret Life?\",\n\t\t\"answers\": [\"It was an inside joke with his team\", \"It was his task\", \"He wanted to try something new\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What happened when you failed a hard task in Secret Life?\",\n\t\t\"answers\": [\"You died\", \"You lost 10 hearts\", \"Nothing happened\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"If I had a nickel for every life series Jimmy won, how many nickel would I have?\",\n\t\t\"answers\": [\"1, which isn't a lot, but at least it's something\", \"2, which isn't a lot, but it's weird it happened twice\", \"0, which really means nothing\"],\n\t\t\"correct_answer_index\": 2\n\t}\n]";
    private static final String DEFAULT_NORMAL_TRIVIA = "[\n\t{\n\t\t\"question\": \"What did Tango name his and Jimmy's Warden in Double Life?\",\n\t\t\"answers\": [\"Rancher's Revenge\", \"Rancher's Wrath\", \"Rancher's Bodyguard\", \"It didn't have a name\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Why did Ren begin wearing a crown in Third Life?\",\n\t\t\"answers\": [\"To show off his MCC win\", \"Got it in a box of cereal\", \"To make Dogwarts into a kingdom\", \"Carried over from Hermitcraft\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the name of Grian's Magma cube? \",\n\t\t\"answers\": [\"Etho's Fridge\", \"Etho's Oven\", \"Etho's Dishwasher\", \"Etho's Microwave\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What was the color of Skizz's underwear in Limited Life?\",\n\t\t\"answers\": [\"Red\", \"Yellow\", \"Green\", \"White with hearts\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"How was the Double Life Warden killed?\",\n\t\t\"answers\": [\"Bow and arrow\", \"Fishing rod\", \"Sword\", \"Axe\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who killed the Ender Dragon in Secret Life?\",\n\t\t\"answers\": [\"Scott\", \"Impulse\", \"Pearl\", \"Bdubs\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"BigB has an alternate ego that he uses throughout the series. What is his name? \",\n\t\t\"answers\": [\"Cherry\", \"Berry\", \"Terry\", \"Jerry\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Which one of these hasn't been a feature in Bdubs' skin during the Life Series?\",\n\t\t\"answers\": [\"A golden tooth\", \"A red bandana\", \"A black eye\", \"A missing tooth\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Third Life, how did Martyn kill Ren to turn him red?\",\n\t\t\"answers\": [\"With an axe\", \"With TNT\", \"With a sword\", \"Shoved him off a cliff\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who won \\\"You Bet Your Life\\\" in Last Life?\",\n\t\t\"answers\": [\"Cleo\", \"Scott\", \"Joel\", \"Lizzie\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Which players weren't pressent for the trapdoor sleepover in Secret Life?\",\n\t\t\"answers\": [\"Martyn and Etho\", \"Etho and Tango\", \"Grian and Etho\", \"Martyn and Grian\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What did Scar and Pearl use to hurt their soulmates in Double Life?\",\n\t\t\"answers\": [\"Lava\", \"Gravel/sand\", \"Powdered snow\", \"Drowning\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who was referred to as the \\\"Red King\\\" in Third Life?\",\n\t\t\"answers\": [\"Martyn\", \"Scar\", \"Ren\", \"Bdubs\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"When did Gem make her first appearance in the Life Series?\",\n\t\t\"answers\": [\"Wild Life\", \"Secret Life\", \"Limited Life\", \"Real Life\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What was the name of Pearl's cat in Limited Life?\",\n\t\t\"answers\": [\"Froggy\", \"Tilly\", \"Jumpy\", \"Hoppy\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the cause of Lizzie's final death in Secret Life?\",\n\t\t\"answers\": [\"Drowning\", \"An Enderman\", \"Fell into the void\", \"Fall damage\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Which goat horn type did Jimmy and Tango have in Double Life?\",\n\t\t\"answers\": [\"Ponder\", \"Sing\", \"Dream\", \"Seek\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"How many times did Skizz die in the first episode of Limited Life? \",\n\t\t\"answers\": [\"4 times\", \"3 times\", \"2 times\", \"5 times\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who was the first to fail a task in Secret Life?\",\n\t\t\"answers\": [\"Mumbo\", \"Jimmy\", \"Skizz\", \"Scar\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"What was the name of Scott and Pearl's base in Last Life? \",\n\t\t\"answers\": [\"Scottagecore\", \"The Mosscottage\", \"Home Sweet Home\", \"The Scottage\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Who opened the End portal in Secret Life? \",\n\t\t\"answers\": [\"Gem\", \"Pearl\", \"Impulse\", \"Bdubs\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who were the wizards in Last Life?\",\n\t\t\"answers\": [\"Scott and Pearl\", \"Bdubs and Etho\", \"Joel and Lizzie\", \"Scar and Joel\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Who started the zombie curse in Secret Life session 7?\",\n\t\t\"answers\": [\"Cleo\", \"Bdubs\", \"Gem\", \"Martyn\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What block was Etho's swamp fortress primarily made out of in Third Life?\",\n\t\t\"answers\": [\"Leaves\", \"Spruce\", \"Wool\", \"Dark oak\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who betrayed Cleo in Last Life? \",\n\t\t\"answers\": [\"Scott\", \"Lizzie\", \"BigB\", \"Ren\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who had a wolf pack in Third Life? \",\n\t\t\"answers\": [\"Scar\", \"Grian\", \"Joel\", \"Pearl\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"On what mob did Gem and Pearl ride around killing people together?\",\n\t\t\"answers\": [\"Horse\", \"Skeleton horse\", \"Pig\", \"Camel\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Who was the first ever Boogeyman in the Life Series?\",\n\t\t\"answers\": [\"Etho\", \"Bdubs\", \"Grian\", \"Scott\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who pranked other players with light grey stained glass in Third Life?\",\n\t\t\"answers\": [\"Etho\", \"Impulse\", \"Tango\", \"Bdubs\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the name of Scar's base in Secret Life?\",\n\t\t\"answers\": [\"Saloon Scar\", \"Scar's Outpost\", \"Trader Scar's\", \"Scar's Emporium\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"In Limited Life, Pearl and BigB decorated their tower with the face of an animal. What was it?\",\n\t\t\"answers\": [\"Frogs\", \"Wolves\", \"Sheep\", \"Cats\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who built the Ghast farm in Last Life?\",\n\t\t\"answers\": [\"Etho and Grian\", \"Impulse and Tango\", \"Grian and Mumbo\", \"Impulse and Mumbo\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who did Mumbo compete against to have the biggest tower in Secret Life?\",\n\t\t\"answers\": [\"Grian\", \"Gem\", \"Pearl\", \"Joel\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who was the S in team BEST?\",\n\t\t\"answers\": [\"Scott\", \"Scar\", \"Skizz\", \"Sgrian\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Between Bdubs, Impulse, Tango, and Scott, who was out first during Tag in Secret Life?\",\n\t\t\"answers\": [\"Impulse\", \"Tango\", \"Bdubs\", \"Scott\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who threw a birthday party in Limited Life?\",\n\t\t\"answers\": [\"Jimmy\", \"Martyn\", \"Joel\", \"Scott\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What was Lizzie's base in Secret Life?\",\n\t\t\"answers\": [\"Giant peach\", \"Giant watermelon\", \"Giant apple\", \"Giant pumpkin\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Which team blew up Bread Bridge in Limited Life? \",\n\t\t\"answers\": [\"Clockers\", \"Nosey Neighbots\", \"TIES\", \"Mean Gills\"],\n\t\t\"correct_answer_index\": 2\n\t}\n]";
    private static final String DEFAULT_HARD_TRIVIA = "[\n\t{\n\t\t\"question\": \"What was the name of the Ravager that killed Jimmy in Limited Life?\",\n\t\t\"answers\": [\"Grian\", \"Sunday Driver\", \"Bad Boys Big Bad Dog\", \"The Curse\", \"Boogeyman\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Third Life, Scar used a clock to convince Bdubs to eliminate Impulse. Where did he get it?\",\n\t\t\"answers\": [\"Found it in a chest\", \"Cleo gave it to him\", \"He crafted it himself\", \"Bdubs dropped it\", \"Impulse dropped it\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"Which player had the fewest deaths in Last Life?\",\n\t\t\"answers\": [\"Scott\", \"BigB\", \"Martyn\", \"Etho\", \"Jimmy\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"Which Lyrics of \\\"All Star\\\" by Smash Mouth did Joel NOT say as part of a Secret Life task? \",\n\t\t\"answers\": [\"\u201cI could use a little fuel myself\u201d\", \"\\\"So much to do, so much to see\u201d\", \"\\\"I need to get myself away from this place\\\"\", \"\\\"I ain\u2019t the sharpest tool in the shed\\\"\", \"\u201cMy world\u2019s on fire, how about yours?\u201d\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Who said this quote? \\\"You know, I've always had a thing for red names, bad boys...\\\"\",\n\t\t\"answers\": [\"Martyn\", \"Jimmy\", \"Ren\", \"Lizzie\", \"Scar\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Out of these Third Life quotes, which one was not said by Scar?\",\n\t\t\"answers\": [\"\\\"Grian, watch out, we're taking our pants off\\\"\", \"\\\"Skizz I want all your clothes\\\"\", \"\\\"I'm naked and come in peace\\\"\", \"\\\"Yes, we are pants swapers\\\"\", \"\\\"Everyone always worries about me being pantsless\\\"\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"In Secret Life, who was the only player to show up to Lizzie's slumber party? \",\n\t\t\"answers\": [\"Pearl\", \"Cleo\", \"No one showed up\", \"Joel\", \"Gem\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Who was Grian's \\\"Secret Soulmate\\\" in Double Life? \",\n\t\t\"answers\": [\"Ren\", \"Martyn\", \"Pearl\", \"BigB\", \"Etho\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"What pet did Mumbo try to drown in Secret Life?\",\n\t\t\"answers\": [\"Grian's Magma Cube\", \"Scar's camel\", \"Etho's Warden\", \"Bdubs' horse\", \"Pearl's dog\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Who burned down Jimmy and Scott's wall in Third Life?\",\n\t\t\"answers\": [\"Martyn\", \"Joel\", \"Jimmy\", \"Scar\", \"Tango\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What was Mumbo's ultimate weapon to stop a red name in Secret Life?\",\n\t\t\"answers\": [\"A giant redstone machine\", \"Act like a red name\", \"Run, cry, and scream, in that specific order\", \"Fence post\", \"Ask for mercy\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Which player appeared the tallest in the April Fools episode Real Life?\",\n\t\t\"answers\": [\"BigB\", \"Pearl\", \"Jimmy\", \"Skizz\", \"Impulse\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who killed Lizzie while she was invisible on a skeleton horse in Secret Life? \",\n\t\t\"answers\": [\"Jimmy\", \"A mob killed her\", \"She killed herself\", \"Joel\", \"Martyn\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"When Scar turned red in Third Life, he gave Grian two types of flowers as a peace offering. What were these flowers?\",\n\t\t\"answers\": [\"Rose bushes and alliums\", \"Lilies of the valley and tulips\", \"Sunflowers and oxeye daisies\", \"Dandelions and blue orchids\", \"Lilacs and poppies\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"Which player started the first ever Raid in the Life Series? \",\n\t\t\"answers\": [\"Martyn\", \"Grian\", \"Impulse\", \"Tango\", \"Scar\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In every single season he's participated in so far, Mumbo has died right after which player?\",\n\t\t\"answers\": [\"Skizz\", \"Lizzie\", \"Jimmy\", \"Grian\", \"Tango\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Which player lost all of their lives in one session of Third Life?\",\n\t\t\"answers\": [\"BigB\", \"Joel\", \"Tango\", \"Grian\", \"Scar\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Which of these did Mumbo use to get a Boogey kill in Last Life?\",\n\t\t\"answers\": [\"Bow and arrow\", \"End Crystal\", \"Fire charge\", \"Sword\", \"TNT\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"Which of these was NOT a house of Dogwarts?\",\n\t\t\"answers\": [\"Cluckle Cluck\", \"Carrotyn\", \"Crimson Wart\", \"Enderport\", \"Rose Thorn\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"Who said this quote? \\\"Do me a favor? Die for me.\\\"\",\n\t\t\"answers\": [\"Cleo\", \"Scar\", \"Pearl\", \"Joel\", \"Ren\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Which player makes it their goal to go to the Nether in the first session of every season? \",\n\t\t\"answers\": [\"Scott\", \"Martyn\", \"Pearl\", \"Etho\", \"Bdubs' horse\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"What was the name of Scar's bee in Third Life?\",\n\t\t\"answers\": [\"Mr. Pepperoni\", \"Mr. Bee\", \"Mr. Bubbles\", \"Mr. Yoda\", \"Mr. Balloon\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What did Ren do with the Wither Star in Last Life?\",\n\t\t\"answers\": [\"Crafted a beacon\", \"Forgot it in a random chest\", \"Gave it to an ally\", \"Used it as a good-luck charm\", \"Hung it up on a wall in his base\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"How did Gem lose her eye in Secret Life?\",\n\t\t\"answers\": [\"She lost it to the End portal\", \"There was no lore, she just did it for fun\", \"A skeleton shot her\", \"The Boogeyman curse\", \"She didn't lose an eye\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Double Life, Tango brought a Warden to the surface to kill two specific players. Who were they?\",\n\t\t\"answers\": [\"Scott and Pearl\", \"Martyn and Cleo\", \"Scar and Grian\", \"Impulse and Bdubs\", \"Etho and Joel\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"What did Martyn hand over to Pearl when she asked for Tilly in Limited Life?\",\n\t\t\"answers\": [\"Her ashes\", \"Her bones\", \"A new wolf\", \"A cat\", \"Rotten flesh\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"In Last Life, Lizzie had 3 wolves. Identify one of the two incorrect names here.\",\n\t\t\"answers\": [\"Troll\", \"Ogre\", \"Dragon\", \"Taxes\", \"Gas-Prices\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Who stole Scar's llama \\\"Pizza\\\" in Third Life?\",\n\t\t\"answers\": [\"Ren\", \"Martyn\", \"Grian\", \"Cleo\", \"Jimmy\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"What season did Skizz NOT participate in?\",\n\t\t\"answers\": [\"Last Life\", \"Double Life\", \"He was there the whole time\", \"Secret Life\", \"Limited Life\"],\n\t\t\"correct_answer_index\": 1\n\t},\n\t{\n\t\t\"question\": \"In Third Life, Impulse showed off a trick to find which ore?\",\n\t\t\"answers\": [\"Lapis\", \"Emeralds\", \"Iron\", \"Ancient debris\", \"Diamonds\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"In Limited Life, Jimmy had a frog which was killed by Pearl. What was its name?\",\n\t\t\"answers\": [\"Froggy D Luffy\", \"Froggy\", \"Leonardo da Vinci\", \"Bubbles The Frog\", \"Judge Judy And Executioner\"],\n\t\t\"correct_answer_index\": 4\n\t},\n\t{\n\t\t\"question\": \"What base did Cleo burn down in Last Life session 5 as an act of revenge?\",\n\t\t\"answers\": [\"The Fairy Fort\", \"Magical Mountain\", \"The Southlands\", \"Snow Fort\", \"Scottage\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"Which soulmate pair invited a hoard of zombies to the pool party in Double Life?\",\n\t\t\"answers\": [\"Ren and BigB\", \"Etho and Joel\", \"Tango and Jimmy\", \"Impulse and Bdubs\", \"Scar and Grian\"],\n\t\t\"correct_answer_index\": 0\n\t},\n\t{\n\t\t\"question\": \"What was the name of Skizz's dog in Last Life? \",\n\t\t\"answers\": [\"Kevin Mad-Eye Malone Jimmy Refrigerator Bubbles Dugan\", \"Kevin Malone Jimmy Bubbles Refrigerator Mad-Eye Dugan\", \"Kevin Bubbles Malone Refrigerator Jimmy Mad-Eye Dugan\", \"Kevin Refrigerator Malone Bubbles Mad-Eye Jimmy Dugan\", \"I ain't reading all that\"],\n\t\t\"correct_answer_index\": 2\n\t},\n\t{\n\t\t\"question\": \"Why did Cleo turn into a human in Secret Life?\",\n\t\t\"answers\": [\"She didn't turn into a human\", \"She was given a weakness potion and a golden apple\", \"Someone subbed in for her\", \"She survived the Zombie Apocalypse\", \"It was for her task\"],\n\t\t\"correct_answer_index\": 3\n\t},\n\t{\n\t\t\"question\": \"Did you like our trivia?\",\n\t\t\"answers\": [\"Yes!\", \"Definitely!\", \"Absolutely!\", \"Of course!\", \"No :(\"],\n\t\t\"correct_answer_index\": 0\n\t}\n]";
    private File file;
    private File folder;

    public TriviaQuestionManager(String folder, String file) {
        this.file = new File(folder + "/" + file);
        this.folder = new File(folder);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)this.folder);
            return;
        }
        if (!this.file.exists()) {
            try {
                if (!this.file.createNewFile()) {
                    Main.LOGGER.error("Failed to create file {}", (Object)this.file);
                    return;
                }
                if (file.startsWith("easy-")) {
                    this.setFileContent(DEFAULT_EASY_TRIVIA);
                } else if (file.startsWith("normal-")) {
                    this.setFileContent(DEFAULT_NORMAL_TRIVIA);
                } else if (file.startsWith("hard-")) {
                    this.setFileContent(DEFAULT_HARD_TRIVIA);
                }
            }
            catch (IOException ex) {
                Main.LOGGER.error(ex.getMessage());
            }
        }
    }

    private void setFileContent(String content) {
        try {
            FileWriter myWriter = new FileWriter(this.file, false);
            myWriter.write(content);
            myWriter.close();
        }
        catch (IOException e) {
            Main.LOGGER.error(e.getMessage());
        }
    }

    public List<TriviaQuestion> getTriviaQuestions() throws IOException {
        String content = new String(Files.readAllBytes(this.file.toPath()));
        Gson gson = new Gson();
        return (List)gson.fromJson(content, new TypeToken<List<TriviaQuestion>>(this){}.getType());
    }
}

