/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.server;

import java.util.Random;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.minecraft.class_3414;

public class SnailSounds {
    private static final Random random = new Random();
    private final Snail snail;
    private int propellerSoundCooldown = 0;
    private int walkSoundCooldown = 0;
    private boolean lastGlidingOrLanding = false;
    public boolean lastFlying = false;
    private int soundCooldown = 0;

    public SnailSounds(Snail snail) {
        this.snail = snail;
    }

    public void playSounds() {
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if (this.snail.isInLavaLocal && random.nextInt(100) == 0) {
            this.playLavaSound();
        }
        if (this.snail.method_5809() && random.nextInt(100) == 0) {
            this.playBurnSound();
        }
        if (this.snail.method_5669() == 0 && random.nextInt(100) == 0) {
            this.playDrownSound();
        }
        if ((this.snail.isSnailGliding() || this.snail.isSnailLanding()) && !this.lastGlidingOrLanding) {
            this.playFallSound();
        }
        if (this.snail.isSnailFlying()) {
            if (!this.lastFlying) {
                this.playFlySound();
            }
            if (this.propellerSoundCooldown > 0) {
                --this.propellerSoundCooldown;
            }
            if (this.propellerSoundCooldown == 0) {
                this.propellerSoundCooldown = 40;
                this.playPropellerSound();
            }
        }
        if (!this.snail.isSnailFlying() && !this.snail.isSnailGliding() && !this.snail.isSnailLanding() && (double)this.snail.field_6250 > 0.001) {
            if (this.walkSoundCooldown > 0) {
                --this.walkSoundCooldown;
            }
            if (this.walkSoundCooldown == 0) {
                this.walkSoundCooldown = 22;
                this.playWalkSound();
            }
        }
        this.lastFlying = this.snail.isSnailFlying();
        this.lastGlidingOrLanding = this.snail.isSnailGliding() || this.snail.isSnailLanding();
    }

    public void playAttackSound() {
        this.forcePlayRandomSound("attack", 0.25f, 1, 9);
    }

    public void playBurnSound() {
        this.playRandomSound("burn", 0.25f, 1, 9);
    }

    public void playDrownSound() {
        this.playRandomSound("drown", 0.25f, 1, 9);
    }

    public void playFallSound() {
        this.playRandomSound("fall", 0.25f, 1, 5);
    }

    public void playFlySound() {
        this.playRandomSound("fly", 0.25f, 1, 8);
    }

    public void playPropellerSound() {
        this.forcePlayRandomSound("propeller", 0.2f, 0, 0);
    }

    public void playWalkSound() {
        this.forcePlayRandomSound("walk", 0.1f, 0, 0);
    }

    public void playLavaSound() {
        this.playRandomSound("lava", 0.25f, 1, 2);
    }

    public void playThrowSound() {
        this.playRandomSound("throw", 0.25f, 1, 7);
    }

    public void forcePlayRandomSound(String name, float volume, int from, int to) {
        int cooldownBefore = this.soundCooldown;
        this.soundCooldown = 0;
        this.playRandomSound(name, volume, from, to);
        this.soundCooldown = cooldownBefore;
    }

    public void playRandomSound(String name, float volume, int from, int to) {
        if (this.soundCooldown > 0) {
            return;
        }
        this.soundCooldown = 20;
        class_3414 sound = OtherUtils.getRandomSound("wildlife_snail_" + name, from, to);
        this.snail.method_5783(sound, volume, 1.0f);
    }
}

