/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;

@Environment(value=EnvType.CLIENT)
public abstract class TextFieldConfigEntry
extends ConfigEntry {
    protected final class_342 textField;
    private static final int DEFAULT_TEXT_FIELD_WIDTH = 100;
    protected static final int DEFAULT_TEXT_FIELD_HEIGHT = 18;
    private static final int TEXT_FIELD_OFFSET_X = -5;
    private static final int TEXT_FIELD_OFFSET_Y = 1;
    private int maxTextFieldLength = 8192;
    protected boolean clicked = false;

    public TextFieldConfigEntry(String fieldName, String displayName, String description) {
        this(fieldName, displayName, description, 100, 18);
    }

    public TextFieldConfigEntry(String fieldName, String displayName, String description, int textFieldWidth) {
        this(fieldName, displayName, description, textFieldWidth, 18);
    }

    public TextFieldConfigEntry(String fieldName, String displayName, String description, int textFieldWidth, int textFieldHeight) {
        super(fieldName, displayName, description);
        this.textField = new class_342(this.textRenderer, 0, 0, textFieldWidth, textFieldHeight, (class_2561)class_2561.method_43473());
        this.textField.method_1863(this::onChanged);
        this.textField.method_1880(this.maxTextFieldLength);
    }

    protected abstract void initializeTextField();

    private void onChanged(String text) {
        this.onTextChanged(text);
        this.postTextChanged();
    }

    protected void onTextChanged(String text) {
        if (text.length() >= this.maxTextFieldLength) {
            while (text.length() >= this.maxTextFieldLength && this.maxTextFieldLength < 1000000000) {
                this.maxTextFieldLength *= 2;
            }
            this.textField.method_1880(this.maxTextFieldLength);
        }
    }

    protected void postTextChanged() {
    }

    protected void renderAdditionalContent(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int entryWidth = this.getEntryContentWidth(width);
        this.renderAdditionalContent(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
        this.textField.method_46421(this.getTextFieldPosX(x, entryWidth));
        this.textField.method_46419(this.getTextFieldPosY(y, height));
        this.textField.method_25394(context, mouseX, mouseY, tickDelta);
        if (this.hasError()) {
            this.textField.method_1868(TextColors.PASTEL_RED);
        } else {
            this.textField.method_1868(TextColors.WHITE);
        }
    }

    protected int getTextFieldPosX(int x, int entryWidth) {
        return x + entryWidth - this.textField.method_25368() + -5;
    }

    protected int getTextFieldPosY(int y, int height) {
        return y + 1;
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.textField.method_25365(focused);
    }

    @Override
    protected boolean mouseClickedEntry(double mouseX, double mouseY, int button) {
        if (!this.textField.method_25402(mouseX, mouseY, button)) {
            this.clicked = !this.clicked;
        }
        return true;
    }

    @Override
    protected boolean keyPressedEntry(int keyCode, int scanCode, int modifiers) {
        return this.textField.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean charTypedEntry(char chr, int modifiers) {
        return this.textField.method_25400(chr, modifiers);
    }

    @Override
    public void resetToDefault() {
        this.setText(this.getDefaultValueAsString());
        if (!this.hasCustomErrors()) {
            this.clearError();
        }
    }

    public void setText(String text) {
        this.onTextChanged(text);
        this.postTextChanged();
        this.textField.method_1852(text);
    }

    public boolean hasCustomErrors() {
        return false;
    }

    @Override
    public boolean modified() {
        return !Objects.equals(this.textField.method_1882(), this.getStartingValueAsString());
    }

    @Override
    public boolean canReset() {
        return !Objects.equals(this.textField.method_1882(), this.getDefaultValueAsString());
    }
}

