/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.mixin.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.render.ClientRenderer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.minecraft.class_310;
import net.minecraft.class_8921;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class}, priority=1)
public abstract class MinecraftClientMixin {
    @Inject(method={"getTargetMillisPerTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTargetMillisPerTick(float millis, CallbackInfoReturnable<Float> cir) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            long timeSinceDilationActivate;
            class_8921 tickManager = client.field_1687.method_54719();
            if (MainClient.TIME_DILATION_TIMESTAMP != 0L && (timeSinceDilationActivate = System.currentTimeMillis() - MainClient.TIME_DILATION_TIMESTAMP) < 14000L) {
                if (timeSinceDilationActivate < 1000L) {
                    float tickRate = 1000.0f / (1.0f - (float)timeSinceDilationActivate / 4050.0f);
                    cir.setReturnValue((Object)Float.valueOf(tickRate));
                    ClientRenderer.isGameFullyFrozen = false;
                    return;
                }
                if (timeSinceDilationActivate <= 10000L) {
                    cir.setReturnValue((Object)Float.valueOf(500000.0f));
                    ClientRenderer.isGameFullyFrozen = true;
                    return;
                }
                float tickRate = 1000.0f / ((float)(timeSinceDilationActivate - 10000L) / 4050.0f);
                cir.setReturnValue((Object)Float.valueOf(tickRate));
                ClientRenderer.isGameFullyFrozen = false;
                return;
            }
            if (tickManager.method_54751()) {
                float mspt = Math.max(TimeDilation.MIN_PLAYER_MSPT, tickManager.method_54749());
                cir.setReturnValue((Object)Float.valueOf(mspt));
                ClientRenderer.isGameFullyFrozen = false;
                return;
            }
        }
        cir.setReturnValue((Object)Float.valueOf(millis));
        ClientRenderer.isGameFullyFrozen = false;
    }
}

