/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9262;

public class Task {
    public String rawTask;
    public TaskTypes type;
    public static boolean anyGreenPlayers = true;
    public static boolean anyYellowPlayers = true;

    public Task(String task, TaskTypes type) {
        this.rawTask = task;
        this.type = type;
    }

    public static void checkPlayerColors() {
        anyGreenPlayers = Main.currentSeason.anyGreenPlayers();
        anyYellowPlayers = Main.currentSeason.anyYellowPlayers();
    }

    public boolean isValid() {
        if (this.rawTask == null) {
            return false;
        }
        if (this.rawTask.isEmpty()) {
            return false;
        }
        if (this.rawTask.contains("${green/yellow}") && !anyGreenPlayers && !anyYellowPlayers) {
            return false;
        }
        if (this.rawTask.contains("${green}") && !anyGreenPlayers) {
            return false;
        }
        return !this.rawTask.contains("${yellow}") || anyYellowPlayers;
    }

    public List<class_9262<class_2561>> getBookLines() {
        ArrayList<class_9262<class_2561>> lines = new ArrayList<class_9262<class_2561>>();
        for (String page : this.rawTask.split("\\\\p")) {
            page = this.formatString(page);
            lines.add((class_9262<class_2561>)class_9262.method_57137((Object)class_2561.method_30163((String)page)));
        }
        return lines;
    }

    public String formatString(String page) {
        if (page.contains("${random_player}")) {
            ArrayList<class_3222> players = new ArrayList<class_3222>();
            for (class_3222 player : PlayerUtils.getAllPlayers()) {
                if (!Main.currentSeason.isAlive(player)) continue;
                players.add(player);
            }
            Collections.shuffle(players);
            page = page.replaceAll("\\$\\{random_player}", ((class_3222)players.getFirst()).method_5820());
        }
        if (page.contains("${green/yellow}")) {
            if (anyGreenPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "green");
            } else if (anyYellowPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "yellow");
            }
        }
        if (page.contains("${green}") && anyGreenPlayers) {
            page = page.replaceAll("\\$\\{green}", "green");
        }
        if (page.contains("${yellow}") && anyYellowPlayers) {
            page = page.replaceAll("\\$\\{yellow}", "yellow");
        }
        if (page.contains("${kill_not_permitted}") && anyYellowPlayers) {
            page = page.replaceAll("\\$\\{kill_not_permitted}", "");
        }
        return page;
    }

    public int getDifficulty() {
        if (this.type == TaskTypes.EASY) {
            return 1;
        }
        if (this.type == TaskTypes.HARD) {
            return 2;
        }
        if (this.type == TaskTypes.RED) {
            return 3;
        }
        return 0;
    }

    public boolean killPermitted() {
        if (this.type != TaskTypes.RED) {
            return false;
        }
        return !this.rawTask.contains("${kill_not_permitted}");
    }
}

