/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class UpdateChecker {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    public static boolean majorUpdateAvailable = false;
    public static boolean updateAvailable = false;
    public static String versionName;
    public static String versionDescription;
    public static int version;

    public static void checkForMajorUpdates() {
        executor.submit(() -> {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL("https://api.github.com/repos/Mat0u5/LifeSeries/releases/latest").openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    int updateVersionNumber;
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String name = json.get("tag_name").getAsString();
                    int currentVersionNumber = VersionControl.getModVersionInt("dev-1.3.6.10");
                    if (currentVersionNumber < (updateVersionNumber = VersionControl.getModVersionInt(name))) {
                        Main.LOGGER.info("New major version found: " + name);
                        updateAvailable = true;
                        majorUpdateAvailable = true;
                        versionName = name;
                        versionDescription = json.get("body").getAsString();
                        version = updateVersionNumber;
                    }
                } else {
                    Main.LOGGER.error("Failed to fetch update info: " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                Main.LOGGER.error("Error while checking for updates: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                UpdateChecker.checkForMinorUpdates();
            }
        });
    }

    public static void checkForMinorUpdates() {
        executor.submit(() -> {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL("https://api.github.com/repos/Mat0u5/LifeSeries/releases").openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonArray jsonList = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                    for (JsonElement jsonElement : jsonList.asList()) {
                        JsonObject json = jsonElement.getAsJsonObject();
                        String name = json.get("tag_name").getAsString();
                        if (name.contains("dev")) continue;
                        try {
                            int currentVersionNumber = VersionControl.getModVersionInt("dev-1.3.6.10");
                            int updateVersionNumber = VersionControl.getModVersionInt(name);
                            if (version >= updateVersionNumber || currentVersionNumber >= updateVersionNumber) continue;
                            Main.LOGGER.info("New minor version found: " + name);
                            updateAvailable = true;
                            versionName = name;
                            if (!majorUpdateAvailable) {
                                versionDescription = json.get("body").getAsString();
                            }
                            version = updateVersionNumber;
                        }
                        catch (Exception e) {
                            Main.LOGGER.error("Error while parsing version number for update: " + name + " - " + e.getMessage());
                        }
                    }
                } else {
                    Main.LOGGER.error("Failed to fetch update info: " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                Main.LOGGER.error("Error while checking for updates: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public static void onPlayerJoin(class_3222 player) {
        if (!updateAvailable || versionName == null) {
            return;
        }
        if (!VersionControl.isDevVersion()) {
            class_5250 discordText = class_2561.method_43470((String)"\u00a77Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.openURLClickEvent("https://discord.gg/QWJxfb4zQZ")).method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)"\u00a77 to join the mod development discord if you have any questions, issues, requests, or if you just want to hang out :)\n"));
            class_5250 updateText = class_2561.method_43470((String)("A new version of the Life Series Mod is available (" + versionName + ") \u00a7nserver-side\u00a7f. \n")).method_27694(style -> style.method_10949(TextUtils.showTextHoverEvent(class_2561.method_30163((String)("\u00a77\u00a7nUpdate Description:\u00a7r\n\n" + versionDescription))))).method_10852((class_2561)class_2561.method_43470((String)"Click to download on Modrinth").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.openURLClickEvent("https://modrinth.com/mod/life-series")).method_30938(Boolean.valueOf(true))));
            if (PermissionManager.isAdmin(player)) {
                player.method_64398((class_2561)updateText);
                player.method_64398((class_2561)discordText);
            }
        } else {
            class_5250 updateText = class_2561.method_43470((String)"\u00a7c[Life Series] You are playing on a developer version, there are probably some bugs, and it's possible that some features don't work.\n").method_10852((class_2561)class_2561.method_43470((String)"Download full releases on Modrinth").method_27694(style -> style.method_10977(class_124.field_1078).method_10958(TextUtils.openURLClickEvent("https://modrinth.com/mod/life-series")).method_30938(Boolean.valueOf(true))));
            player.method_64398((class_2561)updateText);
        }
    }

    public static void shutdownExecutor() {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

