/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.events;

import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.events.ClientKeybinds;
import net.mat0u5.lifeseries.features.SnailSkinsClient;
import net.mat0u5.lifeseries.gui.other.UpdateInfoScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.utils.ClientResourcePacks;
import net.mat0u5.lifeseries.utils.ClientTaskScheduler;
import net.mat0u5.lifeseries.utils.versions.UpdateChecker;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_634;
import net.minecraft.class_702;
import net.minecraft.class_746;
import net.minecraft.class_8113;
import net.minecraft.class_9381;

@Environment(value=EnvType.CLIENT)
public class ClientEvents {
    public static long onGroundFor = 0L;
    private static boolean hasShownUpdateScreen = false;
    private static int jumpedInAir = 0;
    private static int jumpCooldown = 0;
    private static boolean lastJumping = false;
    private static int invisibleSnailFor = 0;
    private static int invisibleTriviaSnailFor = 0;

    public static void registerClientEvents() {
        ClientPlayConnectionEvents.JOIN.register(ClientEvents::onClientJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientEvents::onClientDisconnect);
        ClientLifecycleEvents.CLIENT_STARTED.register(ClientEvents::onClientStart);
        ScreenEvents.AFTER_INIT.register(ClientEvents::onScreenOpen);
    }

    public static void onClientJoin(class_634 handler, PacketSender sender, class_310 client) {
    }

    public static void onClientDisconnect(class_634 handler, class_310 client) {
        Main.LOGGER.info("Client disconnected from server, clearing some client data.");
        MainClient.resetClientData();
    }

    public static void onScreenOpen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (UpdateChecker.updateAvailable && screen instanceof class_442 && !hasShownUpdateScreen) {
            client.execute(() -> {
                client.method_1507((class_437)new UpdateInfoScreen(UpdateChecker.versionName, UpdateChecker.versionDescription));
                hasShownUpdateScreen = true;
            });
        }
    }

    public static void onClientStart(class_310 client) {
    }

    public static void onClientTickEnd() {
        try {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            ClientEvents.checkResourcepackReload();
            ClientEvents.spawnInvisibilityParticles(client);
            if (player != null) {
                ClientEvents.sendPackets(player);
                ClientEvents.tryTripleJump(player);
                ClientEvents.checkSnailInvisible(client, player);
                ClientEvents.checkTriviaSnailInvisible(client, player);
                ClientEvents.checkOnGroundFor(player);
            }
            ClientKeybinds.tick();
            ClientTaskScheduler.onClientTick();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkOnGroundFor(class_746 player) {
        onGroundFor = !player.method_24828() ? 0L : ++onGroundFor;
    }

    public static void spawnInvisibilityParticles(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        if (client.field_1687.field_9229.method_43048(15) != 0) {
            return;
        }
        for (class_1657 player : client.field_1687.method_18456()) {
            long time;
            if (!MainClient.invisiblePlayers.containsKey(player.method_5667()) || (time = MainClient.invisiblePlayers.get(player.method_5667()).longValue()) <= System.currentTimeMillis() && time != -1L) continue;
            class_702 particleManager = client.field_1713;
            double x = player.method_23317() + (Math.random() - 0.5) * 0.6;
            double y = player.method_23318() + Math.random() * 1.8;
            double z = player.method_23321() + (Math.random() - 0.5) * 0.6;
            class_9381 invisibilityParticle = class_9381.method_58256((class_2396)class_2398.field_11226, (int)545821109);
            particleManager.method_3056((class_2394)invisibilityParticle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void sendPackets(class_746 player) {
        if (MainClient.clientCurrentSeason == Seasons.WILD_LIFE && MainClient.clientActiveWildcards.contains((Object)Wildcards.SIZE_SHIFTING) && player.field_3913.field_54155.comp_3163()) {
            NetworkHandlerClient.sendHoldingJumpPacket();
        }
    }

    public static void onClientJump(class_1297 entity) {
        if (entity instanceof class_746) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            jumpCooldown = 3;
        }
    }

    private static void tryTripleJump(class_746 player) {
        if (jumpCooldown > 0) {
            --jumpCooldown;
        }
        if (player.method_24828()) {
            jumpedInAir = 0;
            return;
        }
        if (jumpedInAir >= 2) {
            return;
        }
        boolean shouldJump = false;
        boolean holdingJump = player.field_3913.field_54155.comp_3163();
        if (!lastJumping && holdingJump) {
            shouldJump = true;
        }
        lastJumping = holdingJump;
        if (!shouldJump) {
            return;
        }
        if (jumpCooldown > 0) {
            return;
        }
        if (!ClientEvents.hasTripleJumpEffect(player)) {
            return;
        }
        ++jumpedInAir;
        player.method_6043();
        player.method_17356((class_3414)class_3417.field_49044.comp_349(), class_3419.field_15250, 0.25f, 1.0f);
        NetworkHandlerClient.sendStringPacket("triple_jump", "");
    }

    private static boolean hasTripleJumpEffect(class_746 player) {
        for (Map.Entry entry : player.method_6088().entrySet()) {
            class_1293 jumpBoost;
            if (entry.getKey() != class_1294.field_5913 || (jumpBoost = (class_1293)entry.getValue()).method_5578() != 2 || jumpBoost.method_5584() > 220 || jumpBoost.method_5584() < 200) continue;
            return true;
        }
        return false;
    }

    public static void checkSnailInvisible(class_310 client, class_746 player) {
        if (client.field_1687 == null) {
            return;
        }
        if (MainClient.snailPos == null) {
            return;
        }
        if (MainClient.snailPosTime == 0L) {
            return;
        }
        if (player.method_5707(MainClient.snailPos.method_46558()) > 2500.0) {
            return;
        }
        if (System.currentTimeMillis() - MainClient.snailPosTime > 2000L) {
            return;
        }
        if (invisibleSnailFor > 60) {
            invisibleSnailFor = 0;
            NetworkHandlerClient.sendStringPacket("reset_snail_model", "");
        }
        ArrayList<class_8113.class_8122> snailEntities = new ArrayList<class_8113.class_8122>();
        for (class_8113.class_8122 entity2 : client.field_1687.method_8390(class_8113.class_8122.class, new class_238(MainClient.snailPos).method_1014(10.0), entity -> true)) {
            if (!MainClient.snailPartUUIDs.contains(entity2.method_5667())) continue;
            snailEntities.add(entity2);
        }
        invisibleSnailFor = snailEntities.isEmpty() ? ++invisibleSnailFor : 0;
    }

    public static void checkTriviaSnailInvisible(class_310 client, class_746 player) {
        if (client.field_1687 == null) {
            return;
        }
        if (MainClient.triviaSnailPos == null) {
            return;
        }
        if (MainClient.triviaSnailPosTime == 0L) {
            return;
        }
        if (player.method_5707(MainClient.triviaSnailPos.method_46558()) > 2500.0) {
            return;
        }
        if (System.currentTimeMillis() - MainClient.triviaSnailPosTime > 2000L) {
            return;
        }
        if (invisibleTriviaSnailFor > 60) {
            invisibleTriviaSnailFor = 0;
            NetworkHandlerClient.sendStringPacket("reset_snail_model", "");
        }
        ArrayList<class_8113.class_8122> snailEntities = new ArrayList<class_8113.class_8122>();
        for (class_8113.class_8122 entity2 : client.field_1687.method_8390(class_8113.class_8122.class, new class_238(MainClient.triviaSnailPos).method_1014(10.0), entity -> true)) {
            if (!MainClient.triviaSnailPartUUIDs.contains(entity2.method_5667())) continue;
            snailEntities.add(entity2);
        }
        invisibleTriviaSnailFor = snailEntities.isEmpty() ? ++invisibleTriviaSnailFor : 0;
    }

    public static void checkResourcepackReload() {
        if (SnailSkinsClient.skinReloadTicks <= 0) {
            return;
        }
        if (--SnailSkinsClient.skinReloadTicks == 0) {
            ClientResourcePacks.enableClientResourcePack("file/[Life Series Mod] Snail Textures", true);
        }
    }
}

