/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.main;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.ButtonConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.interfaces.IEntryGroupHeader;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class BooleanConfigEntry
extends ButtonConfigEntry
implements IEntryGroupHeader {
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final String TEXT_TRUE = "\u00a7aYes";
    private static final String TEXT_FALSE = "\u00a7cNo";
    private final boolean defaultValue;
    protected boolean value;
    private boolean startingValue;

    public BooleanConfigEntry(String fieldName, String displayName, String description, boolean value, boolean defaultValue) {
        super(fieldName, displayName, description, 60, 20);
        this.defaultValue = defaultValue;
        this.value = value;
        this.startingValue = value;
        this.updateButtonText();
    }

    @Override
    protected void onButtonClick(class_4185 button) {
        this.value = !this.value;
        this.updateButtonText();
        this.markChanged();
    }

    @Override
    public class_2561 getButtonText() {
        return this.value ? class_2561.method_30163((String)TEXT_TRUE) : class_2561.method_30163((String)TEXT_FALSE);
    }

    @Override
    protected void resetToDefault() {
        this.value = this.defaultValue;
        this.updateButtonText();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            this.value = booleanValue;
            this.updateButtonText();
        }
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public Boolean getStartingValue() {
        return this.startingValue;
    }

    @Override
    public String getStartingValueAsString() {
        return String.valueOf(this.startingValue);
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.BOOLEAN;
    }

    @Override
    public void expand() {
    }

    @Override
    public boolean shouldExpand() {
        return this.getValue();
    }
}

