/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.seasons.blacklist.Blacklist;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.WorldUitls;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1550;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_2709;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_7260;
import net.minecraft.class_8646;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class Season {
    public static final String RESOURCEPACK_MAIN_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-main-a2267cdefcc227356dfa14261923a140cb4635e6/main.zip";
    public static final String RESOURCEPACK_MAIN_SHA = "328550e43f517a5ed26a0a9597c255d15783645e";
    public static final String RESOURCEPACK_SECRETLIFE_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-secretlife-4ef5fb2c497037dc9f18437ec8788eac5e01dbab/secretlife.zip";
    public static final String RESOURCEPACK_SECRETLIFE_SHA = "92a7c3dfc6641509de72a7c687a3707ba3843e6c";
    public static final String RESOURCEPACK_MINIMAL_ARMOR_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-minimal_armor-4ef5fb2c497037dc9f18437ec8788eac5e01dbab/minimal_armor.zip";
    public static final String RESOURCEPACK_MINIMAL_ARMOR_SHA = "d5e9e21ab788974ef3a58bd8b14ccc7d34ea422c";
    public boolean NO_HEALING = false;
    public boolean SHOW_DEATH_TITLE = false;
    public int GIVELIFE_MAX_LIVES = 99;
    public boolean TAB_LIST_SHOW_DEAD_PLAYERS = true;
    public boolean TAB_LIST_SHOW_LIVES = false;
    public boolean FINAL_DEATH_LIGHTNING = true;
    public class_3414 FINAL_DEATH_SOUND = class_3417.field_14865;
    public static boolean TAB_LIST_SHOW_EXACT_LIVES = false;
    public static boolean SHOW_HEALTH_BELOW_NAME = false;
    public boolean WATCHERS_IN_TAB = true;
    public boolean MUTE_DEAD_PLAYERS = false;
    public boolean WATCHERS_MUTED = false;
    public BoogeymanManager boogeymanManagerNew = this.createBoogeymanManager();
    private final HashMap<UUID, HashMap<class_243, List<Float>>> respawnPositions = new HashMap();

    public abstract Seasons getSeason();

    public abstract ConfigManager getConfig();

    public Blacklist createBlacklist() {
        return new Blacklist();
    }

    public BoogeymanManager createBoogeymanManager() {
        return new BoogeymanManager();
    }

    public void initialize() {
        this.reload();
    }

    public void updateStuff() {
        if (Main.server == null) {
            return;
        }
        OtherUtils.executeCommand("worldborder set " + String.valueOf(Main.seasonConfig.WORLDBORDER_SIZE.get(Main.seasonConfig)));
        ((class_1928.class_4310)Main.server.method_3767().method_20746(class_1928.field_19389)).method_20758(((Boolean)Main.seasonConfig.KEEP_INVENTORY.get(Main.seasonConfig)).booleanValue(), Main.server);
        ((class_1928.class_4310)Main.server.method_3767().method_20746(class_1928.field_19395)).method_20758(!this.NO_HEALING, Main.server);
        ((class_1928.class_4310)Main.server.method_3767().method_20746(class_1928.field_59751)).method_20758(((Boolean)Main.seasonConfig.LOCATOR_BAR.get(Main.seasonConfig)).booleanValue(), Main.server);
        class_266 currentListObjective = ScoreboardUtils.getObjectiveInSlot(class_8646.field_45156);
        if (this.TAB_LIST_SHOW_LIVES) {
            ScoreboardUtils.setObjectiveInSlot(class_8646.field_45156, "Lives");
        } else if (currentListObjective != null && currentListObjective.method_1113().equals("Lives")) {
            ScoreboardUtils.setObjectiveInSlot(class_8646.field_45156, null);
        }
        class_266 currentBelowNameObjective = ScoreboardUtils.getObjectiveInSlot(class_8646.field_45158);
        if (SHOW_HEALTH_BELOW_NAME) {
            ScoreboardUtils.setObjectiveInSlot(class_8646.field_45158, "HP");
        } else if (currentBelowNameObjective != null && currentBelowNameObjective.method_1113().equals("HP")) {
            ScoreboardUtils.setObjectiveInSlot(class_8646.field_45158, null);
        }
    }

    public void reload() {
        this.MUTE_DEAD_PLAYERS = (Boolean)Main.seasonConfig.MUTE_DEAD_PLAYERS.get(Main.seasonConfig);
        this.SHOW_DEATH_TITLE = (Boolean)Main.seasonConfig.FINAL_DEATH_TITLE_SHOW.get(Main.seasonConfig);
        this.GIVELIFE_MAX_LIVES = (Integer)Main.seasonConfig.GIVELIFE_LIVES_MAX.get(Main.seasonConfig);
        this.TAB_LIST_SHOW_LIVES = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_LIVES.get(Main.seasonConfig);
        this.TAB_LIST_SHOW_DEAD_PLAYERS = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_DEAD_PLAYERS.get(Main.seasonConfig);
        this.FINAL_DEATH_LIGHTNING = (Boolean)Main.seasonConfig.FINAL_DEATH_LIGHTNING.get(Main.seasonConfig);
        this.FINAL_DEATH_SOUND = class_3414.method_47908((class_2960)class_2960.method_60654((String)((String)Main.seasonConfig.FINAL_DEATH_SOUND.get(Main.seasonConfig))));
        TAB_LIST_SHOW_EXACT_LIVES = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_EXACT_LIVES.get(Main.seasonConfig);
        SHOW_HEALTH_BELOW_NAME = (Boolean)Main.seasonConfig.SHOW_HEALTH_BELOW_NAME.get(Main.seasonConfig);
        this.WATCHERS_IN_TAB = (Boolean)Main.seasonConfig.WATCHERS_IN_TAB.get(Main.seasonConfig);
        this.WATCHERS_MUTED = (Boolean)Main.seasonConfig.WATCHERS_MUTED.get(Main.seasonConfig);
        this.boogeymanManagerNew.onReload();
        this.createTeams();
        this.createScoreboards();
        this.updateStuff();
        this.reloadAllPlayerTeams();
        this.reloadPlayers();
        Events.updatePlayerListsNextTick = true;
        WatcherManager.reloadWatchers();
    }

    public void reloadPlayers() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            AttributeUtils.resetAttributesOnPlayerJoin(player);
        }
    }

    public void createTeams() {
        Collection<class_268> allTeams = TeamUtils.getAllTeams();
        if (allTeams != null) {
            for (class_268 team : allTeams) {
                if (!team.method_1197().startsWith("creaking_")) continue;
                TeamUtils.deleteTeam(team.method_1197());
            }
        }
        TeamUtils.createTeam("watcher", "Watcher", class_124.field_1063);
        TeamUtils.createTeam("lives_null", "Unassigned", class_124.field_1080);
        TeamUtils.createTeam("lives_0", "Dead", class_124.field_1063);
        TeamUtils.createTeam("lives_1", "Red", class_124.field_1061);
        TeamUtils.createTeam("lives_2", "Yellow", class_124.field_1054);
        TeamUtils.createTeam("lives_3", "Green", class_124.field_1060);
        TeamUtils.createTeam("lives_4", "Dark Green", class_124.field_1077);
    }

    public class_124 getColorForLives(Integer lives) {
        class_124 color;
        class_268 team = TeamUtils.getTeam(this.getTeamForLives(lives));
        if (team != null && (color = team.method_1202()) != null) {
            return color;
        }
        return class_124.field_1063;
    }

    public class_2561 getFormattedLives(class_3222 player) {
        return this.getFormattedLives(this.getPlayerLives(player));
    }

    public class_2561 getFormattedLives(@Nullable Integer lives) {
        if (lives == null) {
            lives = 0;
        }
        class_124 color = this.getColorForLives(lives);
        return class_2561.method_43470((String)String.valueOf(lives)).method_27692(color);
    }

    public void createScoreboards() {
        ScoreboardUtils.createObjective("Lives");
        ScoreboardUtils.createObjective("Watchers");
        ScoreboardUtils.createObjective("HP", "\u00a7c\u2764", class_274.field_1453);
    }

    public void reloadAllPlayerTeams() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            this.reloadPlayerTeam(player);
        }
    }

    public void reloadPlayerTeam(class_3222 player) {
        if (player == null) {
            return;
        }
        if (!player.method_29504()) {
            this.reloadPlayerTeamActual(player);
        } else {
            TaskScheduler.scheduleTask(2, () -> this.reloadPlayerTeamActual(player));
        }
    }

    public void reloadPlayerTeamActual(class_3222 player) {
        String team = this.getTeamForPlayer(player);
        TeamUtils.addEntityToTeam(team, (class_1297)player);
        if (Main.currentSeason.getSeason() == Seasons.WILD_LIFE) {
            WildLife.changedPlayerTeam(player);
        }
        Events.updatePlayerListsNextTick = true;
    }

    public String getTeamForPlayer(class_3222 player) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return "watcher";
        }
        Integer lives = this.getPlayerLives(player);
        return this.getTeamForLives(lives);
    }

    public String getTeamForLives(Integer lives) {
        String prefix = "lives_";
        String nullTeam = prefix + "null";
        if (lives == null) {
            return nullTeam;
        }
        ArrayList<Integer> livesTeams = new ArrayList<Integer>();
        Collection<class_268> allTeams = TeamUtils.getAllTeams();
        if (allTeams != null) {
            for (class_268 team : allTeams) {
                String name = team.method_1197();
                if (!name.startsWith(prefix)) continue;
                try {
                    int index = Integer.parseInt(name.replaceAll(prefix, ""));
                    if (index == lives) {
                        return name;
                    }
                    livesTeams.add(index);
                }
                catch (Exception exception) {}
            }
        }
        if (!livesTeams.isEmpty()) {
            Collections.sort(livesTeams);
            if (lives <= (Integer)livesTeams.getFirst()) {
                return prefix + String.valueOf(livesTeams.getFirst());
            }
            Collections.reverse(livesTeams);
            Iterator<Object> iterator = livesTeams.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (lives < i) continue;
                return prefix + i;
            }
        }
        return nullTeam;
    }

    @Nullable
    public Integer getPlayerLives(class_3222 player) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return null;
        }
        return ScoreboardUtils.getScore((class_9015)player, "Lives");
    }

    public boolean hasAssignedLives(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        return lives != null;
    }

    public boolean isAlive(class_3222 player) {
        Integer lives = this.getPlayerLives(player);
        if (lives == null) {
            return false;
        }
        if (!this.hasAssignedLives(player)) {
            return false;
        }
        return lives > 0;
    }

    public void removePlayerLife(class_3222 player) {
        this.addToPlayerLives(player, -1);
    }

    public void resetPlayerLife(class_3222 player) {
        ScoreboardUtils.resetScore((class_9015)player, "Lives");
        this.reloadPlayerTeam(player);
        this.onPlayerJoin(player);
        this.onPlayerFinishJoining(player);
    }

    public void resetAllPlayerLivesInner() {
        ScoreboardUtils.removeObjective("Lives");
        this.createScoreboards();
        Main.currentSeason.reloadAllPlayerTeams();
    }

    public void resetAllPlayerLives() {
        this.resetAllPlayerLivesInner();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            Main.currentSeason.onPlayerJoin(player);
            Main.currentSeason.onPlayerFinishJoining(player);
        }
    }

    public void addPlayerLife(class_3222 player) {
        this.addToPlayerLives(player, 1);
    }

    public void addToPlayerLives(class_3222 player, int amount) {
        int lives;
        Integer currentLives = this.getPlayerLives(player);
        if (currentLives == null) {
            currentLives = 0;
        }
        if ((lives = currentLives + amount) < 0 && !Necromancy.isRessurectedPlayer(player)) {
            lives = 0;
        }
        this.setPlayerLives(player, lives);
    }

    public void addToLifeNoUpdate(class_3222 player) {
        int lives;
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        Integer currentLives = this.getPlayerLives(player);
        if (currentLives == null) {
            currentLives = 0;
        }
        if ((lives = currentLives + 1) < 0) {
            lives = 0;
        }
        ScoreboardUtils.setScore(player, "Lives", lives);
    }

    public void receiveLifeFromOtherPlayer(class_2561 playerName, class_3222 target) {
        target.method_17356(class_3417.field_26980, class_3419.field_15250, 10.0f, 1.0f);
        if (((Boolean)Main.seasonConfig.GIVELIFE_BROADCAST.get(Main.seasonConfig)).booleanValue()) {
            PlayerUtils.broadcastMessageExcept((class_2561)TextUtils.format("{} received a life from {}", target, playerName), target);
        }
        target.method_64398((class_2561)TextUtils.format("You received a life from {}", playerName));
        PlayerUtils.sendTitleWithSubtitle(target, class_2561.method_30163((String)"You received a life"), (class_2561)TextUtils.format("from {}", playerName), 10, 60, 10);
        AnimationUtils.createSpiral(target, 175);
        Main.currentSeason.reloadPlayerTeam(target);
        SessionTranscript.givelife(playerName, target);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.syncSoulboundLives(target);
        }
    }

    public void setPlayerLives(class_3222 player, int lives) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        Integer livesBefore = this.getPlayerLives(player);
        ScoreboardUtils.setScore(player, "Lives", lives);
        if (lives <= 0) {
            this.playerLostAllLives(player, livesBefore);
        } else if (player.method_7325()) {
            player.method_7336(class_1934.field_9215);
        }
        this.reloadPlayerTeam(player);
    }

    @Nullable
    public Boolean isOnLastLife(class_3222 player) {
        return this.isOnSpecificLives(player, 1);
    }

    public boolean isOnLastLife(class_3222 player, boolean fallback) {
        Boolean isOnLastLife = this.isOnLastLife(player);
        if (isOnLastLife == null) {
            return fallback;
        }
        return isOnLastLife;
    }

    @Nullable
    public Boolean isOnSpecificLives(class_3222 player, int check) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = Main.currentSeason.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        return lives == check;
    }

    public boolean isOnSpecificLives(class_3222 player, int check, boolean fallback) {
        Boolean isOnLife = this.isOnSpecificLives(player, check);
        if (isOnLife == null) {
            return fallback;
        }
        return isOnLife;
    }

    @Nullable
    public Boolean isOnAtLeastLives(class_3222 player, int check) {
        if (!this.isAlive(player)) {
            return null;
        }
        Integer lives = Main.currentSeason.getPlayerLives(player);
        if (lives == null) {
            return null;
        }
        return lives >= check;
    }

    public boolean isOnAtLeastLives(class_3222 player, int check, boolean fallback) {
        Boolean isOnAtLeast = this.isOnAtLeastLives(player, check);
        if (isOnAtLeast == null) {
            return fallback;
        }
        return isOnAtLeast;
    }

    public void playerLostAllLives(class_3222 player, Integer livesBefore) {
        player.method_7336(class_1934.field_9219);
        class_243 pos = player.method_19538();
        HashMap<class_243, List<Float>> info = new HashMap<class_243, List<Float>>();
        info.put(pos, List.of(Float.valueOf(player.method_36454()), Float.valueOf(player.method_36455())));
        this.respawnPositions.put(player.method_5667(), info);
        this.dropItemsOnLastDeath(player);
        if (livesBefore != null && livesBefore > 0) {
            if (this.FINAL_DEATH_SOUND != null) {
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), this.FINAL_DEATH_SOUND);
            }
            if (this.FINAL_DEATH_LIGHTNING) {
                WorldUitls.summonHarmlessLightning(PlayerUtils.getServerWorld(player), player.method_19538());
            }
            this.showDeathTitle(player);
        }
        SessionTranscript.onPlayerLostAllLives(player);
        this.boogeymanManagerNew.playerLostAllLives(player);
    }

    public void dropItemsOnLastDeath(class_3222 player) {
        boolean doDrop = (Boolean)Main.seasonConfig.PLAYERS_DROP_ITEMS_ON_FINAL_DEATH.get(Main.seasonConfig);
        boolean keepInventory = player.method_5682().method_3767().method_8355(class_1928.field_19389);
        if (doDrop && keepInventory) {
            for (class_1799 item : PlayerUtils.getPlayerInventory(player)) {
                player.method_5775(PlayerUtils.getServerWorld(player), item);
            }
            player.method_31548().method_5448();
        }
    }

    public void showDeathTitle(class_3222 player) {
        if (this.SHOW_DEATH_TITLE) {
            String subtitle = (String)Main.seasonConfig.FINAL_DEATH_TITLE_SUBTITLE.get(Main.seasonConfig);
            PlayerUtils.sendTitleWithSubtitleToPlayers(PlayerUtils.getAllPlayers(), player.method_55423(), (class_2561)class_2561.method_43470((String)subtitle), 20, 80, 20);
        }
        PlayerUtils.broadcastMessage(this.getDeathMessage(player));
    }

    public class_2561 getDeathMessage(class_3222 player) {
        String message = (String)Main.seasonConfig.FINAL_DEATH_MESSAGE.get(Main.seasonConfig);
        if (message.contains("${player}")) {
            return TextUtils.format(message.replace("${player}", "{}"), player);
        }
        return class_2561.method_43470((String)message);
    }

    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim) {
        if (this.isOnLastLife(attacker, false)) {
            return true;
        }
        if (attacker.method_6124() == victim && this.isOnLastLife(victim, false)) {
            return true;
        }
        Boogeyman boogeymanAttacker = this.boogeymanManagerNew.getBoogeyman(attacker);
        Boogeyman boogeymanVictim = this.boogeymanManagerNew.getBoogeyman(victim);
        if (boogeymanAttacker != null && !boogeymanAttacker.cured) {
            return true;
        }
        return attacker.method_6124() == victim && boogeymanVictim != null && !boogeymanVictim.cured;
    }

    public List<class_3222> getNonRedPlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        if (players.isEmpty()) {
            return new ArrayList<class_3222>();
        }
        ArrayList<class_3222> nonRedPlayers = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            Boolean isOnLastLife = Main.currentSeason.isOnLastLife(player);
            if (isOnLastLife == null || isOnLastLife.booleanValue()) continue;
            nonRedPlayers.add(player);
        }
        return nonRedPlayers;
    }

    public List<class_3222> getAlivePlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        if (players.isEmpty()) {
            return new ArrayList<class_3222>();
        }
        ArrayList<class_3222> alivePlayers = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            if (!this.isAlive(player)) continue;
            alivePlayers.add(player);
        }
        return alivePlayers;
    }

    public List<class_3222> getDeadPlayers() {
        List<class_3222> players = PlayerUtils.getAllFunctioningPlayers();
        if (players.isEmpty()) {
            return new ArrayList<class_3222>();
        }
        ArrayList<class_3222> deadPlayers = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            if (this.isAlive(player)) continue;
            deadPlayers.add(player);
        }
        return deadPlayers;
    }

    public boolean anyGreenPlayers() {
        for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
            if (!this.isOnSpecificLives(player, 3, false)) continue;
            return true;
        }
        return false;
    }

    public boolean anyYellowPlayers() {
        for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
            if (!this.isOnSpecificLives(player, 2, false)) continue;
            return true;
        }
        return false;
    }

    public void sessionEnd() {
        this.boogeymanManagerNew.sessionEnd();
    }

    public boolean sessionStart() {
        this.boogeymanManagerNew.resetBoogeymen();
        Main.currentSession.activeActions.addAll(this.boogeymanManagerNew.getSessionActions());
        return true;
    }

    public void tick(MinecraftServer server) {
    }

    public void tickSessionOn(MinecraftServer server) {
    }

    public void onPlayerDeath(class_3222 player, class_1282 source) {
        boolean soulmateKill = source.method_48792().comp_1242().equalsIgnoreCase("soulmate");
        SessionTranscript.onPlayerDeath(player, source);
        boolean killedByPlayer = false;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 serverAttacker = (class_3222)class_12972;
            if (player != source.method_5529()) {
                if (!soulmateKill) {
                    this.onPlayerKilledByPlayer(player, serverAttacker);
                }
                killedByPlayer = true;
            }
        }
        if (player.method_6124() != null && !killedByPlayer && (class_12972 = player.method_6124()) instanceof class_3222) {
            class_3222 serverAdversary = (class_3222)class_12972;
            if (player != player.method_6124()) {
                if (!soulmateKill) {
                    this.onPlayerKilledByPlayer(player, serverAdversary);
                }
                killedByPlayer = true;
            }
        }
        if (!killedByPlayer) {
            this.onPlayerDiedNaturally(player);
        }
        this.removePlayerLife(player);
    }

    public void onPlayerDiedNaturally(class_3222 player) {
        if (Main.server == null) {
            return;
        }
        Main.currentSession.playerNaturalDeathLog.remove(player.method_5667());
        Main.currentSession.playerNaturalDeathLog.put(player.method_5667(), Main.server.method_3780());
    }

    public void onPlayerRespawn(class_3222 player) {
        if (!this.respawnPositions.containsKey(player.method_5667())) {
            return;
        }
        HashMap<class_243, List<Float>> info = this.respawnPositions.get(player.method_5667());
        this.respawnPositions.remove(player.method_5667());
        if (this.isAlive(player)) {
            return;
        }
        for (Map.Entry<class_243, List<Float>> entry : info.entrySet()) {
            class_243 pos = entry.getKey();
            if (pos.field_1351 <= (double)PlayerUtils.getServerWorld(player).method_31607()) continue;
            player.method_48105(PlayerUtils.getServerWorld(player), pos.field_1352, pos.field_1351, pos.field_1350, EnumSet.noneOf(class_2709.class), entry.getValue().get(0).floatValue(), entry.getValue().get(1).floatValue(), false);
            break;
        }
    }

    public void onClaimKill(class_3222 killer, class_3222 victim) {
        SessionTranscript.claimKill(killer, victim);
        Boogeyman boogeyman = this.boogeymanManagerNew.getBoogeyman(killer);
        if (boogeyman != null && !boogeyman.cured && !this.isOnLastLife(victim, true)) {
            this.boogeymanManagerNew.cure(killer);
        }
    }

    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
    }

    public void onPrePlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
    }

    public void onPlayerHeal(class_3222 player, float amount) {
    }

    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        if (this.isAllowedToAttack(killer, victim)) {
            Boogeyman boogeyman = this.boogeymanManagerNew.getBoogeyman(killer);
            if (boogeyman != null && !boogeyman.cured && !this.isOnLastLife(victim, true)) {
                this.boogeymanManagerNew.cure(killer);
            }
        } else {
            PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("\u00a7c [Unjustified Kill?] {}\u00a77 was killed by {}", victim, killer));
        }
    }

    public void onMobDeath(class_1309 entity, class_1282 damageSource) {
    }

    public void onEntityDropItems(class_1309 entity, class_1282 damageSource) {
        this.modifyEntityDrops(entity, damageSource);
    }

    public void modifyEntityDrops(class_1309 entity, class_1282 damageSource) {
        if (!entity.method_37908().method_8608() && damageSource.method_5529() instanceof class_3222) {
            this.spawnEggChance(entity);
        }
    }

    private void spawnEggChance(class_1309 entity) {
        double chance = (Double)Main.seasonConfig.SPAWN_EGG_DROP_CHANCE.get(Main.seasonConfig);
        boolean onlyNatural = (Boolean)Main.seasonConfig.SPAWN_EGG_DROP_ONLY_NATURAL.get(Main.seasonConfig);
        if (chance <= 0.0) {
            return;
        }
        if (entity instanceof class_1510) {
            return;
        }
        if (entity instanceof class_1528) {
            return;
        }
        if (entity instanceof class_7260) {
            return;
        }
        if (entity instanceof class_1550) {
            return;
        }
        if (entity instanceof Snail) {
            return;
        }
        if (entity instanceof TriviaBot) {
            return;
        }
        if (entity.method_5752().contains("notNatural") && onlyNatural) {
            return;
        }
        class_1299 entityType = entity.method_5864();
        class_1826 spawnEgg = class_1826.method_8019((class_1299)entityType);
        if (spawnEgg == null) {
            return;
        }
        class_1799 spawnEggItem = spawnEgg.method_7854();
        if (spawnEggItem == null) {
            return;
        }
        if (spawnEggItem.method_7960()) {
            return;
        }
        if (Math.random() <= chance) {
            entity.method_5775((class_3218)entity.method_37908(), spawnEggItem);
        }
    }

    public void learnRecipes() {
        OtherUtils.executeCommand("recipe give @a lifeseries:name_tag_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:saddle_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:spawner_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:tnt_recipe_variation");
        OtherUtils.executeCommand("recipe give @a lifeseries:bundle_recipe");
    }

    public void onPlayerJoin(class_3222 player) {
        AttributeUtils.resetAttributesOnPlayerJoin(player);
        this.reloadPlayerTeam(player);
        TaskScheduler.scheduleTask(2, () -> PlayerUtils.applyResourcepack(player.method_5667()));
    }

    public void onPlayerFinishJoining(class_3222 player) {
        this.learnRecipes();
        if (Main.currentSession.statusNotStarted() && PermissionManager.isAdmin(player)) {
            player.method_64398(class_2561.method_30163((String)"\nUse \u00a7b'/session timer set <time>'\u00a7f to set the desired session time."));
            player.method_64398(class_2561.method_30163((String)"After that, use \u00a7b'/session start'\u00a7f to start the session."));
        }
        this.boogeymanManagerNew.onPlayerFinishJoining(player);
    }

    public void onPlayerDisconnect(class_3222 player) {
    }

    public void onRightClickEntity(class_3222 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
    }

    public void onAttackEntity(class_3222 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
    }
}

