/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.doublelife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class DoubleLifeCommands {
    public static boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.DOUBLE_LIFE;
    }

    public static boolean checkBanned(class_2168 source) {
        if (DoubleLifeCommands.isAllowed()) {
            return false;
        }
        source.method_9213(class_2561.method_30163((String)"This command is only available when playing Double Life."));
        return true;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"soulmate").requires(source -> PermissionManager.isAdmin(source.method_44023()) || source.method_9228() == null)).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> DoubleLifeCommands.getSoulmate((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"soulmate", (ArgumentType)class_2186.method_9305()).executes(context -> DoubleLifeCommands.setSoulmate((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2186.method_9315((CommandContext)context, (String)"soulmate"))))))).then(class_2170.method_9247((String)"list").executes(context -> DoubleLifeCommands.listSoulmates((class_2168)context.getSource())))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> DoubleLifeCommands.resetSoulmate((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"resetAll").executes(context -> DoubleLifeCommands.resetAllSoulmates((class_2168)context.getSource())))).then(class_2170.method_9247((String)"rollRandom").executes(context -> DoubleLifeCommands.rollSoulmates((class_2168)context.getSource()))));
    }

    public static int setSoulmate(class_2168 source, class_3222 player, class_3222 soulmate) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (player == null) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        if (season.hasSoulmate(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} already has a soulmate", player));
            return -1;
        }
        if (season.hasSoulmate(soulmate)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} already has a soulmate", player));
            return -1;
        }
        season.setSoulmate(player, soulmate);
        season.saveSoulmates();
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate is now {}", player, soulmate));
        return 1;
    }

    public static int getSoulmate(class_2168 source, class_3222 player) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (player == null) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        if (!season.hasSoulmate(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} does not have a soulmate", player));
            return -1;
        }
        if (!season.isSoulmateOnline(player)) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} 's soulmate is not online right now", player));
            return -1;
        }
        class_3222 soulmate = season.getSoulmate(player);
        if (soulmate == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate is {}", player, soulmate));
        return 1;
    }

    public static int resetSoulmate(class_2168 source, Collection<class_3222> players) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        if (players == null) {
            return -1;
        }
        if (players.isEmpty()) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        ArrayList<class_3222> affected = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            if (!season.hasSoulmate(player)) continue;
            season.resetSoulmate(player);
            season.saveSoulmates();
            affected.add(player);
        }
        if (affected.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"No target was found"));
            return -1;
        }
        if (affected.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{}'s soulmate was reset", affected.getFirst()));
            return 1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Soulmate was reset for {} targets", affected.size()));
        return 1;
    }

    public static int resetAllSoulmates(class_2168 source) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        season.resetAllSoulmates();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"All soulmate entries were reset"));
        return 1;
    }

    public static int listSoulmates(class_2168 source) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        boolean noSoulmates = true;
        for (Map.Entry<UUID, UUID> entry : season.soulmatesOrdered.entrySet()) {
            noSoulmates = false;
            UUID text1 = entry.getKey();
            UUID text2 = entry.getValue();
            class_3222 player = PlayerUtils.getPlayer(entry.getKey());
            class_3222 soulmate = PlayerUtils.getPlayer(entry.getValue());
            if (player != null) {
                text1 = player;
            }
            if (soulmate != null) {
                text2 = soulmate;
            }
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s soulmate is {}", text1, text2));
        }
        if (noSoulmates) {
            source.method_9213(class_2561.method_30163((String)"There are no soulmates currently assigned"));
        }
        return 1;
    }

    public static int rollSoulmates(class_2168 source) {
        if (DoubleLifeCommands.checkBanned(source)) {
            return -1;
        }
        DoubleLife season = (DoubleLife)Main.currentSeason;
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Rolling soulmates..."));
        season.rollSoulmates();
        return 1;
    }
}

