/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.Main;

@Environment(value=EnvType.CLIENT)
public class ClientTaskScheduler {
    private static final List<Task> tasks = new ArrayList<Task>();
    private static final List<Task> newTasks = new ArrayList<Task>();

    public static void scheduleTask(int tickNumber, Runnable goal) {
        if (Main.modDisabled()) {
            return;
        }
        Task task = new Task(tickNumber, goal);
        newTasks.add(task);
    }

    public static void schedulePriorityTask(int tickNumber, Runnable goal) {
        Task task = new Task(tickNumber, goal);
        task.priority = true;
        newTasks.add(task);
    }

    public static void onClientTick() {
        try {
            Iterator<Task> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next();
                --task.tickCount;
                if (task.tickCount > 0) continue;
                try {
                    if (!Main.modDisabled() || task.priority) {
                        task.goal.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                iterator.remove();
            }
            tasks.addAll(newTasks);
            newTasks.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Task {
        private int tickCount;
        private final Runnable goal;
        public boolean priority = false;

        public Task(int tickCount, Runnable goal) {
            this.tickCount = tickCount;
            this.goal = goal;
        }
    }
}

