/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ClientConfigNetwork;
import net.mat0u5.lifeseries.config.entries.BooleanObject;
import net.mat0u5.lifeseries.config.entries.ConfigObject;
import net.mat0u5.lifeseries.config.entries.DoubleObject;
import net.mat0u5.lifeseries.config.entries.IntegerObject;
import net.mat0u5.lifeseries.config.entries.StringObject;
import net.mat0u5.lifeseries.config.entries.TextObject;
import net.mat0u5.lifeseries.gui.config.ConfigScreen;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.GroupConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.NumberConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.BlockListConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.BoogeymanConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.EffectListConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.EnchantListConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.HeartsConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.ItemListConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.PercentageConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.StringListConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.time.MinutesConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.extra.time.SecondsConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.BooleanConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.DoubleConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.IntegerConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.StringConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.TextConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.interfaces.IEntryGroupHeader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ClientConfigGuiManager {
    public static void openConfig() {
        ConfigScreen.Builder builder = new ConfigScreen.Builder(class_310.method_1551().field_1755, class_2561.method_30163((String)"Life Series Config"));
        if (!ClientConfigNetwork.configObjects.isEmpty()) {
            ConfigScreen.Builder.CategoryBuilder categoryGeneral = builder.addCategory("Server");
            ClientConfigGuiManager.addConfig(categoryGeneral, ClientConfigNetwork.configObjects);
        }
        ConfigScreen.Builder.CategoryBuilder categoryClient = builder.addCategory("Client");
        ClientConfigGuiManager.addConfig(categoryClient, ClientConfigNetwork.clientConfigObjects);
        ClientConfigGuiManager.addTestingCategory(builder);
        class_310.method_1551().method_1507((class_437)builder.build());
    }

    public static void addConfig(ConfigScreen.Builder.CategoryBuilder category, Map<Integer, ConfigObject> allConfigObjects) {
        if (allConfigObjects.isEmpty()) {
            return;
        }
        HashMap groupEntries = new HashMap();
        HashMap<String, String> groupModifiers = new HashMap<String, String>();
        for (Map.Entry<Integer, ConfigObject> entry : allConfigObjects.entrySet()) {
            ConfigObject configObject = entry.getValue();
            String groupInfo = configObject.getGroupInfo();
            ConfigEntry configEntry = ClientConfigGuiManager.handleConfigObject(configObject);
            if (configEntry == null) {
                Main.LOGGER.error("Config entry is null");
                continue;
            }
            if (groupInfo.contains("[new]")) {
                groupInfo = groupInfo.replace("[new]", "");
                configEntry.setNew();
            }
            if (groupInfo.startsWith("{") && groupInfo.contains("}")) {
                GroupConfigEntry<?> groupEntry;
                String groupPath = groupInfo.substring(1);
                String[] split = groupPath.split("}");
                groupPath = split[0];
                if (split.length >= 2) {
                    groupModifiers.put(groupPath, split[1]);
                }
                if ((groupEntry = ClientConfigGuiManager.createGroupEntry(configEntry, (String)groupModifiers.get(groupPath))) == null) continue;
                groupEntries.put(groupPath, groupEntry);
                ClientConfigGuiManager.addToParentOrCategory(groupPath, groupEntry, groupEntries, category);
                continue;
            }
            if (groupInfo.isEmpty()) {
                category.addEntry(configEntry);
                continue;
            }
            ClientConfigGuiManager.addToGroup(groupInfo, configEntry, groupEntries, category);
        }
    }

    private static void addToParentOrCategory(String groupPath, GroupConfigEntry<?> groupEntry, Map<String, GroupConfigEntry<?>> groupEntries, ConfigScreen.Builder.CategoryBuilder category) {
        int lastDotIndex = groupPath.lastIndexOf(46);
        if (lastDotIndex != -1) {
            String parentPath = groupPath.substring(0, lastDotIndex);
            GroupConfigEntry<?> parentGroup = groupEntries.get(parentPath);
            if (parentGroup != null) {
                parentGroup.addChildEntry(groupEntry);
            } else {
                category.addEntry(groupEntry);
            }
        } else {
            category.addEntry(groupEntry);
        }
    }

    private static void addToGroup(String groupInfo, ConfigEntry configEntry, Map<String, GroupConfigEntry<?>> groupEntries, ConfigScreen.Builder.CategoryBuilder category) {
        GroupConfigEntry<?> targetGroup = groupEntries.get(groupInfo);
        if (targetGroup != null) {
            targetGroup.addChildEntry(configEntry);
        } else {
            category.addEntry(configEntry);
        }
    }

    private static GroupConfigEntry<?> createGroupEntry(ConfigEntry configEntry, String modifier) {
        if (!(configEntry instanceof IEntryGroupHeader)) {
            Main.LOGGER.error("Warning: Group entry does not implement IEntryGroupHeader");
            return null;
        }
        boolean showSidebar = true;
        boolean openByDefault = false;
        if (modifier != null) {
            if (modifier.contains("no_sidebar")) {
                showSidebar = false;
            }
            if (modifier.contains("closed")) {
                openByDefault = false;
            }
            if (modifier.contains("open")) {
                openByDefault = true;
            }
        }
        if (configEntry instanceof TextConfigEntry) {
            TextConfigEntry textConfigEntry = (TextConfigEntry)configEntry;
            return new GroupConfigEntry<TextConfigEntry>(textConfigEntry, new ArrayList<ConfigEntry>(), showSidebar, openByDefault);
        }
        if (configEntry instanceof BooleanConfigEntry) {
            BooleanConfigEntry booleanConfigEntry = (BooleanConfigEntry)configEntry;
            return new GroupConfigEntry<BooleanConfigEntry>(booleanConfigEntry, new ArrayList<ConfigEntry>(), showSidebar, openByDefault);
        }
        if (configEntry instanceof NumberConfigEntry) {
            NumberConfigEntry numberConfigEntry = (NumberConfigEntry)configEntry;
            return new GroupConfigEntry<NumberConfigEntry>(numberConfigEntry, new ArrayList<ConfigEntry>(), showSidebar, openByDefault);
        }
        return null;
    }

    public static ConfigEntry handleConfigObject(ConfigObject object) {
        if (object instanceof BooleanObject) {
            BooleanObject booleanObject = (BooleanObject)object;
            if (booleanObject.configType == ConfigTypes.BOOGEYMAN) {
                return new BoogeymanConfigEntry(booleanObject.id, booleanObject.name, booleanObject.description, booleanObject.booleanValue, booleanObject.defaultValue);
            }
            return new BooleanConfigEntry(booleanObject.id, booleanObject.name, booleanObject.description, booleanObject.booleanValue, booleanObject.defaultValue);
        }
        if (object instanceof StringObject) {
            ArrayList<String> args;
            StringObject stringObject = (StringObject)object;
            if (stringObject.configType == ConfigTypes.ITEM_LIST) {
                return new ItemListConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue);
            }
            if (stringObject.configType == ConfigTypes.BLOCK_LIST) {
                return new BlockListConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue);
            }
            if (stringObject.configType == ConfigTypes.EFFECT_LIST) {
                return new EffectListConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue);
            }
            if (stringObject.configType == ConfigTypes.ENCHANT_LIST) {
                return new EnchantListConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue);
            }
            if (stringObject.configType == ConfigTypes.STRING_LIST && (args = new ArrayList<String>(stringObject.args)).size() >= 3) {
                args.removeFirst();
                args.removeFirst();
                args.removeFirst();
                return new StringListConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue, args);
            }
            return new StringConfigEntry(stringObject.id, stringObject.name, stringObject.description, stringObject.stringValue, stringObject.defaultValue);
        }
        if (object instanceof IntegerObject) {
            IntegerObject intObject = (IntegerObject)object;
            if (intObject.configType == ConfigTypes.HEARTS) {
                return new HeartsConfigEntry(intObject.id, intObject.name, intObject.description, intObject.integerValue, intObject.defaultValue);
            }
            if (intObject.configType == ConfigTypes.SECONDS) {
                return new SecondsConfigEntry(intObject.id, intObject.name, intObject.description, intObject.integerValue, intObject.defaultValue);
            }
            return new IntegerConfigEntry(intObject.id, intObject.name, intObject.description, intObject.integerValue, intObject.defaultValue);
        }
        if (object instanceof DoubleObject) {
            DoubleObject doubleObject = (DoubleObject)object;
            if (doubleObject.configType == ConfigTypes.PERCENTAGE) {
                return new PercentageConfigEntry(doubleObject.id, doubleObject.name, doubleObject.description, doubleObject.doubleValue, doubleObject.defaultValue);
            }
            if (doubleObject.configType == ConfigTypes.MINUTES) {
                return new MinutesConfigEntry(doubleObject.id, doubleObject.name, doubleObject.description, doubleObject.doubleValue, doubleObject.defaultValue);
            }
            return new DoubleConfigEntry(doubleObject.id, doubleObject.name, doubleObject.description, doubleObject.doubleValue, doubleObject.defaultValue);
        }
        if (object instanceof TextObject) {
            TextObject textObject = (TextObject)object;
            return new TextConfigEntry(textObject.id, textObject.name, textObject.description, textObject.clickable);
        }
        return null;
    }

    public static void addTestingCategory(ConfigScreen.Builder builder) {
        ConfigScreen.Builder.CategoryBuilder category = builder.addCategory("Testing");
        category.addEntry(new TextConfigEntry("", "Test", ""));
        category.addEntry(new PercentageConfigEntry("id2", "Percentage", "description2", 0.5, 0.5));
        category.addEntry(new HeartsConfigEntry("id3", "Hearts", "description3", 20, 20));
    }
}

