/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.voicechat;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.PlayerConnectedEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Listening;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.mat0u5.lifeseries.voicechat.soundeffects.RadioEffect;
import net.mat0u5.lifeseries.voicechat.soundeffects.RoboticVoice;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class VoicechatMain
implements VoicechatPlugin {
    private static List<UUID> connectedPlayers = new ArrayList<UUID>();
    private OpusEncoder encoder;
    private OpusDecoder decoder;

    public String getPluginId() {
        return "lifeseries";
    }

    public void initialize(VoicechatApi api) {
        Main.LOGGER.info("Life Series Voice Chat plugin initialized!");
        this.encoder = api.createEncoder();
        this.decoder = api.createDecoder();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onAudioPacket);
        registration.registerEvent(PlayerConnectedEvent.class, this::onPlayerConnected);
    }

    private void onPlayerConnected(PlayerConnectedEvent event) {
        UUID uuid = event.getConnection().getPlayer().getUuid();
        if (!connectedPlayers.contains(uuid)) {
            connectedPlayers.add(uuid);
        }
    }

    public static boolean isConnectedToSVC(UUID uuid) {
        return connectedPlayers.contains(uuid);
    }

    private void onAudioPacket(MicrophonePacketEvent event) {
        this.roboticVoice(event);
        this.listeningPower(event);
    }

    private void roboticVoice(MicrophonePacketEvent event) {
        if (Main.currentSeason.getSeason() != Seasons.WILD_LIFE) {
            return;
        }
        if (!WildcardManager.isActiveWildcard(Wildcards.TRIVIA)) {
            return;
        }
        try {
            VoicechatConnection connection = event.getSenderConnection();
            if (connection == null) {
                return;
            }
            UUID senderUUID = connection.getPlayer().getUuid();
            if (!TriviaBot.cursedRoboticVoicePlayers.contains(senderUUID)) {
                return;
            }
            byte[] opusData = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
            byte[] processedOpusData = this.processOpusAudioForRobot(senderUUID, opusData);
            ((MicrophonePacket)event.getPacket()).setOpusEncodedData(processedOpusData);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error processing audio", (Throwable)e);
        }
    }

    private void listeningPower(MicrophonePacketEvent event) {
        if (Main.currentSeason.getSeason() != Seasons.WILD_LIFE) {
            return;
        }
        if (Listening.listeningPlayers.isEmpty()) {
            return;
        }
        MicrophonePacket voicePacket = (MicrophonePacket)event.getPacket();
        VoicechatConnection connection = event.getSenderConnection();
        if (connection == null) {
            return;
        }
        UUID senderUUID = connection.getPlayer().getUuid();
        Position senderPosition = connection.getPlayer().getPosition();
        VoicechatServerApi api = event.getVoicechat();
        for (UUID uuid : Listening.listeningPlayers) {
            double scaled;
            double maxDistance;
            class_243 senderPos;
            double distanceFromSound;
            Superpower superpower;
            if (uuid == senderUUID) continue;
            VoicechatConnection playerConnection = api.getConnectionOf(uuid);
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (playerConnection == null || player == null) continue;
            class_243 lookingAt = null;
            if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.LISTENING) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Listening) {
                Listening listeningPower = (Listening)superpower;
                lookingAt = listeningPower.lookingAt;
            }
            if (lookingAt == null || api.getBroadcastRange() == 0.0 || (distanceFromSound = (senderPos = new class_243(senderPosition.getX(), senderPosition.getY(), senderPosition.getZ())).method_1022(lookingAt)) > (maxDistance = Math.min(api.getBroadcastRange(), 20.0)) || distanceFromSound * (scaled = api.getBroadcastRange() / 20.0) > WorldUtils.getEntityPos((class_1297)player).method_1022(senderPos)) continue;
            byte[] processedAudio = this.processOpusAudioForRadio((byte[])voicePacket.getOpusEncodedData().clone());
            LocationalSoundPacket processedPacket = (LocationalSoundPacket)((LocationalSoundPacket.Builder)voicePacket.locationalSoundPacketBuilder().position(api.createPosition(player.method_23317(), player.method_23318() + distanceFromSound * scaled, player.method_23321())).distance((float)api.getBroadcastRange()).opusEncodedData(processedAudio)).build();
            api.sendLocationalSoundPacketTo(playerConnection, processedPacket);
        }
    }

    private byte[] processOpusAudioForRadio(byte[] opusData) {
        try {
            short[] pcmData = this.decoder.decode(opusData);
            if (pcmData == null) {
                Main.LOGGER.warn("Failed to decode Opus data");
                return opusData;
            }
            short[] processedPcm = RadioEffect.applyEffect(pcmData);
            return this.encoder.encode(processedPcm);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error processing Opus audio", (Throwable)e);
            return opusData;
        }
    }

    private byte[] processOpusAudioForRobot(UUID uuid, byte[] opusData) {
        try {
            short[] pcmData = this.decoder.decode(opusData);
            if (pcmData == null) {
                Main.LOGGER.warn("Failed to decode Opus data");
                return opusData;
            }
            short[] processedPcm = RoboticVoice.applyEffect(uuid, pcmData);
            return this.encoder.encode(processedPcm);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error processing Opus audio", (Throwable)e);
            return opusData;
        }
    }
}

