/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services.curseforge;

import com.google.gson.reflect.TypeToken;
import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.gui.data.Colors;
import dev.dediamondpro.resourcify.libs.elementa.font.DefaultFonts;
import dev.dediamondpro.resourcify.libs.minemark.elementa.style.MarkdownStyle;
import dev.dediamondpro.resourcify.libs.minemark.elementa.style.MarkdownTextStyle;
import dev.dediamondpro.resourcify.libs.minemark.style.HeadingLevelStyleConfig;
import dev.dediamondpro.resourcify.libs.minemark.style.HeadingStyleConfig;
import dev.dediamondpro.resourcify.libs.minemark.style.ImageStyleConfig;
import dev.dediamondpro.resourcify.libs.minemark.style.LinkStyleConfig;
import dev.dediamondpro.resourcify.platform.Platform;
import dev.dediamondpro.resourcify.services.IProject;
import dev.dediamondpro.resourcify.services.ISearchData;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.IVersion;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.ads.IAdProvider;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeCategory;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeCategoryResponse;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeFingerprint;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeFingerprintMatch;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeFingerprintMatchResult;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeFingerprintResponse;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeMinecraftVersions;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeMinecraftVersionsResponse;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeModsBatch;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeModsBatchResponse;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeProject;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeSearchData;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeVersion;
import dev.dediamondpro.resourcify.util.ConfirmingBrowserProvider;
import dev.dediamondpro.resourcify.util.JsonUtil;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.MurmurHash2;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.SanitizingImageProvider;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJM\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00170\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0003J5\u0010\u001c\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00170\u00170\u00162\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u0017\u0010!\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J!\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u0004\u0018\u00010\u0011*\u00020\u0007H\u0002\u00a2\u0006\u0004\b&\u0010'J)\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#0\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016\u00a2\u0006\u0004\b)\u0010*J9\u0010.\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010-0\u00170\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b.\u0010/J\u001b\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b7\u00106R$\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u000e\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u00109R$\u0010\u0010\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u000e\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u00109\u00a8\u0006;"}, d2={"Ldev/dediamondpro/resourcify/services/curseforge/CurseForgeService;", "Ldev/dediamondpro/resourcify/services/IService;", "<init>", "()V", "", "getName", "()Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/ProjectType;", "type", "", "isProjectTypeSupported", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Z", "query", "sortBy", "", "minecraftVersions", "categories", "", "offset", "Ldev/dediamondpro/resourcify/services/ISearchData;", "search", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILdev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/ISearchData;", "Ljava/util/concurrent/CompletableFuture;", "", "getMinecraftVersions", "()Ljava/util/concurrent/CompletableFuture;", "", "fetchMinecraftVersions", "getCategories", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "fetchCategories", "Ljava/net/URI;", "uri", "canFetchProjectUrl", "(Ljava/net/URI;)Z", "Ldev/dediamondpro/resourcify/services/IProject;", "fetchProjectFromUrl", "(Ljava/net/URI;)Ljava/util/concurrent/CompletableFuture;", "getClassId", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/lang/Integer;", "ids", "getProjectsFromIds", "(Ljava/util/List;)Ljava/util/Map;", "Ljava/io/File;", "files", "Ldev/dediamondpro/resourcify/services/IVersion;", "getUpdates", "(Ljava/util/List;Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "getSortOptions", "()Ljava/util/Map;", "Ldev/dediamondpro/resourcify/libs/minemark/elementa/style/MarkdownStyle;", "getMarkdownStyle", "()Ldev/dediamondpro/resourcify/libs/minemark/elementa/style/MarkdownStyle;", "API", "Ljava/lang/String;", "API_KEY", "Ldev/dediamondpro/resourcify/services/curseforge/CurseForgeMinecraftVersions;", "Ljava/util/concurrent/CompletableFuture;", "Ldev/dediamondpro/resourcify/services/curseforge/CurseForgeCategory;", "Resourcify (1.21.1-fabric)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nCurseForgeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurseForgeService.kt\ndev/dediamondpro/resourcify/services/curseforge/CurseForgeService\n+ 2 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtilKt\n+ 3 JsonUtil.kt\ndev/dediamondpro/resourcify/util/JsonUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,260:1\n178#2,5:261\n259#2,5:278\n237#2,4:283\n241#2,3:289\n244#2,2:294\n246#2,11:297\n178#2,5:323\n178#2,5:340\n178#2,5:347\n259#2,5:372\n237#2,4:377\n241#2,3:383\n244#2,2:388\n246#2,11:391\n35#3,2:266\n40#3,2:287\n35#3,2:308\n35#3,2:328\n35#3,2:345\n35#3,2:352\n40#3,2:381\n35#3,2:402\n774#4:268\n865#4:269\n1755#4,3:270\n866#4:273\n1557#4:274\n1628#4,3:275\n1202#4,2:310\n1230#4,2:312\n230#4,2:314\n1233#4:316\n1187#4,2:317\n1261#4,4:319\n774#4:330\n865#4,2:331\n1053#4:333\n1187#4,2:334\n1261#4,4:336\n1062#4:354\n1202#4,2:355\n1230#4,4:357\n1557#4:368\n1628#4,3:369\n774#4:404\n865#4,2:405\n1062#4:407\n295#4,2:408\n1755#4,3:410\n216#5,2:292\n216#5,2:386\n1#6:296\n1#6:390\n487#7,7:361\n*S KotlinDebug\n*F\n+ 1 CurseForgeService.kt\ndev/dediamondpro/resourcify/services/curseforge/CurseForgeService\n*L\n75#1:261,5\n154#1:278,5\n154#1:283,4\n154#1:289,3\n154#1:294,2\n154#1:297,11\n94#1:323,5\n124#1:340,5\n198#1:347,5\n174#1:372,5\n174#1:377,4\n174#1:383,3\n174#1:388,2\n174#1:391,11\n75#1:266,2\n154#1:287,2\n154#1:308,2\n94#1:328,2\n124#1:345,2\n198#1:352,2\n174#1:381,2\n174#1:402,2\n78#1:268\n78#1:269\n78#1:270,3\n78#1:273\n155#1:274\n155#1:275,3\n156#1:310,2\n156#1:312,2\n156#1:314,2\n156#1:316\n86#1:317,2\n86#1:319,4\n107#1:330\n107#1:331,2\n109#1:333\n112#1:334,2\n112#1:336,4\n199#1:354\n163#1:355,2\n163#1:357,4\n175#1:368\n175#1:369,3\n177#1:404\n177#1:405,2\n186#1:407\n188#1:408,2\n191#1:410,3\n154#1:292,2\n174#1:386,2\n154#1:296\n174#1:390\n171#1:361,7\n*E\n"})
public final class CurseForgeService
implements IService {
    @NotNull
    public static final CurseForgeService INSTANCE = new CurseForgeService();
    @NotNull
    public static final String API = "https://api.curseforge.com/v1";
    @NotNull
    public static final String API_KEY = "$2a$10$7rGm5tkZjhmJr70sf0zIK.RK5iSPBlFuPAUCF7hbogBtrykSMihtS";
    @Nullable
    private static CompletableFuture<List<CurseForgeMinecraftVersions>> minecraftVersions;
    @Nullable
    private static CompletableFuture<List<CurseForgeCategory>> categories;

    private CurseForgeService() {
    }

    @Override
    @NotNull
    public String getName() {
        return "CurseForge";
    }

    @Override
    public boolean isProjectTypeSupported(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return this.getClassId(type2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ISearchData search(@NotNull String query, @NotNull String sortBy2, @NotNull List<String> minecraftVersions, @NotNull List<String> categories, int offset2, @NotNull ProjectType type2) {
        URI uRI;
        block9: {
            Object object;
            Object $this$fromJson$iv$iv;
            void $this$getJson_u24default$iv;
            URIBuilder uRIBuilder;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)sortBy2, (String)"sortBy");
            Intrinsics.checkNotNullParameter(minecraftVersions, (String)"minecraftVersions");
            Intrinsics.checkNotNullParameter(categories, (String)"categories");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            URIBuilder $this$search_u24lambda_u241 = uRIBuilder = new URIBuilder("https://api.curseforge.com/v1/mods/search");
            boolean bl = false;
            $this$search_u24lambda_u241.addParameter("searchFilter", query);
            $this$search_u24lambda_u241.addParameter("gameId", "432");
            $this$search_u24lambda_u241.addParameter("pageSize", "20");
            $this$search_u24lambda_u241.addParameter("sortField", sortBy2);
            $this$search_u24lambda_u241.addParameter("sortOrder", "desc");
            $this$search_u24lambda_u241.addParameter("index", String.valueOf(offset2));
            $this$search_u24lambda_u241.addParameter("classId", String.valueOf(INSTANCE.getClassId(type2)));
            List actualCategories = CollectionsKt.toMutableList((Collection)categories);
            if (type2 == ProjectType.DATA_PACK) {
                actualCategories.add("5193");
            }
            $this$search_u24lambda_u241.addParameter("categoryIds", "[" + CollectionsKt.joinToString$default((Iterable)actualCategories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]");
            $this$search_u24lambda_u241.addParameter("gameVersions", "[" + CollectionsKt.joinToString$default((Iterable)minecraftVersions, (CharSequence)",", null, null, (int)0, null, CurseForgeService::search$lambda$1$lambda$0, (int)30, null) + "]");
            URI uRI2 = uRIBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"build(...)");
            uRI = uRI2;
            Map headers$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
            boolean useCache$iv = true;
            int attempts$iv = 3;
            boolean $i$f$getJson = false;
            String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
            if (string != null) {
                $this$fromJson$iv$iv = string;
                boolean $i$f$fromJson = false;
                Type type$iv$iv = new TypeToken<CurseForgeSearchData>(){}.getType();
                object = JsonUtil.INSTANCE.getGson().fromJson((String)$this$fromJson$iv$iv, type$iv$iv);
            } else {
                object = null;
            }
            uRI = object;
            CurseForgeSearchData $this$search_u24lambda_u245 = (CurseForgeSearchData)((Object)uRI);
            boolean bl2 = false;
            CurseForgeSearchData curseForgeSearchData = $this$search_u24lambda_u245;
            if (curseForgeSearchData == null) break block9;
            CurseForgeSearchData it = curseForgeSearchData;
            boolean bl3 = false;
            if (type2 == ProjectType.RESOURCE_PACK) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                $this$fromJson$iv$iv = $this$search_u24lambda_u245.getProjects();
                CurseForgeSearchData curseForgeSearchData2 = $this$search_u24lambda_u245;
                boolean $i$f$filter = false;
                void var15_22 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl4;
                    block8: {
                        CurseForgeProject it2 = (CurseForgeProject)element$iv$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv = it2.getInternalCategories();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                CurseForgeProject.Category c = (CurseForgeProject.Category)element$iv;
                                boolean bl6 = false;
                                if (!(c.getId() == 5193)) continue;
                                bl4 = true;
                                break block8;
                            }
                            bl4 = false;
                        }
                    }
                    if (!(!bl4)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                curseForgeSearchData2.setProjects((List)destination$iv$iv);
            }
        }
        return (ISearchData)((Object)uRI);
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, String>> getMinecraftVersions() {
        this.fetchMinecraftVersions();
        CompletionStage<Object> completionStage = minecraftVersions;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> CurseForgeService.getMinecraftVersions$lambda$8(CurseForgeService::getMinecraftVersions$lambda$7, arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(CurseForgeService::getMinecraftVersions$lambda$9);
        }
        return completionStage;
    }

    private final void fetchMinecraftVersions() {
        if (minecraftVersions != null) {
            CompletableFuture<List<CurseForgeMinecraftVersions>> completableFuture = minecraftVersions;
            boolean bl = completableFuture != null ? !completableFuture.isCompletedExceptionally() : false;
            if (bl) {
                return;
            }
        }
        minecraftVersions = MultiThreadingKt.supplyAsync(CurseForgeService::fetchMinecraftVersions$lambda$10);
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, Map<String, String>>> getCategories(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.fetchCategories();
        CompletionStage<Object> completionStage = categories;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> CurseForgeService.getCategories$lambda$15(arg_0 -> CurseForgeService.getCategories$lambda$14(type2, arg_0), arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(CurseForgeService::getCategories$lambda$16);
        }
        return completionStage;
    }

    private final void fetchCategories() {
        if (categories != null) {
            CompletableFuture<List<CurseForgeCategory>> completableFuture = categories;
            boolean bl = completableFuture != null ? !completableFuture.isCompletedExceptionally() : false;
            if (bl) {
                return;
            }
        }
        categories = MultiThreadingKt.supplyAsync(CurseForgeService::fetchCategories$lambda$17);
    }

    @Override
    public boolean canFetchProjectUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return false;
    }

    @Override
    @Nullable
    public CompletableFuture<IProject> fetchProjectFromUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return null;
    }

    private final Integer getClassId(ProjectType $this$getClassId) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getClassId.ordinal()]) {
            case 1 -> 12;
            case 2 -> 12;
            case 3 -> 6552;
            case 4 -> 6552;
            case 5 -> 17;
            default -> null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, IProject> getProjectsFromIds(@NotNull List<String> ids) {
        Map destination$iv$iv;
        Object object;
        Object $this$fromJson$iv$iv;
        Object object2;
        Object $i$f$forEach232;
        Object object3;
        block25: {
            void $this$postAndGetJson_u24default$iv;
            Map $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            object3 = NetworkUtilKt.toURI("https://api.curseforge.com/v1/mods");
            Object $this$map$iv = ids;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Integer.parseInt((String)it));
            }
            List list = (List)destination$iv$iv2;
            $this$map$iv = new CurseForgeModsBatch(list);
            $this$mapTo$iv$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
            int attempts$iv = 3;
            boolean $i$f$postAndGetJson = false;
            void $this$postAndGetString$iv$iv = $this$postAndGetJson_u24default$iv;
            boolean $i$f$postAndGetString = false;
            for (int i$iv$iv = 0; i$iv$iv < attempts$iv; ++i$iv$iv) {
                block24: {
                    try {
                        Object result$iv$iv;
                        Object object4;
                        void headers$iv;
                        String output$iv$iv;
                        void data$iv;
                        URL uRL = $this$postAndGetString$iv$iv.toURL();
                        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                        HttpsURLConnection con$iv$iv = NetworkUtilKt.setupConnection(uRL);
                        void $this$toJson$iv$iv$iv = data$iv;
                        boolean $i$f$toJson = false;
                        Object type$iv$iv$iv = new TypeToken<CurseForgeModsBatch>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)JsonUtil.INSTANCE.getGson().toJson((Object)$this$toJson$iv$iv$iv, (Type)type$iv$iv$iv), (String)"toJson(...)");
                        con$iv$iv.setRequestProperty("Content-Type", "application/json");
                        con$iv$iv.setRequestProperty("Content-Length", String.valueOf(output$iv$iv.length()));
                        Closeable $this$forEach$iv$iv$iv = headers$iv;
                        boolean $i$f$forEach232 = false;
                        for (Map.Entry entry : $this$forEach$iv$iv$iv.entrySet()) {
                            object4 = entry;
                            boolean bl2 = false;
                            String key$iv$iv = (String)object4.getKey();
                            String value$iv$iv = (String)object4.getValue();
                            con$iv$iv.setRequestProperty(key$iv$iv, value$iv$iv);
                        }
                        con$iv$iv.setDoOutput(true);
                        OutputStream outputStream = con$iv$iv.getOutputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                        $this$forEach$iv$iv$iv = outputStream;
                        $i$f$forEach232 = Charsets.UTF_8;
                        type$iv$iv$iv = new OutputStreamWriter((OutputStream)$this$forEach$iv$iv$iv, (Charset)$i$f$forEach232);
                        int n = 8192;
                        $this$forEach$iv$iv$iv = type$iv$iv$iv instanceof BufferedWriter ? (BufferedWriter)type$iv$iv$iv : new BufferedWriter((Writer)type$iv$iv$iv, n);
                        $i$f$forEach232 = null;
                        try {
                            BufferedWriter it$iv$iv = (BufferedWriter)$this$forEach$iv$iv$iv;
                            boolean bl = false;
                            it$iv$iv.write(output$iv$iv);
                            it$iv$iv = Unit.INSTANCE;
                        }
                        catch (Throwable it$iv$iv) {
                            $i$f$forEach232 = it$iv$iv;
                            throw it$iv$iv;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$this$forEach$iv$iv$iv, (Throwable)$i$f$forEach232);
                        }
                        if (NetworkUtilKt.getEncodedInputStream(con$iv$iv) != null) {
                            InputStream inputStream;
                            object4 = Charsets.UTF_8;
                            Reader bl2 = new InputStreamReader(inputStream, (Charset)object4);
                            int key$iv$iv = 8192;
                            Closeable closeable = bl2 instanceof BufferedReader ? (BufferedReader)bl2 : new BufferedReader(bl2, key$iv$iv);
                            object4 = null;
                            try {
                                Object it$iv$iv = (BufferedReader)closeable;
                                boolean bl3 = false;
                                it$iv$iv = TextStreamsKt.readText((Reader)((Reader)it$iv$iv));
                                v2 = it$iv$iv;
                            }
                            catch (Throwable it$iv$iv) {
                                object4 = it$iv$iv;
                                throw it$iv$iv;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
                            }
                        } else {
                            v2 = result$iv$iv = null;
                        }
                        if (result$iv$iv == null) break block24;
                        object2 = result$iv$iv;
                        break block25;
                    }
                    catch (Exception e$iv$iv) {
                        Constants.INSTANCE.getLOGGER().error("Failed to post and get string from \"" + (URI)$this$postAndGetString$iv$iv + "\"", (Throwable)e$iv$iv);
                    }
                }
                Thread.sleep(250L);
            }
            object2 = null;
        }
        if (object2 != null) {
            $this$fromJson$iv$iv = object2;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<CurseForgeModsBatchResponse>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        CurseForgeModsBatchResponse curseForgeModsBatchResponse = (CurseForgeModsBatchResponse)object;
        if (curseForgeModsBatchResponse != null && (object3 = curseForgeModsBatchResponse.getData()) != null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable attempts$iv = (Iterable)object3;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            $this$fromJson$iv$iv = $this$associateBy$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Object element$iv22;
                Map map2;
                block26: {
                    $i$f$forEach232 = (CurseForgeProject)element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$first$iv = ids;
                    boolean bl2 = false;
                    for (Object element$iv22 : $this$first$iv) {
                        void project;
                        String it = (String)element$iv22;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)project.getId())) continue;
                        break block26;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                map2.put((String)element$iv22, element$iv$iv);
            }
        } else {
            throw new IllegalStateException("Failed to fetch mods.".toString());
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<File, IVersion>> getUpdates(@NotNull List<? extends File> files, @NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return MultiThreadingKt.supplyAsync(() -> CurseForgeService.getUpdates$lambda$32(files));
    }

    @Override
    @NotNull
    public Map<String, String> getSortOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"1", (Object)"resourcify.browse.sort.relevance"), TuplesKt.to((Object)"6", (Object)"resourcify.browse.sort.downloads"), TuplesKt.to((Object)"11", (Object)"resourcify.browse.sort.newest"), TuplesKt.to((Object)"3", (Object)"resourcify.browse.sort.updated")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public MarkdownStyle getMarkdownStyle() {
        MarkdownTextStyle markdownTextStyle = new MarkdownTextStyle(1.0f, Colors.INSTANCE.getTEXT_PRIMARY(), 2.0f, DefaultFonts.getVANILLA_FONT_RENDERER(), null, 16, null);
        ImageStyleConfig imageStyleConfig = new ImageStyleConfig(SanitizingImageProvider.INSTANCE);
        LinkStyleConfig linkStyleConfig = new LinkStyleConfig(Colors.INSTANCE.getTEXT_LINK(), ConfirmingBrowserProvider.INSTANCE);
        HeadingStyleConfig headingStyleConfig = new HeadingStyleConfig(new HeadingLevelStyleConfig(2.0f, 12.0f), new HeadingLevelStyleConfig(1.66f, 10.0f), new HeadingLevelStyleConfig(1.33f, 8.0f), new HeadingLevelStyleConfig(1.0f, 4.0f), new HeadingLevelStyleConfig(1.0f, 4.0f), new HeadingLevelStyleConfig(1.0f, 4.0f));
        return new MarkdownStyle(markdownTextStyle, null, linkStyleConfig, headingStyleConfig, null, imageStyleConfig, null, null, null, null, 978, null);
    }

    @Override
    public boolean canSelectMultipleMinecraftVersions() {
        return IService.DefaultImpls.canSelectMultipleMinecraftVersions(this);
    }

    @Override
    @NotNull
    public IAdProvider getAdProvider() {
        return IService.DefaultImpls.getAdProvider(this);
    }

    private static final CharSequence search$lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getMinecraftVersions$lambda$7(List it) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$associate$iv = it;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            CurseForgeMinecraftVersions version = (CurseForgeMinecraftVersions)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)version.getName(), (Object)version.getName());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Map getMinecraftVersions$lambda$8(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getMinecraftVersions$lambda$9() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchMinecraftVersions$lambda$10() {
        Object object;
        void useCache$iv;
        void $this$getJson_u24default$iv;
        Object object2 = NetworkUtilKt.toURI("https://api.curseforge.com/v1/minecraft/version");
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
        URI uRI = object2;
        boolean bl = false;
        int attempts$iv = 3;
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, (boolean)useCache$iv, attempts$iv, map2);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<CurseForgeMinecraftVersionsResponse>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        CurseForgeMinecraftVersionsResponse curseForgeMinecraftVersionsResponse = (CurseForgeMinecraftVersionsResponse)object;
        if (curseForgeMinecraftVersionsResponse == null || (object2 = curseForgeMinecraftVersionsResponse.getData()) == null) {
            throw new IllegalStateException("Failed to fetch Minecraft versions.".toString());
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getCategories$lambda$14(ProjectType $type, List it) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Integer classId = INSTANCE.getClassId($type);
        String string = UtilsKt.localizeExtension("resourcify.categories.categories", new Object[0]);
        Intrinsics.checkNotNull((Object)it);
        Iterable iterable = it;
        String string2 = string;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CurseForgeCategory category = (CurseForgeCategory)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)category.getClassId(), (Object)classId) && category.getId() != 5193)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Object object;
                String string;
                Regex regex;
                Object object2;
                CurseForgeCategory category = (CurseForgeCategory)a;
                boolean bl = false;
                CharSequence charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object2 = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object2 = String.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                category = (CurseForgeCategory)b;
                Comparable comparable = (Comparable)object2;
                bl = false;
                charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object = String.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)object));
            }
        });
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            CurseForgeCategory category = (CurseForgeCategory)element$iv$iv;
            boolean bl = false;
            String string3 = String.valueOf(category.getId());
            String string4 = category.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string3, (Object)UtilsKt.localizeOrDefaultExtension("resourcify.categories." + StringsKt.replace$default((String)string4, (String)" ", (String)"_", (boolean)false, (int)4, null), UtilsKt.capitalizeAll(category.getName()), new Object[0]));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, (Object)destination$iv$iv2));
    }

    private static final Map getCategories$lambda$15(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getCategories$lambda$16() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchCategories$lambda$17() {
        Object object;
        void useCache$iv;
        void $this$getJson_u24default$iv;
        Object object2 = NetworkUtilKt.toURI("https://api.curseforge.com/v1/categories?gameId=432");
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
        URI uRI = object2;
        boolean bl = false;
        int attempts$iv = 3;
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, (boolean)useCache$iv, attempts$iv, map2);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<CurseForgeCategoryResponse>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        CurseForgeCategoryResponse curseForgeCategoryResponse = (CurseForgeCategoryResponse)object;
        if (curseForgeCategoryResponse == null || (object2 = curseForgeCategoryResponse.getData()) == null) {
            throw new IllegalStateException("Failed to fetch categories.".toString());
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private static final CurseForgeVersion getUpdates$lambda$32$lambda$29(CurseForgeFingerprintMatch $match, String $mcVersion) {
        CurseForgeVersion curseForgeVersion;
        block6: {
            block5: {
                void $this$sortedByDescending$iv;
                Object object;
                void $this$getJson_u24default$iv;
                URI uRI = new URIBuilder("https://api.curseforge.com/v1/mods/" + $match.getId() + "/files").addParameter("gameVersion", $mcVersion).addParameter("pageSize", "1").build();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
                Object object2 = uRI;
                Map headers$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
                boolean useCache$iv = true;
                int attempts$iv22 = 3;
                boolean $i$f$getJson = false;
                String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, useCache$iv, attempts$iv22, headers$iv);
                if (string != null) {
                    String $this$fromJson$iv$iv = string;
                    boolean $i$f$fromJson = false;
                    Type type$iv$iv = new TypeToken<CurseForgeProject.Versions>(){}.getType();
                    object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
                } else {
                    object = null;
                }
                CurseForgeProject.Versions versions = (CurseForgeProject.Versions)object;
                if (versions == null || (object2 = versions.getData()) == null) break block5;
                Iterable attempts$iv22 = (Iterable)object2;
                boolean $i$f$sortedByDescending = false;
                List list = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CurseForgeVersion it = (CurseForgeVersion)b;
                        boolean bl = false;
                        Comparable comparable = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(it.getReleaseDate()));
                        it = (CurseForgeVersion)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Instant.from(DateTimeFormatter.ISO_INSTANT.parse(it.getReleaseDate())));
                    }
                });
                if (list != null && (curseForgeVersion = (CurseForgeVersion)CollectionsKt.firstOrNull((List)list)) != null) break block6;
            }
            throw new IllegalStateException("Failed to find matching version".toString());
        }
        return curseForgeVersion;
    }

    private static final CurseForgeVersion getUpdates$lambda$32$lambda$30(CurseForgeVersion $fileCandidate) {
        return $fileCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map getUpdates$lambda$32(List $files) {
        Collection destination$iv$iv;
        Object object;
        String $this$fromJson$iv$iv;
        String string;
        Iterable headers$iv;
        List<CurseForgeFingerprintMatch> data$iv;
        Object $this$postAndGetJson_u24default$iv;
        String mcVersion;
        Map hashes;
        Object result$iv;
        block38: {
            Map $this$mapTo$iv$iv;
            URI $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = $files;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator = $this$associateByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long l;
                void it;
                Object element$iv$iv = iterator.next();
                File file = (File)element$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl2 = false;
                if (it.length() >= 0x20000000L) {
                    l = null;
                } else {
                    byte[] bytes = FilesKt.readBytes((File)it);
                    l = MurmurHash2.cfHash(bytes, bytes.length);
                }
                map2.put(l, element$iv$iv);
            }
            Map $this$filterKeys$iv = destination$iv$iv2;
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                Long it = (Long)entry$iv.getKey();
                boolean bl = false;
                if (!(it != null)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            hashes = (Map)result$iv;
            mcVersion = Platform.INSTANCE.getMcVersion();
            $this$associateByTo$iv$iv = NetworkUtilKt.toURI("https://api.curseforge.com/v1/fingerprints/432");
            Object $this$map$iv = hashes.keySet();
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl2 = $this$mapTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                void it;
                Object item$iv$iv = bl2.next();
                Long l = (Long)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl3 = false;
                void v1 = it;
                Intrinsics.checkNotNull((Object)v1);
                collection.add(v1.longValue());
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
            $this$map$iv = new CurseForgeFingerprint(list);
            $this$mapTo$iv$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)API_KEY));
            int attempts$iv = 3;
            boolean $i$f$postAndGetJson = false;
            void $this$postAndGetString$iv$iv = $this$postAndGetJson_u24default$iv;
            boolean $i$f$postAndGetString = false;
            for (int i$iv$iv = 0; i$iv$iv < attempts$iv; ++i$iv$iv) {
                block37: {
                    try {
                        String result$iv$iv;
                        Object object2;
                        String output$iv$iv;
                        URL uRL = $this$postAndGetString$iv$iv.toURL();
                        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                        HttpsURLConnection con$iv$iv = NetworkUtilKt.setupConnection(uRL);
                        void $this$toJson$iv$iv$iv = data$iv;
                        boolean $i$f$toJson = false;
                        Object type$iv$iv$iv = new TypeToken<CurseForgeFingerprint>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)JsonUtil.INSTANCE.getGson().toJson((Object)$this$toJson$iv$iv$iv, (Type)type$iv$iv$iv), (String)"toJson(...)");
                        con$iv$iv.setRequestProperty("Content-Type", "application/json");
                        con$iv$iv.setRequestProperty("Content-Length", String.valueOf(output$iv$iv.length()));
                        Object $this$forEach$iv$iv$iv = headers$iv;
                        boolean $i$f$forEach232 = false;
                        for (Map.Entry entry : $this$forEach$iv$iv$iv.entrySet()) {
                            object2 = entry;
                            boolean bl4 = false;
                            String key$iv$iv = (String)object2.getKey();
                            String value$iv$iv = (String)object2.getValue();
                            con$iv$iv.setRequestProperty(key$iv$iv, value$iv$iv);
                        }
                        con$iv$iv.setDoOutput(true);
                        OutputStream outputStream = con$iv$iv.getOutputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                        $this$forEach$iv$iv$iv = outputStream;
                        Object $i$f$forEach232 = Charsets.UTF_8;
                        type$iv$iv$iv = new OutputStreamWriter((OutputStream)$this$forEach$iv$iv$iv, (Charset)$i$f$forEach232);
                        int n = 8192;
                        $this$forEach$iv$iv$iv = type$iv$iv$iv instanceof BufferedWriter ? (BufferedWriter)type$iv$iv$iv : new BufferedWriter((Writer)type$iv$iv$iv, n);
                        $i$f$forEach232 = null;
                        try {
                            BufferedWriter it$iv$iv = (BufferedWriter)$this$forEach$iv$iv$iv;
                            boolean closeable = false;
                            it$iv$iv.write(output$iv$iv);
                            it$iv$iv = Unit.INSTANCE;
                        }
                        catch (Throwable it$iv$iv) {
                            $i$f$forEach232 = it$iv$iv;
                            throw it$iv$iv;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$this$forEach$iv$iv$iv, (Throwable)$i$f$forEach232);
                        }
                        if (NetworkUtilKt.getEncodedInputStream(con$iv$iv) != null) {
                            InputStream inputStream;
                            object2 = Charsets.UTF_8;
                            Reader bl4 = new InputStreamReader(inputStream, (Charset)object2);
                            int key$iv$iv = 8192;
                            Closeable closeable = bl4 instanceof BufferedReader ? (BufferedReader)bl4 : new BufferedReader(bl4, key$iv$iv);
                            object2 = null;
                            try {
                                BufferedReader it$iv$iv = (BufferedReader)closeable;
                                boolean bl6 = false;
                                String string2 = TextStreamsKt.readText((Reader)it$iv$iv);
                                v4 = string2;
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                            }
                        } else {
                            v4 = result$iv$iv = null;
                        }
                        if (result$iv$iv == null) break block37;
                        string = result$iv$iv;
                        break block38;
                    }
                    catch (Exception e$iv$iv) {
                        Constants.INSTANCE.getLOGGER().error("Failed to post and get string from \"" + (URI)$this$postAndGetString$iv$iv + "\"", (Throwable)e$iv$iv);
                    }
                }
                Thread.sleep(250L);
            }
            string = null;
        }
        if (string != null) {
            $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<CurseForgeFingerprintResponse>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        result$iv = (CurseForgeFingerprintResponse)object;
        if (result$iv != null && ($this$postAndGetJson_u24default$iv = ((CurseForgeFingerprintResponse)result$iv).getData()) != null && (data$iv = ((CurseForgeFingerprintMatchResult)$this$postAndGetJson_u24default$iv).getExactMatches()) != null) {
            Iterator $this$filterTo$iv$iv;
            void $this$filter$iv;
            headers$iv = data$iv;
            boolean $i$f$filter = false;
            $this$fromJson$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator e$iv$iv = $this$filterTo$iv$iv.iterator();
            while (e$iv$iv.hasNext()) {
                Object element$iv$iv = e$iv$iv.next();
                CurseForgeFingerprintMatch it = (CurseForgeFingerprintMatch)element$iv$iv;
                boolean bl = false;
                if (!(hashes.containsKey(it.getFile().getFileFingerprint()) && it.getFile().hasDownloadUrl())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            throw new IllegalStateException("Failed to fetch updates".toString());
        }
        List result = (List)destination$iv$iv;
        Map fileFutures = new LinkedHashMap();
        for (CurseForgeFingerprintMatch match : result) {
            Object v7;
            block39: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedByDescending$iv = match.getLatestFiles();
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CurseForgeVersion it = (CurseForgeVersion)b;
                        boolean bl = false;
                        Comparable comparable = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(it.getReleaseDate()));
                        it = (CurseForgeVersion)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Instant.from(DateTimeFormatter.ISO_INSTANT.parse(it.getReleaseDate())));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CurseForgeVersion file = (CurseForgeVersion)element$iv;
                    boolean bl = false;
                    if (!file.getMinecraftVersions().contains(mcVersion)) continue;
                    v7 = element$iv;
                    break block39;
                }
                v7 = null;
            }
            CurseForgeVersion fileCandidate = v7;
            if (fileCandidate == null) {
                boolean bl;
                block40: {
                    Iterable $this$any$iv = match.getLatestFiles();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CurseForgeVersion it = (CurseForgeVersion)element$iv;
                            boolean bl7 = false;
                            if (!(it.getFileFingerprint() == match.getFile().getFileFingerprint())) continue;
                            bl = true;
                            break block40;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    fileFutures.put(match, MultiThreadingKt.supplyAsync(() -> CurseForgeService.getUpdates$lambda$32$lambda$29(match, mcVersion)));
                    continue;
                }
            }
            fileFutures.put(match, MultiThreadingKt.supply(() -> CurseForgeService.getUpdates$lambda$32$lambda$30(fileCandidate)));
        }
        Map updates = new LinkedHashMap();
        for (Map.Entry entry : fileFutures.entrySet()) {
            CurseForgeFingerprintMatch match = (CurseForgeFingerprintMatch)entry.getKey();
            CompletableFuture future = (CompletableFuture)entry.getValue();
            try {
                Object v;
                CurseForgeVersion file;
                CurseForgeVersion curseForgeVersion = file = (CurseForgeVersion)future.get();
                if ((curseForgeVersion != null ? !curseForgeVersion.hasDownloadUrl() : false) || file != null && match.getFile().getFileFingerprint() != file.getFileFingerprint() && hashes.containsKey(file.getFileFingerprint())) continue;
                Map map3 = updates;
                Intrinsics.checkNotNull(hashes.get(match.getFile().getFileFingerprint()));
                CurseForgeVersion it = file;
                boolean bl = false;
                CurseForgeVersion curseForgeVersion2 = (it != null ? match.getFile().getFileFingerprint() == it.getFileFingerprint() : false) ? null : it;
                map3.put(v, curseForgeVersion2);
            }
            catch (Exception exception) {}
        }
        return updates;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            try {
                nArray[ProjectType.RESOURCE_PACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.DATA_PACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.IRIS_SHADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.OPTIFINE_SHADER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.WORLD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

