/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

public class MurmurHash2 {
    private static boolean isWhiteSpaceCharacter(byte b) {
        return b == 9 || b == 10 || b == 13 || b == 32;
    }

    public static long cfHash(byte[] data, int length) {
        int shiftCount = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (MurmurHash2.isWhiteSpaceCharacter(data[i2])) {
                ++shiftCount;
                continue;
            }
            data[i2 - shiftCount] = data[i2];
        }
        int hash = MurmurHash2.hash32(data, length - shiftCount, 1);
        return (long)hash & 0xFFFFFFFFL;
    }

    public static int hash32(byte[] data, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i2 = 0; i2 < length4; ++i2) {
            int i4 = i2 * 4;
            int k = (data[i4] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }
}

