/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.internal;

import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBlock;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBody;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableCell;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableHead;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableRow;
import dev.dediamondpro.resourcify.libs.commonmark.internal.util.Parsing;
import dev.dediamondpro.resourcify.libs.commonmark.node.Block;
import dev.dediamondpro.resourcify.libs.commonmark.node.Node;
import dev.dediamondpro.resourcify.libs.commonmark.node.SourceSpan;
import dev.dediamondpro.resourcify.libs.commonmark.parser.InlineParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.SourceLine;
import dev.dediamondpro.resourcify.libs.commonmark.parser.SourceLines;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParserFactory;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockContinue;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockStart;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.MatchedBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.ParserState;
import java.util.ArrayList;
import java.util.List;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<SourceLine> rowLines = new ArrayList<SourceLine>();
    private final List<TableCell.Alignment> columns;
    private boolean canHaveLazyContinuationLines = true;

    private TableBlockParser(List<TableCell.Alignment> columns, SourceLine headerLine) {
        this.columns = columns;
        this.rowLines.add(headerLine);
    }

    @Override
    public boolean canHaveLazyContinuationLines() {
        return this.canHaveLazyContinuationLines;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        CharSequence content = state.getLine().getContent();
        int pipe = Parsing.find('|', content, state.getNextNonSpaceIndex());
        if (pipe != -1) {
            if (pipe == state.getNextNonSpaceIndex() && Parsing.skipSpaceTab(content, pipe + 1, content.length()) == content.length()) {
                this.canHaveLazyContinuationLines = false;
                return BlockContinue.none();
            }
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.rowLines.add(line);
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        List<SourceSpan> sourceSpans = this.block.getSourceSpans();
        SourceSpan headerSourceSpan = !sourceSpans.isEmpty() ? sourceSpans.get(0) : null;
        TableHead head = new TableHead();
        if (headerSourceSpan != null) {
            head.addSourceSpan(headerSourceSpan);
        }
        this.block.appendChild(head);
        TableRow headerRow = new TableRow();
        headerRow.setSourceSpans(head.getSourceSpans());
        head.appendChild(headerRow);
        List<SourceLine> headerCells = TableBlockParser.split(this.rowLines.get(0));
        int headerColumns = headerCells.size();
        for (int i2 = 0; i2 < headerColumns; ++i2) {
            SourceLine cell = headerCells.get(i2);
            TableCell tableCell = this.parseCell(cell, i2, inlineParser);
            tableCell.setHeader(true);
            headerRow.appendChild(tableCell);
        }
        Node body = null;
        for (int rowIndex = 2; rowIndex < this.rowLines.size(); ++rowIndex) {
            SourceLine rowLine = this.rowLines.get(rowIndex);
            SourceSpan sourceSpan = rowIndex < sourceSpans.size() ? sourceSpans.get(rowIndex) : null;
            List<SourceLine> cells = TableBlockParser.split(rowLine);
            TableRow row = new TableRow();
            if (sourceSpan != null) {
                row.addSourceSpan(sourceSpan);
            }
            for (int i3 = 0; i3 < headerColumns; ++i3) {
                SourceLine cell = i3 < cells.size() ? cells.get(i3) : SourceLine.of("", null);
                TableCell tableCell = this.parseCell(cell, i3, inlineParser);
                row.appendChild(tableCell);
            }
            if (body == null) {
                body = new TableBody();
                this.block.appendChild(body);
            }
            body.appendChild(row);
            body.addSourceSpan(sourceSpan);
        }
    }

    private TableCell parseCell(SourceLine cell, int column, InlineParser inlineParser) {
        TableCell tableCell = new TableCell();
        SourceSpan sourceSpan = cell.getSourceSpan();
        if (sourceSpan != null) {
            tableCell.addSourceSpan(sourceSpan);
        }
        if (column < this.columns.size()) {
            tableCell.setAlignment(this.columns.get(column));
        }
        CharSequence content = cell.getContent();
        int start = Parsing.skipSpaceTab(content, 0, content.length());
        int end = Parsing.skipSpaceTabBackwards(content, content.length() - 1, start);
        inlineParser.parse(SourceLines.of(cell.substring(start, end + 1)), tableCell);
        return tableCell;
    }

    private static List<SourceLine> split(SourceLine line) {
        int nonSpace;
        CharSequence row = line.getContent();
        int cellStart = nonSpace = Parsing.skipSpaceTab(row, 0, row.length());
        int cellEnd = row.length();
        if (row.charAt(nonSpace) == '|') {
            cellStart = nonSpace + 1;
            int nonSpaceEnd = Parsing.skipSpaceTabBackwards(row, row.length() - 1, cellStart);
            cellEnd = nonSpaceEnd + 1;
        }
        ArrayList<SourceLine> cells = new ArrayList<SourceLine>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i2 = cellStart; i2 < cellEnd; ++i2) {
            char c = row.charAt(i2);
            switch (c) {
                case '\\': {
                    if (i2 + 1 < cellEnd && row.charAt(i2 + 1) == '|') {
                        sb.append('|');
                        ++i2;
                        continue block4;
                    }
                    sb.append('\\');
                    continue block4;
                }
                case '|': {
                    String content = sb.toString();
                    cells.add(SourceLine.of(content, line.substring(cellStart, i2).getSourceSpan()));
                    sb.setLength(0);
                    cellStart = i2 + 1;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            String content = sb.toString();
            cells.add(SourceLine.of(content, line.substring(cellStart, line.getContent().length()).getSourceSpan()));
        }
        return cells;
    }

    private static List<TableCell.Alignment> parseSeparator(CharSequence s) {
        ArrayList<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();
        int pipes = 0;
        boolean valid = false;
        int i2 = 0;
        block5: while (i2 < s.length()) {
            char c = s.charAt(i2);
            switch (c) {
                case '|': {
                    ++i2;
                    if (++pipes > 1) {
                        return null;
                    }
                    valid = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (pipes == 0 && !columns.isEmpty()) {
                        return null;
                    }
                    boolean left2 = false;
                    boolean right = false;
                    if (c == ':') {
                        left2 = true;
                        ++i2;
                    }
                    boolean haveDash = false;
                    while (i2 < s.length() && s.charAt(i2) == '-') {
                        ++i2;
                        haveDash = true;
                    }
                    if (!haveDash) {
                        return null;
                    }
                    if (i2 < s.length() && s.charAt(i2) == ':') {
                        right = true;
                        ++i2;
                    }
                    columns.add(TableBlockParser.getAlignment(left2, right));
                    pipes = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++i2;
                    continue block5;
                }
            }
            return null;
        }
        if (!valid) {
            return null;
        }
        return columns;
    }

    private static TableCell.Alignment getAlignment(boolean left2, boolean right) {
        if (left2 && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left2) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            SourceLine line;
            SourceLine separatorLine;
            List columns;
            List<SourceLine> paragraphLines = matchedBlockParser.getParagraphLines().getLines();
            if (paragraphLines.size() == 1 && Parsing.find('|', paragraphLines.get(0).getContent(), 0) != -1 && (columns = TableBlockParser.parseSeparator((separatorLine = (line = state.getLine()).substring(state.getIndex(), line.getContent().length())).getContent())) != null && !columns.isEmpty()) {
                SourceLine paragraph = paragraphLines.get(0);
                List headerCells = TableBlockParser.split(paragraph);
                if (columns.size() >= headerCells.size()) {
                    return BlockStart.of(new TableBlockParser(columns, paragraph)).atIndex(state.getIndex()).replaceActiveBlockParser();
                }
            }
            return BlockStart.none();
        }
    }
}

