/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.universal.shader;

import com.mojang.blaze3d.vertex.VertexFormat;
import dev.dediamondpro.resourcify.libs.universal.shader.UniformType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R#\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/dediamondpro/resourcify/libs/universal/shader/ShaderTransformer;", "", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "vertexFormat", "", "targetVersion", "<init>", "(Lcom/mojang/blaze3d/vertex/VertexFormat;I)V", "", "originalSource", "transform", "(Ljava/lang/String;)Ljava/lang/String;", "", "attributes", "Ljava/util/List;", "getAttributes", "()Ljava/util/List;", "", "samplers", "Ljava/util/Set;", "getSamplers", "()Ljava/util/Set;", "I", "", "Ldev/dediamondpro/resourcify/libs/universal/shader/UniformType;", "uniforms", "Ljava/util/Map;", "getUniforms", "()Ljava/util/Map;", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "UniversalCraft 1.21.5-forge"})
@SourceDebugExtension(value={"SMAP\nShaderTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderTransformer.kt\ngg/essential/universal/shader/ShaderTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1043#2:180\n1849#2,2:181\n1849#2,2:183\n1783#2,3:185\n*S KotlinDebug\n*F\n+ 1 ShaderTransformer.kt\ngg/essential/universal/shader/ShaderTransformer\n*L\n67#1:180\n68#1:181,2\n79#1:183,2\n137#1:185,3\n*E\n"})
public final class ShaderTransformer {
    @Nullable
    private final VertexFormat vertexFormat;
    private final int targetVersion;
    @NotNull
    private final List<String> attributes;
    @NotNull
    private final Set<String> samplers;
    @NotNull
    private final Map<String, UniformType> uniforms;

    public ShaderTransformer(@Nullable VertexFormat vertexFormat, int targetVersion) {
        this.vertexFormat = vertexFormat;
        this.targetVersion = targetVersion;
        Object[] objectArray = new Integer[]{110, 130, 150};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(this.targetVersion)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.attributes = new ArrayList();
        this.samplers = new LinkedHashSet();
        this.uniforms = new LinkedHashMap();
    }

    @NotNull
    public final List<String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Set<String> getSamplers() {
        return this.samplers;
    }

    @NotNull
    public final Map<String, UniformType> getUniforms() {
        return this.uniforms;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String transform(@NotNull String originalSource) {
        Object object;
        String varyingOut;
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        Ref.ObjectRef source = new Ref.ObjectRef();
        source.element = originalSource;
        source.element = StringsKt.replace$default((String)((String)source.element), (String)"gl_ModelViewProjectionMatrix", (String)"gl_ProjectionMatrix * gl_ModelViewMatrix", (boolean)false, (int)4, null);
        if (this.targetVersion >= 130) {
            source.element = StringsKt.replace$default((String)((String)source.element), (String)"texture2D", (String)"texture", (boolean)false, (int)4, null);
        }
        Map replacements = new LinkedHashMap();
        List transformed = new ArrayList();
        transformed.add("#version " + this.targetVersion);
        boolean frag = StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)"gl_FragColor", (boolean)false, (int)2, null);
        boolean vert = !frag;
        String attributeIn = this.targetVersion >= 130 ? "in" : "attribute";
        String varyingIn = this.targetVersion >= 130 ? "in" : "varying";
        String string = varyingOut = this.targetVersion >= 130 ? "out" : "varying";
        if (frag && this.targetVersion >= 130) {
            transformed.add(varyingOut + " vec4 uc_FragColor;");
            replacements.put("gl_FragColor", "uc_FragColor");
        }
        if (vert && StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)"gl_FrontColor", (boolean)false, (int)2, null)) {
            transformed.add(varyingOut + " vec4 uc_FrontColor;");
            replacements.put("gl_FrontColor", "uc_FrontColor");
        }
        if (frag && StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)"gl_Color", (boolean)false, (int)2, null)) {
            transformed.add(varyingIn + " vec4 uc_FrontColor;");
            replacements.put("gl_Color", "uc_FrontColor");
        }
        if (vert) {
            List newAttributes = new ArrayList();
            ShaderTransformer.transform$replaceAttribute((Ref.ObjectRef<String>)source, replacements, attributeIn, newAttributes, "gl_Vertex", "vec3", "uc_Position", "vec4(uc_Position, 1.0)");
            ShaderTransformer.transform$replaceAttribute$default(source, replacements, attributeIn, newAttributes, "gl_Color", "vec4", null, null, 192, null);
            ShaderTransformer.transform$replaceAttribute$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord0.st", "vec2", "uc_UV0", null, 128, null);
            ShaderTransformer.transform$replaceAttribute$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord1.st", "vec2", "uc_UV1", null, 128, null);
            ShaderTransformer.transform$replaceAttribute$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord2.st", "vec2", "uc_UV2", null, 128, null);
            if (this.vertexFormat != null) {
                Iterable $this$sortedBy$iv = newAttributes;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ ShaderTransformer this$0;
                    {
                        this.this$0 = shaderTransformer;
                    }

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(ShaderTransformer.access$getVertexFormat$p(this.this$0).getElementAttributeNames().indexOf(StringsKt.removePrefix((String)((String)it.getFirst()), (CharSequence)"uc_")));
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ShaderTransformer.access$getVertexFormat$p(this.this$0).getElementAttributeNames().indexOf(StringsKt.removePrefix((String)((String)it.getFirst()), (CharSequence)"uc_"))));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Pair)element$iv;
                    boolean bl = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            } else {
                $this$forEach$iv = newAttributes;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv;
                    element$iv = object.next();
                    it = (Pair)element$iv;
                    boolean bl = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            }
        }
        ShaderTransformer.transform$replaceUniform$default(source, replacements, this, transformed, "gl_ModelViewMatrix", UniformType.Mat4, "ModelViewMat", null, 128, null);
        ShaderTransformer.transform$replaceUniform$default(source, replacements, this, transformed, "gl_ProjectionMatrix", UniformType.Mat4, "ProjMat", null, 128, null);
        for (String line : StringsKt.lines((CharSequence)((CharSequence)source.element))) {
            Object object2;
            List list = transformed;
            if (StringsKt.startsWith$default((String)line, (String)"#version", (boolean)false, (int)2, null)) continue;
            if (StringsKt.startsWith$default((String)line, (String)"varying ", (boolean)false, (int)2, null) && this.targetVersion >= 130) {
                object2 = (frag ? "in " : "out ") + StringsKt.substringAfter$default((String)line, (String)"varying ", null, (int)2, null);
            } else if (StringsKt.startsWith$default((String)line, (String)"uniform ", (boolean)false, (int)2, null)) {
                object = new char[]{';'};
                CharSequence charSequence = StringsKt.trimEnd((String)line, (char[])object);
                object = new String[]{" "};
                List $i$f$forEach = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                String glslType = (String)$i$f$forEach.get(1);
                String name = (String)$i$f$forEach.get(2);
                if (Intrinsics.areEqual((Object)glslType, (Object)"sampler2D")) {
                    this.samplers.add(name);
                    object2 = line;
                } else {
                    this.uniforms.put(name, UniformType.Companion.fromGlsl(glslType));
                    object2 = line;
                }
            } else {
                void $this$fold$iv;
                Iterable $i$f$forEach = replacements.entrySet();
                List list2 = list;
                boolean $i$f$fold = false;
                String accumulator$iv = line;
                for (Object element$iv : $this$fold$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    String acc = accumulator$iv;
                    boolean bl = false;
                    String needle = (String)entry.getKey();
                    String replacement = (String)entry.getValue();
                    accumulator$iv = StringsKt.replace$default((String)acc, (String)needle, (String)replacement, (boolean)false, (int)4, null);
                }
                object2 = accumulator$iv;
                list = list2;
            }
            list.add(object2);
        }
        return CollectionsKt.joinToString$default((Iterable)transformed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final void transform$replaceAttribute(Ref.ObjectRef<String> source, Map<String, String> replacements, String attributeIn, List<Pair<String, String>> newAttributes, String needle, String type2, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)needle, (boolean)false, (int)2, null)) {
            replacements.put(needle, replacement);
            newAttributes.add((Pair<String, String>)TuplesKt.to((Object)replacementName, (Object)(attributeIn + " " + type2 + " " + replacementName + ";")));
        }
    }

    static /* synthetic */ void transform$replaceAttribute$default(Ref.ObjectRef objectRef, Map map2, String string, List list, String string2, String string3, String object, String string4, int n, Object object2) {
        if ((n & 0x40) != 0) {
            object = "uc_" + StringsKt.substringAfter$default((String)string2, (String)"_", null, (int)2, null);
        }
        if ((n & 0x80) != 0) {
            string4 = object;
        }
        ShaderTransformer.transform$replaceAttribute((Ref.ObjectRef<String>)objectRef, map2, string, list, string2, string3, (String)object, string4);
    }

    private static final void transform$replaceUniform(Ref.ObjectRef<String> source, Map<String, String> replacements, ShaderTransformer this$0, List<String> transformed, String needle, UniformType type2, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)needle, (boolean)false, (int)2, null)) {
            replacements.put(needle, replacement);
            if (!this$0.uniforms.containsKey(replacementName)) {
                this$0.uniforms.put(replacementName, type2);
                transformed.add("uniform " + type2.getGlslName() + " " + replacementName + ";");
            }
        }
    }

    static /* synthetic */ void transform$replaceUniform$default(Ref.ObjectRef objectRef, Map map2, ShaderTransformer shaderTransformer, List list, String string, UniformType uniformType, String string2, String string3, int n, Object object) {
        if ((n & 0x80) != 0) {
            string3 = string2;
        }
        ShaderTransformer.transform$replaceUniform((Ref.ObjectRef<String>)objectRef, map2, shaderTransformer, list, string, uniformType, string2, string3);
    }

    public static final /* synthetic */ VertexFormat access$getVertexFormat$p(ShaderTransformer $this) {
        return $this.vertexFormat;
    }
}

