/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui;

import dev.dediamondpro.resourcify.config.Config;
import dev.dediamondpro.resourcify.libs.elementa.ElementaVersion;
import dev.dediamondpro.resourcify.libs.elementa.WindowScreen;
import dev.dediamondpro.resourcify.libs.universal.UKeyboard;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.libs.universal.UResolution;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\nJ\u000f\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "Ldev/dediamondpro/resourcify/libs/elementa/WindowScreen;", "", "adaptScale", "", "minimumWidth", "<init>", "(ZF)V", "", "onTick", "()V", "", "keyCode", "", "typedChar", "Ldev/dediamondpro/resourcify/libs/universal/UKeyboard$Modifiers;", "modifiers", "onKeyPressed", "(ICLdev/dediamondpro/resourcify/libs/universal/UKeyboard$Modifiers;)V", "", "mouseX", "mouseY", "mouseButton", "onMouseClicked", "(DDI)V", "goBack", "goForward", "Z", "F", "defaultScale", "I", "Companion", "Resourcify (1.21.4-neoforge)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nPaginatedScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatedScreen.kt\ndev/dediamondpro/resourcify/gui/PaginatedScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public abstract class PaginatedScreen
extends WindowScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean adaptScale;
    private final float minimumWidth;
    private int defaultScale;
    private static boolean replacingScreen;
    @NotNull
    private static final List<Screen> backScreens;
    @NotNull
    private static final List<Screen> forwardScreens;

    public PaginatedScreen(boolean adaptScale, float minimumWidth) {
        super(ElementaVersion.V10, false, true, false, 0, 26, null);
        this.adaptScale = adaptScale;
        this.minimumWidth = minimumWidth;
        this.defaultScale = -1;
        if (!replacingScreen) {
            Screen screen = UScreen.Companion.getCurrentScreen();
            if (screen != null) {
                Screen it = screen;
                boolean bl = false;
                backScreens.add(it);
            }
            forwardScreens.clear();
        }
    }

    public /* synthetic */ PaginatedScreen(boolean bl, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            f = 500.0f;
        }
        this(bl, f);
    }

    @Override
    public void onTick() {
        int updatedScale;
        if (!this.adaptScale) {
            super.onTick();
            return;
        }
        if (this.defaultScale == -1) {
            this.defaultScale = UMinecraft.getGuiScale();
        }
        if ((updatedScale = PaginatedScreen.Companion.getGuiScale(this.defaultScale, this.minimumWidth)) != (int)UResolution.getScaleFactor()) {
            this.setNewGuiScale(updatedScale);
            this.updateGuiScale();
            UMinecraft.setGuiScale(updatedScale);
            Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type net.minecraft.client.gui.screens.Screen");
            ((Screen)this).width = UResolution.getScaledWidth();
            ((Screen)this).height = UResolution.getScaledHeight();
        }
        super.onTick();
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.getWindow().getFocusedComponent() == null && keyCode == UKeyboard.KEY_ESCAPE) {
            this.goBack();
        } else {
            super.onKeyPressed(keyCode, typedChar, modifiers);
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 3: {
                this.goBack();
                break;
            }
            case 4: {
                this.goForward();
                break;
            }
            default: {
                super.onMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void goBack() {
        Screen backScreen = (Screen)CollectionsKt.removeLastOrNull(backScreens);
        if (backScreen instanceof PaginatedScreen) {
            forwardScreens.add(this);
        } else {
            Companion.cleanUp();
        }
        UScreen.Companion.displayScreen(backScreen);
    }

    public void goForward() {
        Screen screen = (Screen)CollectionsKt.removeLastOrNull(forwardScreens);
        if (screen == null) {
            return;
        }
        Screen forwardScreen = screen;
        backScreens.add(this);
        UScreen.Companion.displayScreen(forwardScreen);
    }

    public PaginatedScreen() {
        this(false, 0.0f, 3, null);
    }

    static {
        backScreens = new ArrayList();
        forwardScreens = new ArrayList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001b\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen$Companion;", "", "<init>", "()V", "", "cleanUp", "Lkotlin/Function0;", "Lnet/minecraft/client/gui/screens/Screen;", "screen", "replaceScreen", "(Lkotlin/jvm/functions/Function0;)V", "", "defaultScale", "", "target", "getGuiScale", "(IF)I", "guiScale", "calculateScaleFactor", "(I)I", "", "replacingScreen", "Z", "", "backScreens", "Ljava/util/List;", "getBackScreens", "()Ljava/util/List;", "forwardScreens", "getForwardScreens", "Resourcify (1.21.4-neoforge)-1.7.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Screen> getBackScreens() {
            return backScreens;
        }

        @NotNull
        public final List<Screen> getForwardScreens() {
            return forwardScreens;
        }

        public final void cleanUp() {
            this.getBackScreens().clear();
            this.getForwardScreens().clear();
            NetworkUtil.INSTANCE.clearCache();
        }

        public final void replaceScreen(@NotNull Function0<? extends Screen> screen) {
            Intrinsics.checkNotNullParameter(screen, (String)"screen");
            replacingScreen = true;
            UScreen.Companion.displayScreen((Screen)screen.invoke());
            replacingScreen = false;
        }

        private final int getGuiScale(int defaultScale, float target) {
            if (Config.Companion.getInstance().getGuiScale() != -1) {
                return RangesKt.coerceIn((int)Config.Companion.getInstance().getGuiScale(), (int)1, (int)10);
            }
            int minScale = (int)Math.floor((float)UResolution.getWindowWidth() / target);
            return RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)minScale, (int)1), (int)this.calculateScaleFactor(defaultScale));
        }

        private final int calculateScaleFactor(int guiScale) {
            Minecraft mc = UMinecraft.getMinecraft();
            return mc.getWindow().calculateScale(guiScale, mc.isEnforceUnicode());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

